/* uuname - print remote site names, or change local UUCP name.
 *
 * Version 1.2 of 31 October 1991.
 *
 * Written by C W Rose.
 */

#include <sys/types.h>
#include <ctype.h>
#include <errno.h>
#include <pwd.h>
#include <stdio.h>
#ifdef _MINIX
#undef NULL
#include <stdlib.h>
#endif
#include <string.h>
#include <unistd.h>
#include "uucp.h"

#define FALSE		 0
#define TRUE	    ~FALSE
#define OK		 1
#define FAILED		-1
#define SAME		 0
#define MAXSITES       100	/* maximum number of known sites */

#ifndef lint
static char *Version = "@(#) uuname 1.2 (31 October 1991)";
#endif

/* Global variables */

int opt_l = FALSE;
int opt_v = FALSE;
int opt_S = FALSE;

int errno;			/* used by errno.h */

char progname[20];

struct sitename {
	char *uucpname;		/* uucp node name */
	char *realname;		/* human name */
} sitelist[MAXSITES];

/* Externals */

/* Used by getopt(3) package */
extern int getopt(), optind, opterr, optopt;
extern char *optarg;

/* Forward references */

unsigned char get_gid();
uid_t get_uid();
int sortlist();
void usage();


/*
 * g e t _ g i d
 *
 * Get the group id corresponding to the given name
 *
 * Return:	gid	Success
 *		~0	Otherwise
 */
unsigned char get_gid(user)
char *user;
{
  struct passwd *pw;

  if ((pw = getpwnam(user)) != (struct passwd *)NULL)
	return(pw->pw_gid);
  else 
	return(~0);
}


/*
 * g e t _ u i d
 *
 * Get the user id corresponding to the given name
 *
 * Return:	uid	Success
 *		~0	Otherwise
 */
uid_t get_uid(user)
char *user;
{
  struct passwd *pw;

  if ((pw = getpwnam(user)) != (struct passwd *)NULL)
	return(pw->pw_uid);
  else 
	return((uid_t) ~0);
}


/*
 * m a i n
 *
 * Main program
 */
int main(argc, argv)
int argc ; char *argv[] ;
{
  char *cp, reality[132], tempbuff[256], buff[BUFSIZ];
  int j, k, fdnode, total, flg;
  unsigned int len;
  uid_t f_uid;
  gid_t f_gid;
  FILE *fplsys;

  if ((cp = strrchr(argv[0], '/')) == (char *)NULL) cp = argv[0];
  strncpy(progname, cp, 19);		/* current program name */

  /* parse arguments */
  opterr = 0;
  while ((j = getopt(argc, argv, "lvS:")) != EOF) {
	switch (j & 0177) {
	case 'l':
		opt_l = TRUE;
		break;
	case 'v':
		opt_v = TRUE;
		break;
	case 'S':
		strncpy(buff, optarg, 131);
		opt_S = TRUE;
		break;
	case '?':
	default:
		usage();
		exit(1);
	}
  }

  if (opt_S) {
	for (j = optind ; j < argc ; j++) {
		strcat(buff, " ");
		strcat(buff, argv[j]);
		if (strlen(buff) > 256) {
			fprintf(stderr, "uuname: entry too long.\n");
			exit(1);
		}
	}
  }

  /* check that we are allowed to change sitename, and that new name is valid */
  if (opt_S) {
	if (getuid() != 0) {
		fprintf(stderr, "uuname: option available only to super-user.\n");
		exit(1);
	}
	for (j = 0 ; j < 132 ; j++) {
		if (buff[j] == ' ' || buff[j] == '\t' || buff[j] == '\0')
			break;
	}
	if (j >= SITELEN) {
		buff[j] = '\0';
		fprintf(stderr, "uuname: name %s can have at most %d characters\n",
							buff, SITELEN);
		exit(1);
	}
	if (!isalpha(buff[0])) {
		buff[j] = '\0';
		fprintf(stderr, "uuname: name %s must start with a letter\n", buff);
		exit(1);
	} 
  }

  /* change the local site name */
  if (opt_S) {
	(void) setuid(getuid());	/* reset euid to root */
	(void) unlink(NODENAME);	/* creat won't change existing perms */
	if ((fdnode = creat(NODENAME, 0444)) == -1) {
		fprintf(stderr, "uuname: cannot create %s\n", NODENAME);
		exit(1);
	}
	len = strlen(buff);
	if (write(fdnode, buff, len) != len) {
		fprintf(stderr, "uuname: cannot write to %s\n", NODENAME);
		(void) close(fdnode);
		exit(1);
	}
	(void) close(fdnode);
	f_uid = get_uid("uucp");
	f_gid = get_gid("bin");
	if (f_uid == (uid_t) ~0 || f_gid == (gid_t) ~0 ||
			chown(NODENAME, (int) f_uid, (int) f_gid) == -1) {
		fprintf(stderr, "uuname: cannot chown %s\n", NODENAME);
		exit(1);
	}
  }
  /* report the local site name */
  else if (opt_l) {
	if ((fdnode = open(NODENAME, 0)) != -1) {
		if ((k = read(fdnode, buff, BUFSIZ)) > 0) {
			buff[k] = '\0';
			if (!opt_v) {
				buff[SITELEN] = '\0';
				for (j = 0 ; j < k ; j++) {
					if (buff[j] == ' ' ||
							buff[j] == '\t' ||
							buff[j] == '\n' ||
							buff[j] == '\0')
						break;
				}
				buff[j] = '\0';
			}
			printf("%s\n", buff);
		}
		else
			fprintf(stderr, "uuname: cannot read %s\n", NODENAME);
		(void) close(fdnode);
	}
	else
		fprintf(stderr, "uuname: cannot open %s\n", NODENAME);
  }
  /* report all the known remote sites */
  else {
	if ((fplsys = fopen(LSYS, "r")) != (FILE *)NULL) {
		total = 0;
		flg = FALSE;
		while (total < MAXSITES && fgets(buff, BUFSIZ, fplsys) != (char *)NULL) {
			while ((k = strlen(buff)) < (BUFSIZ - 132) &&
					buff[k - 2] == '\\' &&
					fgets(tempbuff, 131, fplsys) !=
					(char *)NULL) {
				buff[k - 2] = '\0';
				strcat(buff, tempbuff);
			}
			/* lose junk */
			if (buff[0] == '\n') {
				flg = FALSE;
				continue;
			}
			/* get a real name */
			if (buff[0] == '#') {
				if (buff[1] == ':') {
					strncpy(reality, buff + 2, 131);
					len = strlen(reality) - 1;
					if (reality[len] == '\n')
						reality[len] = '\0';
					flg = TRUE;
				}
				else
					flg = FALSE;
				continue;
			}

			/* get a site name */
			for (j = 0 ; j < SITELEN ; j++) {
				if (buff[j] == ' ' || buff[j] == '\t' ||
							buff[j] == '\n')
					buff[j] = '\0';
				if (buff[j] == '\0')
					break;
			}

			/* add the uucpname to the current record */
			if ((sitelist[total].uucpname =
			(char *) calloc(SITELEN + 1, sizeof(char))) == (char *)NULL) {
				fprintf(stderr, "uuname: calloc failed\n");
				exit(1);
			}
			else
				strncpy(sitelist[total].uucpname, buff, SITELEN);

			/* add the real name to the current record */
			if (flg) {
				len = strlen(reality);
				if ((sitelist[total].realname =
				(char *) calloc(len + 1, sizeof(char))) == (char *)NULL) {
					fprintf(stderr,
						"uuname: calloc failed\n");
					exit(1);
				}
				else
					strncpy(sitelist[total].realname,
							reality, len);
			}
			else
				sitelist[total].realname = (char *)NULL;

			flg = FALSE;
			total++;
		}
		(void) fclose(fplsys);
		(void) sortlist(total);
		for (j = 0 ; j < total ; j++) {
			if (!opt_v || sitelist[j].realname == (char *)NULL)
				printf("%s\n", sitelist[j].uucpname);
			else
				printf("%-15s - %s\n", sitelist[j].uucpname,
					sitelist[j].realname);
		}
	}
	else {
		fprintf(stderr, "uuname: cannot open %s\n", LSYS);
		exit(1);
	}
  }

  exit(0);
  /* NOTREACHED */
}


/* 
 * s o r t l i s t
 *
 * Sort site list by name
 *
 * Return:	OK	Always
 */
int sortlist(total)
int total;
{
  char *bp, *cp;
  int j, k, gap;

  /* shell sort */
  gap = 1;
  while (gap <= total) gap = 3 * gap + 1;

  for (gap /= 3 ; gap > 0 ; gap /= 3 ) {
 	for (j = gap ; j < total ; j++) { 
		bp = sitelist[j].uucpname;
		cp = sitelist[j].realname;
		for (k = j ;
		k >= gap &&
		strncmp(sitelist[k - gap].uucpname, bp, SITELEN) > 0 ;
		k -= gap) {
			sitelist[k].uucpname = sitelist[k - gap].uucpname;
			sitelist[k].realname = sitelist[k - gap].realname;
		}
		sitelist[k].uucpname = bp;
		sitelist[k].realname = cp;
	}
  }

  return(OK);
}


/*
 * u s a g e
 *
 * Usage message
 */
void usage()
{
  fprintf(stderr, "Usage: %s [-l] [-v] [-S name]\n", progname);
}

