/* uucp.h - header for all files in UUCP package.
 *
 * UUCP.H	DCP: A UUCP clone.
 * 		Definitions for the UUCP package
 *
 * Copyright Richard H. Lamb 1985,1986,1987
 * Copyright S. R. Sampson, August 1989
 * Copyright F. N. G. van Kempen Jul-Dec '89
 * Additions by C W Rose 1990-1991
 *
 * Version 1.2 of 31 October 1991.
 */

/* Everyone needs the patch level */

#include "patchlevel.h"

/* Add test code */

#undef TEST		/* test code added */
#undef TESTDBG		/* debugging level set iaw DEFAULT.DBG file */

/* Code selection options */

#define IDCHK		/* restrict some options to UUCPADM and uids < MAXUID */
#define UUMAX	2	/* maximum number of simultaneous uucicos */
#undef LNKFLG		/* link, rather than copy, data files */
#define MAILWAIT	/* wait for mail to complete before continuing */
#define GOODREP		/* report uuxqt good status by default */

/* Things your mother never told you */

#ifdef _MINIX
#define B19200		192		/* not defined in sgtty.h */
#define TTY		sgttyb		/* ioctl structure */
#define TTYGET		TIOCGETP	/* get a tty structure */
#define TTYSET		TIOCSETP	/* set a tty structure */
#define TTYFLUSH	TIOCFLUSH	/* flush a tty queue */
typedef void (*sig_t)();
#endif

#ifdef _SVR2
#define TTY		termio		/* ioctl structure */
#define TTYGET		TCGETA		/* get a tty structure */
#define TTYSET		TCSETA		/* set a tty structure */
#define TTYFLUSH	TCFLSH		/* flush a tty queue */
typedef int (*sig_t)();

/* pretend to be Minix */
#define S_IROTH		00004		/* from sys/stat.h */
#define IBM_PC		1		/* from minix/config.h */
#define MACHINE		~IBM_PC		/* not hardly */
#define HZ		60		/* from minix/const.h */
#define WTERMSIG(s)	((s) & 0177)	/* from sys/wait.h */
#define WEXITSTATUS(s)	(((s) >> 8) & 0377)
typedef int uid_t;
typedef int gid_t;
typedef long int clock_t;
struct utimbuf { time_t actime ; time_t modtime ; };
struct passwd *getpwent(), *getpwuid(), *getpwnam();
struct group *getgrent(), *getgrgid();
char *getcwd(), *getenv();
#endif

/* Standard paths and filenames */

#define PICKDIR		"/usr/spool/uucppublic/receive"
#define PUBDIR		"/usr/spool/uucppublic"
#define SPOOLDIR	"/usr/spool/uucp"
#define XQTDIR		"/usr/spool/uucp/.XQTDIR"
#undef DEVDIR
#define DEVDIR		"/dev"

#define SHELL		"/bin/sh"
#define MKDIR		"/usr/bin/mkdir"
#define MOVE		"/usr/bin/mv"
#define PS		"/usr/bin/ps"
#define UUCICO		"/usr/lib/uucp/uucico"
#define UUCP		"/usr/lib/uucp/uucp"
#define UUX		"/usr/lib/uucp/uux"
#define UUXQT		"/usr/lib/uucp/uuxqt"
#define UUXPATH		"PATH=/bin:/usr/bin"
#define UUXUSER		"LOGNAME=uucp"

#define MODEMCAP	"/etc/modemcap"
#define RMAIL		"/usr/local/bin/rmail"		/* Remote Mailer */
#define LMAIL		"/usr/local/bin/lmail"		/* Local Mailer */
#define NEWSLOG		"/usr/lib/news/log"		/* NEWS log file */

#ifdef TESTDBG
#define DEFDBG		"/usr/lib/uucp/DEFAULT.DBG"
#endif
#define LDEVS		"/usr/lib/uucp/L-devices"
#define LCMDS		"/usr/lib/uucp/L-cmds"
#define LDIAL		"/usr/lib/uucp/L-dialcodes"
#define LSUB		"/usr/lib/uucp/L_sub"
#define LSTAT		"/usr/lib/uucp/L_stat"
#define LSYS		"/usr/lib/uucp/L.sys"
#define RSTAT		"/usr/lib/uucp/R_stat"
#define RSUB		"/usr/lib/uucp/R_sub"
#define SEQF		"/usr/lib/uucp/SEQF"
#define SQFILE		"/usr/lib/uucp/SQFILE"
#define NODENAME	"/usr/lib/uucp/SYSTEMNAME"
#define LTMPATH		"/usr/lib/uucp/TM."
#define USERFILE	"/usr/lib/uucp/USERFILE"

#define AUDLOG		"/usr/spool/uucp/AUDIT"
#define ERRLOG		"/usr/spool/uucp/ERRLOG"
#define FOREIGN		"/usr/spool/uucp/FOREIGN"
#define LCKPATH		"/usr/spool/uucp/LCK.."
#define LCKAUD		"/usr/spool/uucp/LCK.AUD"
#define LCKLOG		"/usr/spool/uucp/LCK.LOG"
#define LCKLSTAT	"/usr/spool/uucp/LCK.LSTAT"
#define LCKLSUB		"/usr/spool/uucp/LCK.LSUB"
#define LCKRSTAT	"/usr/spool/uucp/LCK.RSTAT"
#define LCKRSUB		"/usr/spool/uucp/LCK.RSUB"
#define LCKSEQ		"/usr/spool/uucp/LCK.SEQ"
#define LCKSQ		"/usr/spool/uucp/LCK.SQ"
#define LCKUU		"/usr/spool/uucp/LCK.UU0"
#define LCKXQT		"/usr/spool/uucp/LCK.XQT"
#define LOGFILE		"/usr/spool/uucp/LOGFILE"
#define STSTPATH	"/usr/spool/uucp/STST."
#define SYSLOG          "/usr/spool/uucp/SYSLOG"
#define TMPATH		"/usr/spool/uucp/TM."

/* Miscellaneous strings and constants */

#define UUCPADM		"uucpadm"	/* UUCP administrator login */
#define NODATAFN	"D.0"		/* default data file name */
#define MAXUID		4		/* maximum uid permitted to use -x */
#define LOCKLEN		32		/* maximum length of lock file path */
#define MAXARGS		30		/* maximum number of args to parse */
#define MAXCMDS		100		/* maximum C. files in SPOOLDIR */
#define MAXXQTS		100		/* maximum X. files in SPOOLDIR */
#define MSGLEN		256		/* maximum protocol message length */
#define SITELEN		7		/* maximum length of site names */
#define USERLEN		9		/* maximum length of user names */
#define PSPID		3		/* index of pid in ps(1) output */
#define WAIT		30		/* general purpose timeout */
#define BADSIG		(sig_t)-1	/* failed return from signal(2) */

/* L.sys field defines. */

#define F_SYSTEM	0		/* system name */
#define F_CCTIME	1		/* legal call times */
#define F_CLASS		2		/* device,(protocol) */
#define F_SPEED		3		/* baud rate */
#define F_PHONE		4		/* phone number */
#define F_EXPECT	5		/* first login "expect" field */
#define F_SEND		6		/* first login "send" field */

/* L-devices field defines */

#define F_DEVICE	0		/* class of device */
#define F_DATAPORT	1		/* data port name */
#define F_DIALPORT	2		/* dialler port/modem name */
					/* baud rate (usually) */
#define F_DTYPE		4		/* type of dialler */
#define F_DTOKEN	5		/* dialcode translation */

/* Task status messages */

#define ERR_MSG		1
#define QD_MSG		10
#define OK_MSG		13

#define ET_NOTKNOWN	1	/* unknown reason for failure */
#define ET_LTMP		2	/* cannot create local temp file */
#define ET_LDIR		4	/* cannot access local directory */
#define ET_LACCESS	8	/* cannot access local file */
#define ET_RTMP		16	/* cannot create remote temp file */
#define ET_RDIR		32	/* cannot access remote directory */
#define ET_RACCESS	64	/* cannot access remote file */
#define ET_BADCMD	128	/* bad uucp command */
#define ET_BADUUCP	256	/* cannot execute uucp */
#define ET_QUEUED	512	/* job is queued */
#define ET_FAIL		1024	/* copy failed */
#define ET_PARTIAL	2048	/* copy partly succeeded */
#define ET_DONE		4096	/* copy finished, job deleted */
#define ET_HERE		8192	/* work done, job here */
#define ET_KINC		16384	/* job killed (incomplete) */
#define ET_KILLED	32768	/* job killed (complete) */

/* Call status messages */

#define EC_BADSYS	1	/* system name not in L.sys */
#define EC_WTIME	2	/* wrong time to call */
#define EC_LCKSYS	4	/* system locked */
#define EC_NODEV	8	/* no device available */
#define EC_DFAIL	16	/* dial failed */
#define EC_LFAIL	32	/* login failed */
#define EC_CALLOK	64	/* call succeeded */
#define EC_CBACK	128	/* callback required */
#define EC_HFAIL	256	/* handshake failed */
#define EC_SFAIL	512	/* startup failed */
#define EC_CFAIL	1024	/* conversation failed */
#define EC_CPROG	2048	/* conversation in progress */
#define EC_CONOK	4096	/* conversation succeeded */

/* Statistics file record structures */

struct rstatrec {
  int job;			/* job sequence number */
  char user[USERLEN + 1];	/* user name */
  char site[SITELEN + 1];	/* site name */
  time_t time_a;		/* command time (uucp) */
  time_t time_b;		/* status time (uucico) */
  int code;			/* job status code */
};

struct lstatrec {
  char site[SITELEN + 1];	/* site name */
  time_t time_a;		/* time of last call */
  time_t time_b;		/* time of last successful call */
  int code;			/* job status code */
};

struct rsubrec {
  char site[SITELEN + 1];	/* site name */
  int sfile;			/* number of files sent */
  long int sbyte;		/* number of bytes sent */
  int rfile;			/* number of files received */
  long int rbyte;		/* number of bytes received */
};

struct lsubrec {
  char site[SITELEN + 1];	/* site name */
  int all_calls;		/* total number of calls made */
  int ok_calls;			/* total number of successful calls */
  time_t time_a;		/* time of last call */
  time_t time_b;		/* time of last successful call */
  int dev_calls;		/* number of failures at device level */
  int log_calls;		/* number of failures at logon level */
  int nack_calls;		/* number of failures at protocol level */
  int rem_calls;		/* remaining failures */
};

/* EOF */

