/* uucico4.c
 *
 * Version 4.2 of 31 October 1991.
 */

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#ifdef _MINIX
#include <sgtty.h>
#endif
#include <signal.h>
#include <stdio.h>
#ifdef _MINIX
#undef NULL
#include <stdlib.h>
#endif
#include <string.h>
#ifdef _SVR2
#include <termio.h>
#endif
#include <time.h>
#include <unistd.h>
#ifdef _SVR2
#include <ustat.h>
#endif
#include "dial.h"
#include "uucp.h"
#include "uucico.h"


/*
 * u n l o c k
 *
 * Remove a lockfile, update the lock file list
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int unlock(file)
char *file;
{
  int j, flg;

  j = 0;
  flg = FAILED;
  while (j < MAXLOCKS) {
	if (locklist[j][0] != '\0' && strcmp(locklist[j], file) == SAME) {
		(void) unlink(locklist[j]);
		locklist[j][0] = '\0';
		flg = OK;
		break;
	}
	j++;
  }

  return(flg);
}


/*
 * u s a g e
 *
 * Usage message
 *
 */
void usage()
{
  fprintf(stderr, "Usage: %s -s|S sys [-r #] [-TU] [-x #]\n", progname);
}


/*
 * u s e r c h e c k
 *
 * Check the user file
 *
 * Return:	OK		Valid entry found
 *		FAILED  	No valid entry found
 *		cbflg, userpath are updated as side effects
 */
int usercheck(site, user)
char *site, *user;
{
  char *cp, *bp, tsite[20], tuser[20], tflag[20], buff[256];
  int j, level, flg;
  FILE *fp;

  printmsg(M_CALLMSG, "usercheck: checking site |%s|, user |%s|", site, user);

  if ((fp = fopen(USERFILE, "r")) == (FILE *)NULL) {
	strncpy(userpath, "/", 255);
	return(OK);
  }

  level = 0;
  while (level < 4 && fgets(buff, 255, fp) != (char *)NULL) {
	tsite[0] = tuser[0] = tflag[0] = '\0';
	/* the trailing newline only confuses things */
	j = strlen(buff) - 1;
	if (buff[j] == '\n') buff[j] = '\0';
	if (buff[0] == '\0') continue;

	/* lose leading whitespace */
	cp = buff;
	while (isspace(*cp))
		cp++;

	/* we have a ',' or a username or junk */  
	if (*cp == ',')
		cp++;
	else if (isalpha(*cp)) {
		bp = tuser;
		while (isalpha(*cp) && (bp - tuser) < 20)
			*bp++ = *cp++;			
		*bp = '\0';
		while (isspace(*cp))
			cp++;
		if (*cp++ != ',')
			continue;
	}
	else
		continue;

	/* we have a sitename, a callback flag, a path, or junk */
	while (isspace(*cp))
		cp++;
	bp = tsite;
	while (isalpha(*cp) && (bp - tsite) < 20)
		*bp++ = *cp++;			
	*bp = '\0';
	while (isspace(*cp))
		cp++;
	bp = tflag;
	while (*cp != '/' && isalpha(*cp) && (bp - tflag) < 20)
		*bp++ = *cp++;			
	*bp = '\0';
	while (isspace(*cp))
		cp++;

	/* we now have a path, or junk */
	if (*cp != '/') continue;

	/* sort out site and callback entries */
	if (strcmp(tsite, "c") == SAME) {
		strcpy(tsite, "");
		strcpy(tflag, "c");
	}

	/* set callback flag */
	if (strcmp(tflag, "c") == SAME)
		flg = TRUE;
	else
		flg = FALSE;

	printmsg(M_CALLMSG, "usercheck: found user |%s| site |%s| flag %s",
			tuser, tsite, flg ? "TRUE" : "FALSE");

	/* we have a valid entry; is it relevant ? */
	if (level < 1 && strcmp("", tsite) == SAME &&
						strcmp("", tuser) == SAME) {
		strncpy(userpath, cp, 255);
		level = 1;
	}
	else if (level < 2 && strcmp("", tsite) == SAME &&
						strcmp(user, tuser) == SAME) {
		strncpy(userpath, cp, 255);
		level = 2;
	}
	else if (level < 3 && strcmp(site, tsite) == SAME &&
						strcmp("", tuser) == SAME) {
		strncpy(userpath, cp, 255);
		level = 3;
	}
	else if (level < 4 && strcmp(site, tsite) == SAME &&
						strcmp(user, tuser) == SAME) {
		strncpy(userpath, cp, 255);
		level = 4;
	}
  }
  (void) fclose(fp);

  printmsg(M_CALLMSG, "usercheck: exit level %d, userpath |%s|", level, userpath);

  if (role == SLAVE && level > 0)
	cbflg = flg;
  if (level == 0)
	return(FAILED);
  else
	return(OK);
}


/*
 * v i s i b
 *
 * Prints the buffer of character data in "visible" format.
 *
 * Return:	A pointer to the data buffer
 *
 * Printable characters (except '\') are printed as themselves,
 * special control characters (CR, LF, BS, HT) are printed in the usual
 * escape format, and others are printed using 3-digit octal escapes.
 * The usual warning about a return value which points to a static buffer
 * which is overwritten on each call applies here.
 */
char *visib(data, len)
char *data; size_t len;
{
  static char buff[4 * MSGLEN];
  char c, *p;

  if (len > MSGLEN) len = MSGLEN;
  p = buff;
  while (len--) {
	c = *data++;
	if (isascii(c) && (isprint(c) || ' ' == c)) *p++ = c;
	  else if ('\n' == c) {
		*p++ = '\\';
		*p++ = 'n';
       	  } else if ('\t' == c) {
		*p++ = '\\';
		*p++ = 't';
          } else if ('\r' == c) {
		*p++ = '\\';
		*p++ = 'r';
         } else if ('\b' == c) {
		*p++ = '\\';
		*p++ = 'b';
         } else {
		sprintf(p, "\\%03o", c);
		p += 4;
        }
  }
  *p = '\0';
  return(buff);
}


/*
 * w m e s g
 *
 * write a ^P message to UUCP
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 *
 * This message may be ^P ... ^@ or ^P ... ^J bracketed.
 */
int wmesg(msg, out)
char *msg; int out;
{
  char buff[MSGLEN + 2];
  size_t len;

  printmsg(M_CALL, "wmesg: %s", msg);

  /* add the message delimiters */
  len = strlen(msg) + 2;
  buff[0] = framefirst;
  strncpy(buff + 1, msg, MSGLEN);
  buff[len - 1] = framelast;

  if (swrite(buff, len) == -1)
	return(FAILED);
  else
	return(OK);
}


/* 
 * w r i t e c o n n 
 *
 * Add connection data to an R_stat or L_stat entry.
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int writeconn(file)
char *file;
{
  char lockfile[132], buff[BUFSIZ];
  int j, fd, choice, zflg, flg;
  size_t len;
  struct stat statbuf;
  struct rstatrec *rstat;
  struct lstatrec *lstat;

  printmsg(M_CALL, "writeconn: file %s", file);

  if (strcmp(file, RSTAT) == SAME) {
	choice = 1;
	len = sizeof(struct rstatrec);
	rstat = (struct rstatrec *)buff;
	strncpy(lockfile, LCKRSTAT, 131);
  }
  else if (strcmp(file, LSTAT) == SAME) {
	choice = 2;
	len = sizeof(struct lstatrec);
	lstat = (struct lstatrec *)buff;
	strncpy(lockfile, LCKLSTAT, 131);
  }
  else
	return(FAILED);	/* unknown file */

  if (access(file, 0) == -1) return (OK);	/* no file, don't bother */

  /* try to lock the file to add new data */
  if (checklock(lockfile, 2) == FAILED) return(FAILED);
  if ((fd = open(file, O_RDWR, 0600)) == -1) {
	(void) unlock(lockfile);
	return(FAILED);
  }

  /* see if the file is zero length */
  if (fstat(fd, &statbuf) != 0) {
	(void) close(fd);
	(void) unlock(lockfile);
	return(FAILED);
  }
  if (statbuf.st_size == (off_t)0)
	zflg = TRUE;
  else
	zflg = FALSE;
  /* uucp must prepare RSTAT, LSTAT entries */
  if (zflg && (choice == 1 || choice == 2)) {
	(void) close(fd);
	(void) unlock(lockfile);
	return(FAILED);
  }
	
  /* R_stat format: job_no user site command_time status_time status_code
   * L_stat format: site status_time success_time status_code
   */

  /* find the right position in the file */
  printmsg(M_CALL, "writeconn: matching file %s, choice %d, job %d, rmtsite %s",
		file, choice, jobnum, rmtsite);
  flg = FALSE;
  *(int *)buff = 0;
  while (!zflg && !flg && (j = read(fd, buff, len)) != 0 && j != -1) {
	if ((choice == 1 && rstat->job == jobnum) ||
			(choice > 1 && strncmp(buff, rmtsite, SITELEN) == SAME)) {
		/* move file pointer to start of current record */
		if (lseek(fd, -((off_t)len), 1) == -1) {
			(void) close(fd);
			(void) unlock(lockfile);
			return(FAILED);
		}
		flg = TRUE;
	}
  }
  if (!flg) {
	if (choice == 1)
		printmsg(M_CALL, "writeconn: job %d not found in R_stat file",
								jobnum);
	else
		printmsg(M_CALL, "writeconn: site %s not found in L_stat file",
								rmtsite);
	(void) close(fd);
	(void) unlock(lockfile);
	return(FAILED);
  }

  /* update current record */
  if (zflg) for (j = 0 ; j < BUFSIZ ; j++) buff[j] = '\0';
  printmsg(M_CALL, "writeconn: buffer |%s|%smatched",
		visib(buff, len), flg ? " " : " not ");
  switch (choice) {
	case 1:		/* R_stat file */
	/*
	 * these have already been written by uucp
	 *	rstat->job = jobnum;
	 *	strncpy(rstat->user, locuser, 9);
	 *	strncpy(rstat->site, rmtsite, SITELEN);
	 *	rstat->time_a = now;
	 */
		rstat->time_b = now;
		rstat->code = taskstatus;
		break;
	case 2:		/* L_stat file */
		strncpy(buff, rmtsite, SITELEN); /* overwrite, but harmless */
		lstat->time_a = now;
		if (taskstatus == 0) lstat->time_b = now;
		lstat->code = taskstatus;
		break;
	default:	/* never happen */
		break;
  }

  /* write out the new data */
  flg = TRUE;
  if (write(fd, buff, len) != len || close(fd) == -1) flg = FALSE;
  (void) close(fd);
  (void) unlock(lockfile);

  if (flg)
	return(OK);
  else
	return(FAILED);
}


/* 
 * w r i t e l o g
 *
 * Write a string to the log file
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int writelog(msg, prefix)
char *msg; int prefix;
{
  char buff[BUFSIZ];
  int flg;
  size_t sz;

  /* log format: site!user (date time) (id pid task) status (detail) */
  if (!prefix)
	strncpy(buff, msg, BUFSIZ - 1);
  else {
	(void) getdate(curtime);
	sprintf(buff, "%s!%s (%s) (C %4d %2d) ",
			rmtsite, locuser, curtime, pid, tasknum);
	strncat(buff, msg, BUFSIZ - 50);
  }
  sz = strlen(buff);

  /* if debugging, the logfile is already locked */
  if (dbglvl != 0)
	flg = (write(fdlog, buff, sz) == sz);
  else {
	if (checklock(LCKLOG, 2) == FAILED) {
		printmsg(M_NOLOG, "uucico: cannot lock %s", LOGFILE);
		return(FAILED);
	}
	if ((fdlog = open(LOGFILE, O_CREAT | O_WRONLY | O_APPEND, 0644)) == -1) {
		printmsg(M_NOLOG, "uucico: cannot open %s", LOGFILE);
		(void) unlock(LCKLOG);
		return(FAILED);
	}
	flg = (write(fdlog, buff, sz) == sz);
	if (close(fdlog) == -1) flg = FALSE;
	(void) unlock(LCKLOG);
  }

  if (flg)
	return(OK);
  else
	return(FAILED);
}


/*
 * w r i t e o u t
 *
 * Send a login string to the remote
 *
 * Return:	TRUE	Terminating cr needed
 *		FALSE	Terminating cr not needed
 */
int writeout(s)
char *s;
{
  char last;
  int j, addcr;

  last = '\0';
  addcr = TRUE;
  while (*s) {
	if (last != '\\') {
		if (*s != '\\')		/* send a normal character */
			(void) swrite(s, 1);
		else
			last = *s;	/* set an escape flag */
	}
	else {				/* send an escape sequence */
		switch (*s) {
			case 'd':
			case 'D':	/* delay */
		 		(void) sleep(2);
				break;
			case 'c':
			case 'C':	/* suppress newline at end of string */
				addcr = FALSE;
				break;
			case 'r':
			case 'R':	/* carriage return */
			case 'm':
			case 'M':
				(void) swrite("\r", 1);
				break;
			case 'n':
			case 'N':
				(void) swrite("\n", 1);
				break;
			case 'b':
			case 'B':
				(void) swrite("\b", 1);
				break;
			case 't':
			case 'T':
				(void) swrite("\t", 1);
				break;
			case 's':
			case 'S':
				(void) swrite(" ", 1);
				break;
			case '0': case '1': case '2': case '3': case '4':
			case '5': case '6': case '7':
				if (sscanf(s, "%o", &j) == 1) {
					j &= 0xff;
					(void) swrite((char *)&j, 1);
				}
				while (isdigit(*s) && *s != '8' && *s != '9')
					s++;
				s--;		/* incremented at end of loop */
				break;
			default:
				(void) swrite(s, 1);
		}
		last = '\0';
	}
	s++;
  }
  return(addcr);
}


/* 
 * w r i t e r r
 *
 * Write a message to the error log
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int writerr(msg)
char *msg;
{
  char buff[BUFSIZ];
  int flg = OK;
  size_t sz;

  /* log format: ASSERT ERROR (program) pid (date time) error */
  (void) getdate(curtime);
  sprintf(buff, "ASSERT ERROR (uucico) pid:%4d (%s) ", pid, curtime);
  strncat(buff, msg, BUFSIZ - strlen(buff) - 2);
  strcat(buff, "\n");
  sz = strlen(buff);

  if ((fderr = open(ERRLOG, O_CREAT | O_WRONLY | O_APPEND, 0600)) == -1)
	flg = FAILED;
  else {
	if (write(fderr, buff, sz) != sz)
		flg = FAILED;
	(void) close(fderr);
  }

  return(flg);
}


/*
 * w r i t e f o r e i g n
 *
 * Write a message to the FOREIGN log
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int writeforeign()
{
  char buff[BUFSIZ];
  int fd, flg = OK;
  size_t sz;

  /* log format: Unknown site site!user (date time) */
  (void) getdate(curtime);
  sprintf(buff, "Unknown site %s!%s (%s)\n", rmtsite, locuser, curtime);

  sz = strlen(buff);	/* seek precedes each write, & write is atomic */
  if ((fd = open(FOREIGN, O_CREAT | O_WRONLY | O_APPEND, 0600)) == -1)
	flg = FAILED;
  else {
	if (write(fd, buff, sz) != sz)
		flg = FAILED;
	(void) close(fd);
  }

  return(flg);
}


/* 
 * w r i t e s t a t u s
 *
 * Write a message to the status file
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int writestatus(msg)
char *msg;
{
  char buff[BUFSIZ];

  /* log format: pid status attempts unixtime interval rmtsite message */
  sprintf(buff, "%04d 0 %2d %9ld %5d %7s %12s\n",
		pid, retrynum, now, retryint, rmtsite, msg);
  (void) rewind(fpstat);
  if (fputs(buff, fpstat) != EOF) {
	(void) fflush(fpstat);
	return(OK);
  }
  else
	return(FAILED);
}

