/* uucico3.c
 *
 * Version 4.2 of 31 October 1991.
 */

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <ctype.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <pwd.h>
#ifdef _MINIX
#include <sgtty.h>
#endif
#include <signal.h>
#include <stdio.h>
#ifdef _MINIX
#undef NULL
#include <stdlib.h>
#endif
#include <string.h>
#ifdef _SVR2
#include <termio.h>
#endif
#include <time.h>
#include <unistd.h>
#ifdef _SVR2
#include <ustat.h>
#endif
#include "dial.h"
#include "uucp.h"
#include "uucico.h"


/*
 * s c a n d i r
 *
 * Scan work dir for command files for the current site
 *
 * Return:	OK		Opened a work file
 *		FAILED		Otherwise
 *		cmdfile, fpcmd are updated as side effects
 */
int scandir(site)
char *site;
{
  char buff[20], name[15], *filelist[MAXCMDS];
  int j, num, flg;
  size_t len;
  DIR *dirp;
  struct dirent *dp;

  printmsg(M_CALL, "scandir: checking site %s", site);

  /* try to open work directory */
  if ((dirp = opendir(spooldir)) == (DIR *)NULL) {
	printmsg(M_STD, "ASSERT ERROR");
	sprintf(errmsg, "BAD DIRECTORY %s (0)", spooldir);
	return(FAILED);
  }

  /* set up comparison */
  strcpy(name, "C.");
  strncat(name, site, SITELEN);
  len = strlen(name);

  /* get a sorted list of any workfiles for the current site */
  num = 0;
  filelist[num] = (char *)NULL;
  while ((dp = readdir(dirp)) != (struct dirent *)NULL && num < MAXCMDS - 1) {
	if (strncmp(dp->d_name, name, len) == SAME) {
		if ((filelist[num] = (char *) calloc(15, sizeof(char)))
							== (char *)NULL)
			break;
		else {
			strncpy(filelist[num++], dp->d_name, 14);
			filelist[num] = (char *)NULL;
		}
	}
  }
  (void) closedir(dirp);
  (void) sortlist(filelist, num);

  j = 0;
  flg = FALSE;
  while (!flg && j < num) {
	if (strncmp(filelist[j], name, len) == SAME) {
		/* get the job number (nb. lose grade byte) */
		strncpy(buff, filelist[j] + len + 1, 4);
		buff[4] = '\0';
		jobnum = ston(buff);
		sprintf(cmdfile, "%s/%s", spooldir, filelist[j]);
		printmsg(M_CALL, "scandir: job %d waiting for %s",
				jobnum, site);
		flg = TRUE;
	}
	else {
		printmsg(M_CALL, "scandir: %s not relevant", filelist[j]);
	}
	j++;
  }

  /* release memory */
  for (j = 0 ; j < num ; j++)
	free((void *)filelist[j]);

  if (flg) {
	if ((fpcmd = fopen(cmdfile, "r")) != (FILE *)NULL)
		return(OK);
	else
		return(FAILED);	/* ignore it, rather than complain */
  }
  else
	return(FAILED);
}


/*
 * s e n d b r e a k
 *
 * Send a BREAK, or pretend to.
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int sendbreak(num)
int num;
{
  int j;
  struct TTY tty;

  /* sort out invalid arguments */
  if (num <= 0 || num > 20) num = 8;

#ifdef _MINIX
  /* park the settings */
  if (ioctl(fdout, TTYGET, &tty) == -1) {
	if (errno != EINTR || ioctl(fdout, TTYGET, &tty) == -1)
		return(FAILED);
  }

  /* drop the speed */
  j = tty.sg_ospeed;
  tty.sg_ospeed = B110;
  if (ioctl(fdout, TTYSET, &tty) == -1) {
	if (errno != EINTR || ioctl(fdout, TTYSET, &tty) == -1)
		return(FAILED);
  }

  /* write a bunch of nulls */
  (void) swrite("\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0",
		(size_t)num);

  /* revert the speed */
  tty.sg_ospeed = j;
  if (ioctl(fdout, TTYSET, &tty) == -1) {
	if (errno != EINTR || ioctl(fdout, TTYSET, &tty) == -1)
		return(FAILED);
  }
#endif

#ifdef _SVR2
  if (ioctl(fdout, TCSBRK, 0) == -1) return(FAILED);
#endif

  /* say what we've done */
  (void) swrite("@", 1);

  return(OK);
}

 
/*
 * s e n d f
 *
 * The state table switcher for sending files.
 *
 * Return:	J	Success
 *		V	Failure
 *		0	rdmsg()/wrmsg() failure
 */
char sendf()
{
  char buff[256], lstate = 'H';		/* send initiate is the start state */
  char *goodmsg = "copy succeeded";
  char *badmsg = "can't copy to file directory - file left in SPOOLDIR";
  char *vbadmsg = "copy failed";

  fpdata = (FILE *)NULL;		/* reset file getter/opener */

  while (TRUE) {

	printmsg(M_TRANSFER, "sendf: send lstate %c",
			(lstate > ' ') ? lstate : (lstate + '0'));
	if (lstate == 'H') lstate = shdr();		/* Send-File-Header */
	else if (lstate == 'D') {			/* Send-File-Data */
		if ((*wrdata)(fpdata, fdout) == OK) lstate = 'E';
		else lstate = 'A';
	}
	else if (lstate == 'E') lstate = seof();	/* Send-End-of-File */
	else if (lstate == 'C') break;			/* Completed task */
	else if (lstate == 'Q') break;			/* Remote header failure */
	else if (lstate == 'A') break;			/* Abort */
	else break;					/* Try to fail gracefully */
  }

  /* check final status from remote */
  if (lstate == 'C' && copyflg == OK) {
	tasknum++;
	printmsg(M_STD, "COPY (SUCCEEDED)");
	sprintf(buff, "file %s to system %s\n%s\n", fromfile, rmtsite, goodmsg);
  }
  else if (lstate == 'C') {
	if (strncmp(rbuffer, "CN", 2) == SAME) {
		if (rbuffer[2] == '5') {
			printmsg(M_STD, "COPY FAILED (cannot copy TM file)");
			sprintf(buff, "file %s to system %s\n%s\n",
						fromfile, rmtsite, badmsg);
			if (role == MASTER) taskstatus |= ET_RDIR;
		}
		else {
			printmsg(M_STD, "COPY FAILED (reason not given by remote)");
			sprintf(buff, "file %s to system %s\n%s\n",
						fromfile, rmtsite, vbadmsg);
			if (role == MASTER) taskstatus |= ET_NOTKNOWN;
		}
	}
  }
  else if (lstate == 'A') {
	printmsg(M_TRANSFER, "sendf: aborting");
  }

  /* inform anyone who wants to know */
  if (opt_m && role == MASTER && lstate == 'C')	/* notify initiator */
	(void) sendmail(locsite, locmail, buff, (char *)NULL, opt_o);

  printmsg(M_TRANSFER, "sendf: quitting, lstate %c",
			(lstate > ' ') ? lstate : (lstate + '0'));
  if (lstate == 'C' || lstate == 'Q')
	return('J');
  else if (lstate == 'A')
	return('V');
  else
	return(0);
}


/*
 * s e n d m a i l
 *
 * Send messages or files to local or remote users
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int sendmail(site, name, message, file, flg)
char *site, *name, *message, *file; int flg;
{
  char address[32], header[256], buff[BUFSIZ];
  int j, k, status, err, fflg, mflg, infd, outfd, pfd[2];
  size_t len;

  printmsg(M_SPOOL, "sendmail: site |%s| user |%s| file |%s| message:\n|%s|",
		site, name, file, visib(message, strlen(message)));

  /* sort out what's to be done */
  err = fflg = mflg = FALSE;
  if (file != (char *)NULL)
	fflg = TRUE;
  if (message != (char *)NULL)
	mflg = TRUE;
  if (!fflg && !mflg) return(FAILED);

  /* write the message to a (local) file; mailbox is a full path */
  if (flg) {
	(void) getdate(curtime);
	sprintf(header, "uucp job %d (%s) ", jobnum, curtime);
	if ((outfd = open(mailbox, O_CREAT | O_WRONLY | O_APPEND, 0644)) == -1)
		err = TRUE;
	(void) chmod(mailbox, 0666);
	len = strlen(header);
	if (!err && write(outfd, header, len) != len)
		err = TRUE;
	len = strlen(message);
	if (!err && mflg && write(outfd, message, len) != len)
		err = TRUE;
	if (!err && fflg) {
		if ((infd = open(file, 0)) == -1)
			err = TRUE;
		while (!err && (j = read(infd, buff, sizeof(buff))) != 0) {
			if (j == -1 || write(outfd, buff, (size_t)j) != j)
				err = TRUE;
		}
		(void) close(infd);
	}
	(void) close(outfd);
	if (err) (void) unlink(mailbox);
  }
  /* or mail it to the initiator */
  else {
	/* generate the message address and header */
	sprintf(address, "%s!%s", site, name);
	sprintf(header, "From %s!%s %sTo: %s!%s\n\n", locsite, "uucp", ctime(&now),
							site, name);
	/* run a mailer, and write the text to its stdin */
	if (pipe(pfd) == -1)			/* generate the pipe */
		return(FAILED);
	switch (j = fork()) {			/* fork, dup and exec */
		case -1:			/* error */
			return(FAILED);
		case 0:				/* pregnant */
			if (close(0) == -1)
				exit(1);
			if (dup(pfd[0]) != 0)	/* child's stdin */
				exit(1);
			if (close(pfd[0]) == -1 || close(pfd[1]) == -1)
				exit(1);
			(void) fflush(stderr);
			(void) freopen("/dev/null", "w", stderr);
			(void) execlp(RMAIL, "rmail", address, (char *)NULL);
			exit(1);		/* never happen */
	}

	/* if we're here, we're a parent */
	if (close(pfd[0]) == -1) return(FAILED);
	len = strlen(header);
	if (write(pfd[1], header, len) != len)
		err = TRUE;
	if (!err && mflg) {
		len = strlen(message);
		if (write(pfd[1], message, len) != len)
			err = TRUE;
	}
	if (!err && fflg) {
		if ((infd = open(file, 0)) == -1) err = TRUE;
		while (!err && (k = read(infd, buff, sizeof(buff))) != 0) {
			if (k == -1 || write(pfd[1], buff, (size_t)k) != k)
				err = TRUE;
		}
		(void) close(infd);
	}
	if (close(pfd[1]) == -1) return(FAILED);
#ifdef MAILWAIT
	while ((k = wait(&status)) != j && k != -1)
		;
	if (j < 1 || k < 1 || WEXITSTATUS(status) != 0 || WTERMSIG(status) != 0)
		err = FAILED;
	printmsg(M_SPOOL, "sendmail: mail fork %d, wait %d, status %d",
						j, k, status);
#endif
  }

  printmsg(M_SPOOL, "sendmail: mail %s", err ? "FAILED" : "OK");

  if (err)
	return(FAILED);
  else
	return(OK);
}


/*
 * s e n d s t r
 *
 * Send line of the login sequence
 *
 * Return:	0	Always
 */
int sendstr(str)
char *str;
{
  printmsg(M_CALL, "sendstr: sending %s, first char \\%03o", str, str[0]);

  if (strcmp(str, "EOT") == SAME)
	(void) swrite(EOTMSG, strlen(EOTMSG));
#ifdef BREAK
  else if (strncmp("BREAK", str, 5) == SAME)
	(void) sendbreak(atoi(str + 5));
#endif
  else {
	if (strcmp(str, "\"\"") == SAME) *str = '\0';
	if (*str == '\0' || writeout(str)) (void) swrite("\r", 1);
  }

  return(0);
}


/*
 * s e o f
 *
 * Send EOF to remote
 *
 * Return:	0	Various failures
 *		C	Successful completion
 */
char seof()
{
  (void) fclose(fpdata);
  fpdata = (FILE *)NULL;

  copyflg = FAILED;
  if ((*rdmsg)(rbuffer, fdin) == FAILED) return(0);	/* receive CY or CN */
  if (strncmp(rbuffer, "CY", 2) == SAME) {
	copyflg = OK;
	if (dfileflg) {
		(void) unlink(datafile);
		dfileflg = FALSE;
	}
  }
  printmsg(M_TRANSFER, "seof: %s transferred, response %s",
				fromfile, copyflg ? "OK" : "FAILED");

  return('C');		/* go get the next file to send */
}


/*
 * s e t c o u n t
 *
 * Increment the conversation count in SQFILE
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int setcount(site)
char *site;
{
  char tfile[64], buff[BUFSIZ];
  int flg;
  sig_t sigint, sighup;
  size_t sz, count;
  FILE *fps, *fpt;

  if (access(SQFILE, 0) == -1) return(FAILED);	/* no file, no name */
  if (checklock(LCKSQ, 2) == FAILED) return(FAILED);

  /* disable SIGINT and SIGHUP while the SQFILE is moved */
  if ((sigint = signal(SIGINT, SIG_IGN)) == BADSIG ||
		(sighup = signal(SIGHUP, SIG_IGN)) == BADSIG) {
	(void) unlock(LCKSQ);
	return(FAILED);
  }

  /* move SQFILE to a temporary file */
  sprintf(tfile, "%s%04d", TMPATH, pid);
  (void) unlink(tfile);
  if (link(SQFILE, tfile) == -1 || unlink(SQFILE) == -1) {
	(void) unlink(tfile);
	(void) unlock(LCKSQ);
	return(FAILED);
  }

  /*  The SQFILE file contains the current call numbers for all the sites
   *  called.  The file format is: site number date_time
   */

  if ((fps = fopen(SQFILE, "w")) == (FILE *)NULL ||
		(fpt = fopen(tfile, "r")) == (FILE *)NULL) {
	(void) link(tfile, SQFILE);
	(void) unlink(tfile);
	(void) unlock(LCKSQ);
	return(FAILED);
  }
  (void) unlink(tfile);	

  (void) getdate(curtime);
  sz = strlen(site);
  flg = FALSE;
  while (fgets(buff, BUFSIZ, fpt) != (char *)NULL) {
	if (!flg && strncmp(site, buff, sz) == SAME) {
		if (sscanf(buff, "%s %d", scratch, &count) < 2)
			count = 1;
		else
			count++;
		sprintf(buff, "%s %d %s\n", site, count, curtime);
		flg = TRUE;
	}
	if (fputs(buff, fps) == EOF) {
		(void) fclose(fps);	/* do not unlock - file corrupt */
		(void) fclose(fpt);
		return(FAILED);
	}
  }

  (void) fclose(fps);
  (void) fclose(fpt);
  (void) unlock(LCKSQ);

  /* re-enable SIGINT and SIGHUP */
  if (signal(SIGINT, sigint) == BADSIG || signal(SIGHUP, sighup) == BADSIG)
	flg = FALSE;

  if (flg)
	return(OK);
  else
	return(FAILED);
}


/*
 * s e t p r o t o
 *
 * Set the requested protocol, defaulting to message protocol
 *
 * Return:	OK	Sucess
 *		FAILED	Otherwise
 */
int setproto(p)
char p;
{
  struct Proto *tp;

  for (tp = Protolst ; ; tp++) {
	if (p == tp->Pname) {
		turnon = tp->Pturnon;
		rdmsg = tp->Prdmsg;
		wrmsg = tp->Pwrmsg;
		rddata = tp->Prddata;
		wrdata = tp->Pwrdata;
		turnoff = tp->Pturnoff;
		break;
	}
	if (tp->Pname == '\0') return(FAILED);
  }
  return(OK);
}


/*
 * s e t s i g n a l
 *
 * Set up a catcher for a signal if it is not already being ignored
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int setsignal(sig, func)
int sig; sig_t func;
{
  sig_t oldsig;

  oldsig = signal(sig, SIG_IGN);

  if (oldsig == BADSIG)		/* no dealing with this failure */
	return(FAILED);
  else if (oldsig == SIG_IGN)	/* ignore ignored signals */
	return(OK);
  else if (oldsig == SIG_DFL) {	/* set catcher for defaulted signals */
	if (signal(sig, func) == BADSIG)
		return(FAILED);
  }
  else				/* never happen */
	return(FAILED);

  return(OK);
}


/*
 * s h d r
 *
 * Send a file header to the remote
 *
 * Return:	0	rdmsg()/wrmsg() failure
 *		A	Local failures (fatal)
 *		Q	Remote failure
 *		D	Success
 */
char shdr()
{
  printmsg(M_TRANSFER, "shdr: negotiating transfer");

  if (role == MASTER) {
  /* Response to 'S fromfile tofile user -opts datafile mode notify [mbox]' */
	if ((*rdmsg)(rbuffer, fdin) == FAILED)
		return(0);		/* something wrong in channel */
	if (strncmp(rbuffer, "SY", 2) == SAME) {
		/* saves time */
	}
	else if (rbuffer[2] == '2') {
		printmsg(M_STD, "REQUEST (remote access to path/file denied)");
		taskstatus |= ET_RACCESS;
		return('Q');
	}
	else if (rbuffer[2] == '4') {
		printmsg(M_STD, "REQUEST (cannot create TM file)");
		taskstatus |= ET_RTMP;
		return('Q');
	}
	else {
		printmsg(M_STD, "COPY FAILED (reason not given by remote)");
		taskstatus |= ET_NOTKNOWN;
		return('Q');
	}
  }

  /* Try to access the data file; this was checked in get[ms]task(),
   * so if it fails now something is seriously wrong.
   */
  if (opendata() == FAILED) {
	if (role == SLAVE && (*wrmsg)("RN2", fdout) == FAILED) return(0);
	printmsg(M_STD, "ASSERT ERROR");
	sprintf(errmsg, "CAN'T OPEN %s (0)", datafile);
	if (role == MASTER) taskstatus |= ET_NOTKNOWN;
	return('A');
  }
  else {
	if (role == SLAVE && (*wrmsg)("RY", fdout) == FAILED) return(0);
	printmsg(M_TRANSFER, "shdr: sending %s with %s datafile",
		fromfile, dfileflg ? datafile : "no");
	return('D');
  }
}


/* 
 * s o r t l i s t
 *
 * Sort a list of names
 *
 * Return:	OK	Always
 */
int sortlist(list, total)
char *list[]; int total;
{
  char tfil[15];
  int j, k, gap;

  /* shell sort */
  gap = 1;
  while (gap <= total) gap = 3 * gap + 1;

  for (gap /= 3 ; gap > 0 ; gap /= 3 ) {
 	for (j = gap ; j < total ; j++) { 
		strncpy(tfil, list[j], 14);
		for (k = j ;
		k >= gap && strncmp(list[k - gap], tfil, 14) > 0 ;
		k -= gap) {
			strncpy(list[k], list[k - gap], 14);
		}
		strncpy(list[k], tfil, 14);
	}
  }

  return(OK);
}


/*
 * s r e a d
 *
 * Read from the input fd, allowing for timeout
 *
 * Return:	FAILED			On read() failure
 *		No. of bytes read	Otherwise
 */
int sread(data, num, timeout)
char *data; size_t num; unsigned int timeout;
{
  int status;
  unsigned int setting;
  sig_t oldsig;
#if 0
  if ((oldsig = signal(SIGALRM, ontime)) == BADSIG)
	return(FAILED);
#endif
  if (timeout != 0)
	setting = alarm(timeout);
  else
	setting = alarm(2);

  /* read returns the number of bytes read, 0 on EOF, or -1 on error */
  /* EOF and error return immediately, without timing out */

  status = read(fdin, data, (unsigned int)num);
  (void) alarm(setting);
#if 0
  (void) signal(SIGALRM, oldsig);
#endif 

  return(status);
}


/*
 * s t o n
 *
 * Converts a string to an integer
 *
 * Returns:	A number
 *
 * Some machines use hexadecimal job number in file names.
 * This routine extracts some sort of int from the string.
 */
int ston(str)
char *str;
{
  char *cp = str;
  int j, aflg, dflg, hflg;
  long int lj;
  aflg = dflg = hflg = FALSE;
 
  while (*cp) {
	if (isdigit(*cp)) dflg = TRUE;
	else if (isxdigit(*cp)) hflg = TRUE;
	else aflg = TRUE;
	cp++;
  }

  if (aflg)			/* give up */
	lj = 0;
  else if (dflg)
	lj = atoll(str);	/* local version of atol */
  else if (hflg)
	lj = htol(str);

  j = lj % 0xffff;		/* job numbers are signed ints here */

  return(j);
}


/* 
 * s y s l o g
 *
 * Write traffic statistics to the SYSLOG
 *
 * Return:	OK	Success
 *		FAILED	Otherwise
 */
int syslog(tbytes, tsecs, tclicks)
long int tbytes; time_t tsecs; clock_t tclicks;
{
  char c, *cp, buff[BUFSIZ];
  int fd, flg = OK;
  size_t sz;

  /* log format: site!user status (date time) (id pid task) direction \
   * bytes / secs:ticks proto dev
   */
  c = curcmd[0];
  if ((c == 'S' && role == MASTER) || (c == 'R' && role == SLAVE))
	cp = "->";
  else
	cp = "<-";	
  (void) getdate(curtime);
  sprintf(buff, "%s!%s %c (%s) (C %4d %2d) %s %ld / %ld:%ld secs [%c] %s\n",
	rmtsite, locuser, c, curtime, pid, tasknum,
	cp, tbytes, tsecs, tclicks, pname, device);

  sz = strlen(buff);	/* seek precedes each write, & write is atomic */
  if ((fd = open(SYSLOG, O_CREAT | O_WRONLY | O_APPEND, 0644)) == -1)
	flg = FAILED;
  else {
	if (write(fd, buff, sz) != sz)
		flg = FAILED;
	(void) close(fd);
  }
  return(flg);
}


/*
 * s w r i t e
 *
 * Write to the output fd.
 *
 * Return:	write() function return value
 *
 * There are problems both with abandoning the write, and with trying again.
 */
int swrite(data, num)
char *data; size_t num;
{
  int j;

  if ((j = write(fdout, data, (unsigned int)num)) == -1) {
	if (errno != EINTR)
		j = write(fdout, data, (unsigned int)num);
  }
  return(j);
}


/*
 * s y s b r e a k
 *
 * Negotiate hangup
 *
 * Return:	0	rdmsg()/wrmsg() failure
 *		V	No more work, continue shutdown
 *		J	More work to be done, roles switched if necessary
 */
char sysbreak()
{
  if (role == MASTER) {
	if ((*wrmsg)("H", fdout) == FAILED) return(0);
	if ((*rdmsg)(rbuffer, fdin) == FAILED) return(0);
	printmsg(M_CONVERSE, "sysbreak: remote response %s", rbuffer);
	role = SLAVE;
	if (rbuffer[1] == 'N') {	/* more work there */
		return('J');
	}
	else {				/* no work anywhere */
		if ((*wrmsg)("HY", fdout) == FAILED) return(0);
		/* some sites give a rude goodbye */
		(void) (*rdmsg)(rbuffer, fdin);
		return('V');
	}
  }
  else { /* role == SLAVE */
	/* we've already received |H| */
	role = MASTER;
	if (scandir(rmtsite) == OK) { /* we have work, keep going */
		tasknum = taskstatus = 0;
		printmsg(M_CONVERSE, "sysbreak: local response HN");
		if ((*wrmsg)("HN", fdout) == FAILED) return(0);
		return('J');
	}
	else {
		printmsg(M_CONVERSE, "sysbreak: local response HY");
		if ((*wrmsg)("HY", fdout) == FAILED) return(0);
		if ((*rdmsg)(rbuffer, fdin) == FAILED) return(0);
		if (rbuffer[1] != 'Y') return(0); /* ex-master changes mind? */
		if ((*wrmsg)("HY", fdout) == FAILED) return(0);
		return('V');
	}
  }
}


/*
 * s y s e n d
 *
 * End access to remote site
 *
 * Return:	X	Always
 */
char sysend()
{
  /* send a final message */
  if (role == MASTER)
	(void) (*wrmsg)("OOOOOO", fdout);
  else
	(void) (*wrmsg)("OOOOOOO", fdout);

  callstatus = 0;
  (void) time(&now);
  printmsg(M_STD, "OK (conversation complete %s %ld)", device, now - begin);

  return('X');
}


/*
 * s y s m i n i t
 *
 * Negotiate access with a site, master role
 *
 * Return:	X	Failure
 *		H	Success
 */
char sysminit()
{
  char msg[80];
  int j, count;

  (void) time(&begin);
  printmsg(M_CALL, "sysminit: entry, role master, debug level %d", dbglvl);

  sterflg = TRUE;	/* clear this if we surmount all hurdles */
  msgtime = MSGTOUT;
  if ((*rdmsg)(msg, fdin) == FAILED) return('X');
  printmsg(M_CALLMSG, "sysminit: 1st msg from slave = %s", msg);

  /* Only SysV says "Shere", all others say "Shere=myname". */
  if (msg[5] == '=' && strncmp(&msg[6], rmtsite, SITELEN) != SAME) {
	callstatus |= EC_HFAIL;
	return('X');
  }
  else
	printmsg(M_STD, "SUCCEEDED (call to %s)", rmtsite);

  if ((count = getcount(rmtsite)) < 1) count = 0; /* no file or no site */
  sprintf(msg, "S%.7s -Q%d -x%d", locsite, count, dbglvl);
  printmsg(M_CALLMSG, "sysminit: reply to 1st msg = %s", msg);
  (void) (*wrmsg)(msg, fdout);

  if ((*rdmsg)(msg, fdin) == FAILED) return('X');
  printmsg(M_CALLMSG, "sysminit: 2nd msg from slave = %s", msg);

  if (strncmp(&msg[1], "OK", 2) == SAME) {
	if (count != 0) (void) setcount(rmtsite);
	printmsg(M_CALLMSG, "sysminit: reply to 2nd msg - none needed");
  }
  else if (strncmp(msg, "RLCK", 4) == SAME) {
	printmsg(M_STD, "HANDSHAKE FAILED (LCK)");
	return('X');
  }
   else if (strncmp(msg, "RCB", 3) == SAME) {
	sterflg = FALSE;
	printmsg(M_STD, "CALLBACK REQUIRED");
	return('X');
  }
  else if (strncmp(msg, "RBADSEQ", 7) == SAME) {
	callstatus |= EC_HFAIL;
	printmsg(M_STD, "BAD SEQUENCE CHECK");
	return('X');
  }

  if ((*rdmsg)(msg, fdin) == FAILED) return('X');
  printmsg(M_CALLMSG, "sysminit: 3rd msg from slave = %s", msg);

  if (msg[0] == 'P') {		/* scan available protocols */
  	for (j = 0; j < strlen(protocols) ; j++) {
		if (strchr(msg + 1, protocols[j]) != (char *)NULL) {
			sprintf(msg, "U%c", protocols[j]);
			printmsg(M_CALLMSG, "sysminit: reply to 3rd msg = %s", msg);
			(void) (*wrmsg)(msg, fdout);
			pname = protocols[j];
			sterflg = FALSE;
			callstatus &= ~EC_HFAIL;	/* in case */
			return('H');
		}
	}
  }

  /* get here with an out-of-sequence message, no matching protocol */
  printmsg(M_CALLMSG, "sysminit: replying 'UN' - no common protocol");
  (void) (*wrmsg)("UN", fdout);
  callstatus |= EC_HFAIL;
  printmsg(M_STD, "FAILED (startup)");
  return('X');
}


/*
 * s y s s i n i t
 *
 * Negotiate access with a site, Slave role
 *
 * Return:	X	Failure
 *		H	Success
 */
char syssinit()
{
  char msg[80], *fields[MAXARGS];
  int j, k, m, count;
  FILE *fp;

  (void) time(&begin);
  printmsg(M_CALL, "syssinit: entry, role slave, debug level %d", dbglvl);

  msgtime = MSGTOUT;
  sprintf(msg, "Shere=%s", locsite);
  printmsg(M_CALLMSG, "syssinit: reply to 1st msg = %s", msg);
  (void) (*wrmsg)(msg, fdout);

  if ((*rdmsg)(msg, fdin) == FAILED) return('X');
  printmsg(M_CALLMSG, "syssinit: 2nd msg from master = %s", msg);

  /* parse the reply */
  if (k = getargs(msg, fields) < 1) return('X'); /* must get rmtsite */
  strncpy(rmtsite, fields[0] + 1, SITELEN);
  m = dbglvl;
  count = 0;
  for (j = 1; j < k; j++) {
	if (*(fields[j] + 1) == 'x') dbglvl = atoi(fields[j] + 2);
	if (*(fields[j] + 1) == 'Q') count = atoi(fields[j] + 2);
  }
  printmsg(M_CALLMSG, "syssinit: rmtsite %s, debug %d, count %d",
		rmtsite, dbglvl, count);

  if (dbglvl > 0 && dbglvl != m) {	/* create & use the audit file */
	(void) close(fdlog);
	if (checklock(LCKAUD, 2) == FAILED) {
		printmsg(M_NOLOG, "uucico: cannot lock %s", AUDLOG);
		exit(1);
	}
	if ((fdlog = open(AUDLOG, O_CREAT | O_WRONLY | O_APPEND, 0600)) == -1) {
		printmsg(M_NOLOG, "uucico: cannot open %s", AUDLOG);
		exit(1);
	}
	printmsg(dbglvl, "========== %-24.24s ===========", ctime(&now));
  }
  /* do we have a FOREIGN file in play ? */
  if (access(FOREIGN, 0) == 0) {
	if (checkname(rmtsite) == FAILED) {
		(void) writeforeign();
		(void) (*wrmsg)("RN", fdout);
		return('X');
	}
  }

  /* is the site already in contact ? */
  if (checklock(rmtsite, 1) == FAILED) {
	printmsg(M_STD, "LOCKED (call to %s)", rmtsite);
	(void) (*wrmsg)("RLCK", fdout);
	return('X');
  }
  /* does it expect a conversation count ? */
  else if (count != 0 && count != getcount(rmtsite)) {
	printmsg(M_STD, "BAD SEQUENCE CHECK");
	(void) (*wrmsg)("RBADSEQ", fdout);
	callstatus |= EC_HFAIL;
	return('X');
  }
  /* does the site have any access ? */
  else if (checkuser(rmtsite, locuser, (char *)NULL) == FAILED) {
	(void) (*wrmsg)("RN", fdout);
	return('X');
  }
  else if (cbflg) {
	printmsg(M_STD, "CALLBACK REQUIRED");
	if (count == 0 || setcount(rmtsite) == OK) {
#ifdef RUNUUCICO
		(void) (*wrmsg)("RCB", fdout);
#else
		/* write out a pseudo-command file to fire up uusched */
		seqnum = getseq();	/* returns 0 on error */
		sprintf(scratch, "%s/C.%sn%04d", spooldir, rmtsite, seqnum);
		if (seqnum == 0 || (fp = fopen(scratch, "w")) == (FILE *)NULL) {
			printmsg(M_STD, "CAN'T OPEN (%s)", scratch);
			(void) (*wrmsg)("RN", fdout);
		}
		else {
			(void) fclose(fp);
			(void) (*wrmsg)("RCB", fdout);
		}
		cbflg = FALSE;
#endif
	}
	else {
		(void) (*wrmsg)("RN", fdout);
		cbflg = FALSE;
	}
	return('X');
  }
  /* if we're here, then access is permitted */
  else if (openstatus(rmtsite) == FAILED) {
	(void) (*wrmsg)("RN", fdout);
	return('X');
  }
  /* we made it! */
  else {
	(void) (*wrmsg)("ROK", 2);
	(void) setcount(rmtsite);
	printmsg(M_CALLMSG, "syssinit: replying ROK, known site %s", rmtsite);
  }
  sprintf(msg, "P%s", protocols);
  (void) (*wrmsg)(msg, fdout);
  printmsg(M_CALLMSG, "syssinit: sending protocol msg = %s", msg);
  if ((*rdmsg)(msg, fdin) == FAILED) return('X');
  printmsg(M_CALLMSG, "syssinit: 3rd message from master = %s", msg);

  if (msg[0] != 'U' || strchr(protocols, msg[1]) == (char *)NULL)
	return('X');

  pname = msg[1];
  callstatus &= ~EC_HFAIL;	/* in case */
  return('H');
}

