/* uucico.h - header for uucico.c in UUCP package.
 *
 * Version 1.2 of 31 October 1991.
 */

/* Code selection options */

#define VERBOSE			/* add debug messages to diallers & protocols */
#undef RUNUUXQT			/* automatically exec uuxqt */
#undef RUNUUCICO		/* exec uucico to call back */
#undef BREAK			/* machine is able to transmit BREAK */

/* Miscellaneous constants */

#define MSGTOUT		50	/* seconds timeout in logon */
#define MAXLOCKS	10	/* maximum number of lock files */
#define LOWLEVEL	1000	/* minimum blocks to permit file reception */
#define	MASTER		1
#define	SLAVE		0
#define NOROLE		-1
#define LOCAL		0
#define REMOTE		1
#define FALSE		0
#define TRUE		~FALSE
#define OK		1
#define MAYBE		0
#define FAILED		-1
#define SAME		0

#define BFRAME		'\020'		/* ^P frame start */
#define EFRAME		'\0'		/* ^@ frame end (alternatively ^J) */
#define EOTMSG		"\004\r\004\r"	/* conversation-level EOT */

/* Debugging levels for log messages */

#define M_STD		0	/* standard messages */
#define M_NOLOG		1	/* no output to log file */
#define M_CALL		2	/* the call and pre-protocol negotiation */
#define M_CONVERSE	3	/* conversation level */
#define M_TRANSFER	4	/* file transfer */
#define M_SPOOL		5	/* spool files */
#define M_CALLMSG	6	/* messages sent out during call/pre-proto */
#define M_HIGHPROTO	7	/* high-level protocol */
#define M_MEDPROTO	8	/* med-level protocol */
#define M_LOWPROTO	9	/* low-level protocol (framing and such) */
#define M_DATA		10	/* actual packet data */

/* Global variables */

extern char rbuffer[MSGLEN];		/* protocol message input buffer */
extern char sbuffer[MSGLEN];		/* protocol message output buffer */
extern char userpath[256];		/* USERFILE path list */
extern char tempbuff[256];		/* logon / parse buffer */
extern char curcmd[256];		/* current command */
extern char scratch[132];		/* scratch buffer */
extern char spooldir[132];		/* spool directory */
extern char cmdfile[132];		/* command file name */
extern char fromfile[132];		/* source of copy */
extern char tofile[132];		/* destination of copy */
extern char datafile[132];		/* datafile for copy */
extern char tempfile[132];		/* temporary file */
extern char mailbox[132];		/* redefined mailbox */
extern char errmsg[132];		/* assert error details */
extern char rmtsite[20];		/* remote site name */
extern char rmtuser[20];		/* remote user name */
extern char locsite[20];		/* local site name */
extern char locuser[20];		/* local user name */
extern char locmail[20];		/* local mail recipient */
extern char rmtmail[20];		/* remote mail recipient */
extern char cmdargs[20];		/* command arguments */
extern char device[20];			/* device type from L.sys */
extern char protocols[20];		/* default protocol(s) from L.sys */
extern char baud[20];			/* device speed from L.sys */
extern char phone[20];			/* device phone number from L.sys */
extern char cctime[64];			/* valid calling times from L.sys */
extern char curtime[64];		/* current time in ASCII format */
extern char state;			/* current state of the UUCP state machine */
extern char framefirst;			/* first byte of conversation-level message */
extern char framelast;			/* last byte of conversation-level message */
extern char progname[20];		/* current program name */
extern char *cmdflds[MAXARGS];		/* pointers to parsed command arguments */
extern char locklist[MAXLOCKS][LOCKLEN + 1];	/* lock file list */
extern char spoolist[MAXLOCKS][LOCKLEN + 1];	/* spool file list */

extern int role;			/* MASTER or SLAVE */
extern int location;			/* LOCAL or REMOTE */
extern int fdin;			/* serial input file descriptor */
extern int fdout;			/* serial output file descriptor */
extern int commfd;			/* comms line file descriptor */
extern int retrynum;			/* call retry number */
extern int retryint;			/* call retry interval */
extern int maxfld;			/* maximum send/expect field in logon */
extern int dbglvl;			/* debugging level */
extern int lsysindex;			/* index to current L.sys entry */
extern int seqnum;			/* sequence number */
extern int jobnum;			/* current job number */
extern int tasknum;			/* current task number */
extern int taskstatus;			/* task status code number */
extern int callstatus;			/* call status code number */
extern int pid;				/* process pid */
extern int copyflg;			/* file copy flag */
extern int dfileflg;			/* datafile present flag */
extern int slckflg;			/* site lock file present flag */
extern int sterflg;			/* bad status flag */
extern int usrfflg;			/* USERFILE read flag */
extern int cbflg;			/* callback flag */
extern int opt_S;			/* ignore status file */
extern int opt_U;			/* do not run uuxqt */
extern int opt_C;			/* uucico slave command flags */
extern int opt_c;
extern int opt_d;
extern int opt_f;
extern int opt_m;
extern int opt_n;
extern int opt_o;

extern int fdlog;			/* system log file descriptor */
extern int fderr;			/* error log file descriptor */

extern unsigned int msgtime;		/* serial input timeout setting */
extern dev_t devnum;			/* spooldir device number */
extern time_t now;			/* current time */
extern time_t begin;			/* session start time */

extern FILE *fpcmd;			/* command file pointer */
extern FILE *fpdata;			/* data file pointer */
extern FILE *fpstat;			/* status file pointer */
extern FILE *fptemp;			/* temp file pointer */
extern CALL call;			/* dial(3) structure */
extern struct TTY stdtty;		/* saved terminal parameters for stdin */

/* Externals */

extern int getopt(), optind, opterr, optopt;
extern char *optarg;
extern int errno;
extern struct passwd *getpwuid(), *getpwnam();

/* Access to connected devices */

struct Dev {			/* device access functions */
  char *Devname;
  int (*Devopen)();
  int (*Deverror)();
  int (*Devclose)();
};

extern struct Dev Devlst[];
extern char *devname;
extern int (*devopen)();
extern int (*deverror)();
extern int (*devclose)();

/* Dialler access functions */

extern int ttyopen(), ttyerror(), ttyclose(); 
extern int padopen(), paderror(), padclose(); 
extern int dial(), merror(), hangup();

/* Access to protocols */

typedef int (*procref)();

struct Proto {			/* protocol access functions */
  char Pname;
  procref Pturnon;
  procref Prdmsg;
  procref Pwrmsg;
  procref Prddata;
  procref Pwrdata;
  procref Pturnoff;
};

extern struct Proto Protolst[];
extern char pname;
extern procref turnon;
extern procref rdmsg;
extern procref wrmsg;
extern procref rddata;
extern procref wrdata;
extern procref turnoff;

/* The protocol routines */
extern int fon(), frdmsg(), frddata(), fwrmsg(), fwrdata(), foff();
extern int gopenpk(), grdmsg(), grddata(), gwrmsg(), gwrdata(), gclosepk();
extern int ton(), trdmsg(), trddata(), twrmsg(), twrdata(), toff();

/* Forward declarations in uucico[123].c */

extern int addlock();
extern long int atoll();
extern char callbreak();
extern char callsystem();
extern int catchsignal();
extern int checklock();
extern int checkname();
extern char checksystem();
extern int checktime();
extern int checkuser();
extern void cleanup();
extern int clearbuff();
extern int connect();
extern int empty();
extern int expdtilde();
extern int expectstr();
extern int getargs();
extern int getcount();
extern int getdate();
extern int getmsg();
extern char getmtask();
extern int getname();
extern int getseq();
extern char getstask();
extern char getsystem();
extern uid_t get_uid();
extern int getuser();
extern long int htol();
extern char ioinit();
extern char ioend();
extern char logon();
extern int movefile();
extern void ontime();
extern int opendata();
extern int openstatus();
extern int parsecmd();
extern char pktend();
extern char pktinit();
extern void printmsg();
extern char rdata();
extern char recvf();
extern char reof();
extern char rhdr();
extern int rmesg();
extern char runuucp();
extern int scandir();
extern char sdata();
extern int sendbreak();
extern char sendf();
extern int sendmail();
extern int sendmsg();
extern int sendstr();
extern char seof();
extern int setcount();
extern int setproto();
extern int setsignal();
extern char shdr();
extern int sortlist();
extern int sread();
extern int sread2();
extern int ston();
extern int syslog();
extern int swrite();
extern char sysbreak();
extern char sysend();
extern char sysminit();
extern char syssinit();
extern int unlock();
extern void usage();
extern int usercheck();
extern char *visib();
extern int wmesg();
extern int writeconn();
extern int writerr();
extern int writeforeign();
extern int writestatus();
extern int writelog();
extern int writeout();

/* EOF */

