/* cu.h - header for cu.c in UUCP package.
 *
 * Version 1.2 of 31 October 1991.
 */

#define FALSE		0
#define TRUE		~FALSE
#define OK		1
#define FAILED		-1
#define SAME		0
#define MAXLOCKS	2
#define MAXARGS 	30

#define CHUNK 1024		/* how much to read at once */

#define DEFDEV	"tty1"		/* default device - nb. no path */
#define DEFSPD	"1200"		/* default speed */

/* Hack some new baud rates for Minix. Minix uses a divide-by-100 encoding. */
#ifdef _MINIX
#define B200     2
#define B600     6
#define B1800   18
#define B3600   36
#define B7200   72
#define B9600	96
#define B19200 192
#define EXTA   192
/* We cannot handle some standard (slow) V7 speeds and speeds above 25500 since
 * since the speed is packed into a char :-(. Trap them with an illegal value.
 */
#define B50      0
#define B75      0
#define B134     0
#define EXTB     0
#define B38400   0
#define B57600   0
#define B115200  0
#endif

/* Debugging levels for error messages */

#define M_STD		0	/* standard messages */
#define M_NOLOG		1	/* no output to log file */
#define M_CALL		2	/* the call and pre-protocol negotiation */
#define M_CONVERSE	3	/* conversation level */
#define M_TRANSFER	4	/* file transfer */
#define M_SPOOL		5	/* spool files */
#define M_CALLMSG	6	/* messages sent out during call/pre-proto */
#define M_HIGHPROTO	7	/* high-level protocol */
#define M_MEDPROTO	8	/* med-level protocol */
#define M_LOWPROTO	9	/* low-level protocol (framing and such) */
#define M_DATA		10	/* actual packet data */

/* Global variables */

extern int opt_b;			/* use given number of bits */
extern int opt_d;			/* print diagnostics */
extern int opt_e;			/* set even parity */
extern int opt_h;			/* set half-duplex mode (local echo) */
extern int opt_l;			/* use given line */
extern int opt_o;			/* set odd parity */
extern int opt_s;			/* set speed */
extern int opt_t;			/* map CR to CRLF ? */
extern int opt_x;			/* debugging flag */

extern char locklist[MAXLOCKS][LOCKLEN + 1];	/* lock file list */
extern char *cmdflds[MAXARGS];		/* pointers to parsed command arguments */
extern char homedir[132];		/* current user's HOME directory */
extern char locsite[20];		/* local site name */
extern char locuser[20];		/* local user name */
extern char progname[20];		/* program name */
extern char Lsite[20];			/* site from L.sys */
extern char Ldevice[20];		/* device type from L.sys */
extern char Lprotocols[20];		/* device protocols from L.sys */
extern char Lbaud[20];			/* device baud rate from L.sys */
extern char Lphone[20];			/* device phone number from L.sys */
extern char Lcctime[64];		/* clear calling times from L.sys */
extern char Ldialler[20];		/* dialler from L-devices */
extern char curtime[64];		/* current time */
extern char endseq[];			/* local command prefix */
extern char takeseq[];			/* capture command prefix */

extern int lsysindex;			/* current position in L.sys file */
extern int commfd;			/* comm device file descriptor */
extern int pid;				/* current pid */
extern int readpid;			/* pid of child reading commfd */
extern int writepid;			/* pid of child writing commfd */
extern int bits;			/* bits per char for comms line */
extern int parity;			/* parity of comms line */
extern int baudrate;			/* speed of comms line */
extern int characters;			/* bytes in file */
extern int lines;			/* lines in file */
extern int count;			/* characters in i/o buffer */
extern int bitmask;			/* mask for valid bits */
extern int fdt;				/* take transfer file descriptor */
extern int dbglvl;			/* debugging level */

extern time_t now;			/* current unix time */

extern CALL call;			/* dial(3) structure */
extern struct TTY stdtty;		/* saved terminal parameters for stdin */

extern struct Params {			/* permissible i/o port parameters */
  char *pattern;
  unsigned int value;
  char type;
} params[];

#define BAD      0
#define BITS     1
#define STRIP    2
#define PARITY   3
#define SPEED    4

/* Access to connected devices */

extern char *devname;			/* device access functions */
extern int (*devopen)();
extern int (*deverror)();
extern int (*devclose)();

extern struct Dev {			/* set of connected devices */
  char *Devname;
  int (*Devopen)();
  int (*Deverror)();
  int (*Devclose)();
} Devlst[];

/* Dialler access functions */
extern int ttyopen(), ttyerror(), ttyclose(); 
extern int dial(), merror(), hangup();
extern int padopen(), paderror(), padclose(); 

/* Externals */

/* Used by getopt(3) package */
extern int getopt(), optind, opterr, optopt;
extern char *optarg;

/* Forward references */

extern int catchsignal();
extern int checklock();
extern void cleanup();
extern int changedir();
extern int checkcode();
extern int checkname();
extern int checkparam();
extern int checktime();
extern int connect();
extern void copy();
extern int divert();
extern int empty();
extern int ex();
extern int getargs();
extern int getcmd();
extern int gethdir();
extern int getname();
extern char getsystem();
extern uid_t get_uid();
extern int getuser();
extern void help();
extern void ontime();
extern void printmsg();
extern int putfile();
extern void s_copy();
extern int sendbreak();
extern int set_mode();
extern int setsignal();
extern int showio();
extern int takefile();
extern void t_copy();
extern int unlock();
extern void usage();
extern void wrapup();

/* EOF */

