##
##  Remove.sh
##
##  version:    1.2
##
##  author:     paul@max.uk.mugnet.org, paul@ukpoit.co.uk
##              Paul Wood, Sheffield, UK
##
##  purpose:    removes uucp
##

##
##  directories involved in the installation
##
UDIR="/usr/lib/uucp"
SDIR="/usr/spool/uucp"
PDIR="/usr/spool/uucppublic"

##
##  remove the UUCP directories
##
echo "removing directories ..."
for DIR in ${UDIR} ${PDIR}
do
    if [ -d "${DIR}" ]
    then
        echo "        ${DIR}"
        rm -rf ${DIR}
    fi
done
echo

##
## clear /usr/spool/uucp (used by kermit)
##
echo "clearing spool directory ..."
for i in ${SDIR}/*
do
        echo "        ${i}"
	rm -f ${i}
done
echo

##
##  remove uucp binaries from LBIN
##
echo "removing uucp binaries from ${LBIN} ..."
for PROG in cu uucheck uuclean uucp uulog uuname uupick uusched \
            uustat uusub uuto uux
do
    if [ -f "${LBIN}/${PROG}" ]
    then
        echo "        ${PROG}"
        rm -f ${LBIN}/${PROG}
    fi
done
echo

##
##  removal of uucp complete
##
echo "removal of uucp complete"
echo

##
##  end of Remove.sh
