##
##  Install.sh
##
##  version:    1.2
##
##  purpose:    installs uucp
##
##              may be executed repeatedly without adverse affect
##

##
##  directories involved in the installation
##  (LBIN is assumed to be a binary directory on the standard search path)
##
LBIN="/usr/local/bin"
UDIR="/usr/lib/uucp"
SDIR="/usr/spool/uucp"
XDIR="/usr/spool/uucp/.XQTDIR"
PDIR="/usr/spool/uucppublic"
RDIR="/usr/spool/uucppublic/receive"

##
##  display introduction
##
echo starting uucp installation ...
echo

##
##  if required, attempt to save the current uucp configuration
##
if [ -d "${UDIR}" ]
then
    if [ -s "${UDIR}/L.sys" ]
    then
        echo -n "save the current uucp configuration? [y|n]: "
        read ANSWER
        case "${ANSWER}" in
            y | Y | yes | Yes | YES )
                for FILE in L.sys L-devices L-dialcodes L-cmds SYSTEMNAME Poll USERFILE
                do
                    if [ -f "${UDIR}/${FILE}" ]
                    then
                        echo "        ${FILE}"
                        cp ${UDIR}/${FILE} .
                    fi
                done
                ;;
        esac
        echo
    fi
fi

##
##  make the necessary directories
##
echo "making directories ..."
for DIR in ${UDIR} ${SDIR} ${XDIR} ${PDIR} ${RDIR}
do
    if [ ! -d "${DIR}" ]
    then
        echo "        ${DIR}"
        mkdir ${DIR}
    fi
done
echo

##
##  change the directories ownerships
##
echo "changing directories ownerships ..."
for DIR in ${UDIR} ${SDIR} ${XDIR} ${PDIR} ${RDIR}
do
    echo "        ${DIR}"
    chown uucp.mail ${DIR}
done
echo

##
##  change the directories permissions
##
echo "changing directories permissions ..."
for DIR in ${UDIR} ${SDIR} ${XDIR} ${PDIR} ${RDIR}
do
    echo "        ${DIR}"
    chmod 777 ${DIR}
done
echo

##
##  install binaries in UDIR, clean out of LBIN
##
echo "installing binaries in ${UDIR} ..."
for BINARY in cu uucico uucheck uuclean uucp uulog uuname uupick uusched \
            uuschk uustat uusub uuto uux uuxqt
do
    if [ -f "${BINARY}" ]
    then
        echo "        ${BINARY}"
        rm -f ${LBIN}/${BINARY}
        cp ${BINARY} ${UDIR}
        strip ${UDIR}/${BINARY}
        chown uucp.bin ${UDIR}/${BINARY}
        chmod 4755 ${UDIR}/${BINARY}
    fi
done
echo

##
##  link binaries in UDIR to LBIN
##
echo "linking binaries to ${LBIN} ..."
for BINARY in cu uucheck uuclean uucp uulog uuname uupick uusched \
            uustat uusub uuto uux
do
    if [ -f "${UDIR}/${BINARY}" ]
    then
        echo "        ${BINARY}"
        ln ${UDIR}/${BINARY} ${LBIN}/${BINARY}
    fi
done
echo

##
##  install shells in UDIR
##
echo "installing shell scripts in ${UDIR} ..."
for SHELL in uudemon.hr uudemon.day uudemon.wk
do
    if [ -f "${SHELL}" ]
    then
        echo "        ${SHELL}"
        cp ${SHELL} ${UDIR}/${SHELL}
        chown uucp.bin ${UDIR}/${SHELL}
        chmod 755 ${UDIR}/${SHELL}
    fi
done
for SHELL in uudir uulck uupoll uutry
do
    if [ -f "${SHELL}.sh" ]
    then
        echo "        ${SHELL}"
        cp ${SHELL}.sh ${UDIR}/${SHELL}
        chown uucp.bin ${UDIR}/${SHELL}
        chmod 755 ${UDIR}/${SHELL}
    fi
done
echo
echo "linking shell scripts to ${LBIN} ..."
for SHELL in uutry uudir
do
    if [ -f "${UDIR}/${SHELL}" ]
    then
        rm -f ${LBIN}/${SHELL}
        ln ${UDIR}/${SHELL} ${LBIN}/${SHELL}
    fi
done
echo

##
##  install configuration and data files
##
echo "installing configuration and data files in ${UDIR} ..."
for FILE in L.sys L-devices L-dialcodes L-cmds Poll USERFILE
do
    if [ -f "${FILE}" ]
    then
        echo "        ${FILE}"
        cp ${FILE} ${UDIR}
        chown uucp.mail ${UDIR}/${FILE}
        chmod 644 ${UDIR}/${FILE}
    fi
done
echo

##
##  initialise the statistics files
##
echo "initialising statistics files in ${UDIR}..."
for FILE in L_stat R_stat
do
    if [ ! -f "${UDIR}/${FILE}" ]
    then
        echo "        ${FILE}"
        touch ${UDIR}/${FILE}
        chown uucp.bin ${UDIR}/${FILE}
        chmod 644 ${UDIR}/${FILE}
    fi
done
echo

##
##  set the system name
##
while [ "`uuname -l 2>/dev/null`" = "" ]
do
    echo -n "please enter system name: "
    read SYSTEM
    echo
    if [ "${SYSTEM}" != "" ]
    then
        uuname -S ${SYSTEM}
    fi
done

##
##  display mini-report
##
echo "system `uuname -l` can call ..."
uuname | while read SYSTEM
do
    echo "        ${SYSTEM}"
done
echo

##
##  installation complete!
##
echo "uucp installation complete"
echo

##
##  end of Install.sh
##
