#include <sys/types.h>
#include "dial.h"
#include <setjmp.h>
#include <signal.h>
#include <string.h>
#include "modemcap.h"

#define WAIT 40

static jmp_buf env;	/* long jump buffer if timeout in read */


static void timeout(void)
{
  longjmp(env, 1);
}


int mdial(telno, fd)
char *telno;
int fd;
{
  char buf[64];		/* telephone buffer if AS is false */
  char command[80];	/* dial command buffer */
  int i, j;		/* index and length of telephone number */
  char c;		/* single character for connection verification */
  void (*oldsig)();

  /* can't dial phone anyhow */
  if (! DI) return(A_PROB);

  /* never used any other kind of modem */
  if (! AS) return(A_PROB);
    else strcpy(buf, telno);	/* normal ascii character phone numbers	*/

  sprintf(command, "%s%s%s%s%s", CS, DS, buf, DE, CE);
  if (setjmp(env) != 0)	{	/* setjmp returns 0 on setup call */
	alarm(0);
	signal(SIGALRM, oldsig);
	return(D_HUNG);
  }

  oldsig = signal(SIGALRM, timeout);
  alarm(WAIT);
  write(fd, command, strlen(command));

  if (CO) {	/* verify connection */
	if (setjmp(env) != 0) {	
		alarm(0);
		signal(SIGALRM, oldsig);
		return(A_PROB);
	}
	signal(SIGALRM, timeout);
	if (TT) alarm(WAIT);
	  else alarm(WAIT + strlen(telno) * 2);

	for (i=0; CO[i] != 0; ) {
		if (read(fd, &c, 1) != 1) continue;
			
		if (CO[i] == c) i++;
		  else i = 0;
	}
  }
  alarm(0);
  signal(SIGALRM, oldsig);
  return(0);
}

