/* The <dial.h> header defines the items in dial(3) package. */

#ifndef _DIAL_H
#define _DIAL_H

typedef struct {
  struct sgttyb	*attr; 		/* pointer to termio attribute struct */
  int	baud;  			/* transmission data rate */
  int	speed; 			/* 212A modem: low=300, high=1200 */
  char	*line; 			/* device name for out-going line */
  char	*telno;			/* pointer to tel-no digits string */
  int	modem; 			/* specify modem control for direct lines */
} CALL;

#define	INTRPT  	-1	/* interrupt occurred */
#define	D_HUNG  	-2	/* dialer hung (no return from write) */
#define	NO_ANS  	-3	/* no answer within 10 seconds */
#define	ILL_BD  	-4	/* illegal baud-rate */
#define	A_PROB  	-5	/* acu problem (open() failure) */
#define	L_PROB  	-6	/* line problem (open() failure) */
#define	NO_Ldv  	-7	/* can't open LDEVS file */
#define	DV_NT_A 	-8	/* requested device not available */
#define	DV_NT_K 	-9	/* requested device not known */
#define	NO_BD_A 	-10	/* no device available at requested baud */
#define	NO_BD_K 	-11	/* no device known at requested baud */

#define LDEVS		"/usr/lib/uucp/L-devices"
#define DEVDIR		"/dev"
#define LOCK		"/usr/spool/uucp/LCK.."
#define DVC_LEN		30

/* Function Prototypes. */
#ifndef _ANSI_H
#include <ansi.h>
#endif

_PROTOTYPE( int dial, (CALL call)					);
_PROTOTYPE( void undial, (int fd)					);

#endif /* _DIAL_H */

