/*
 * dcputil.c 
 *
 * Revised^2 edition of dcp 	Peter Housel Nov '88
 *
 * Revised editition of dcp	Stuart Lynne May/87 
 *
 * Copyright (c) Richard H. Lamb 1985, 1986, 1987
 * Changes Copyright (c) Stuart Lynne 1987 
 *
 * miscellaneous utility functions
 */
#include "dcp.h"
#include <ctype.h>
#include <pwd.h>

/*
 * |uucpname()| returns a pointer to the local host's UUCP nodename.
 * There are several possible means of determining this, depending
 * on the operating system version. For now, this version just reads
 * one line from the |NODENAME| file, which is usually either "/etc/cpu"
 * or "/etc/uucpname".
 */
char *uucpname()
{
 FILE *uufile;
 static char uuname[SITENAMELEN];

 if(NULL == (uufile = fopen(NODENAME, "r")))
    return "";
 fgets(uuname, sizeof uuname, uufile);
 uuname[strlen(uuname) - 1] = '\0';	/* remove '\n' */
 fclose(uufile);

 return uuname;
}

/*
 * |printmsg(level, format, ...)| prints an error or debugging message
 * into the system error log file.  If not remote, also print to standard
 * error.  All messages at levels less than or equal to the current
 * |debuglevel| are printed.
 */
/* VARARGS1 */
printmsg(level, fmt, a1, a2, a3, a4, a5)
int level;
char *fmt;
char *a1, *a2, *a3, *a4, *a5;
{
 char msg[512];

 if(level <= debuglevel)
   {
    sprintf(msg, fmt, a1, a2, a3, a4, a5);
    strcat(msg, "\n");
    if(remote == MASTER && debuglevel > 0)
      fputs(msg, stderr);
    fputs(msg, logfile);
   }
}

/*
 * visib(data, length) prints the buffer of character data in "visible"
 * format. Printable characters (except '\') are printed as themselves,
 * special control characters (CR, LF, BS, HT) are printed in the usual
 * escape format, and others are printed using 3-digit octal escapes.
 * The usual warning about return value pointing to a static buffer which
 * is overwritten on each call applies here.
 */
char *visib(data, len)
char *data; int len;
{
 static char buf[256];
 char c, *p;

 p = buf;
 while(len--)
    {
     c = *data++;
     if(isascii(c) && (isprint(c) || ' ' == c))
	*p++ = c;
     else if('\n' == c)
       {*p++ = '\\';
	*p++ = 'n';
       }
     else if('\t' == c)
       {*p++ = '\\';
	*p++ = 't';
       }
     else if('\r' == c)
       {*p++ = '\\';
	*p++ = 'r';
       }
     else if('\b' == c)
       {*p++ = '\\';
	*p++ = 'b';
       }
     else
       {sprintf(p, "\\%03o", c);
	p += 4;
       }
    }
 *p = '\0';
 return buf;
}

/*
 * |getargs(str, argv)| breaks up |str|, which should be a string of
 * whitespace-separated fields, and places a pointer to each field
 * into the array pointed to by |argv|. The number of fields is
 * returned.
 */
int getargs(str, argv)
char *str; char *argv[];
{
 int nflds = 0;

 while(*str && isspace(*str))		/* leading space */
       ++str;

 while(*str && '\n' != *str)
      {
       ++nflds;				/* field */
       *argv++ = str;

       while(*str && !isspace(*str))	/* skip to end of field */
	     ++str;
       *str++ = '\0';			/* and terminate it with a null */

       while(*str && isspace(*str))	/* trailing space */
             ++str;
      }

 return nflds;
}

/*
 * |expandtilde(filename)| expands |filename| using the usual "~" convention.
 * That is, "~user" expands to the home directory of "user". "~" by itself
 * expands to the home directory of the effective userid, which in this
 * case is usually the /usr/spool/uucppublic directory. Care is taken not
 * to overflow the (static) name buffer.
 */
char *expandtilde(filename)
char *filename;
{
 struct passwd *pw, *getpwnam(), *getpwuid();
 static char namebuf[PATHLEN];
 char *p;

 if('~' != *filename)
    return filename;

 ++filename;
 p = namebuf;
 while(*filename && '/' != *filename && (p - namebuf) < PATHLEN)
       *p++ = *filename++;
 *p = '\0';

 if(strlen(namebuf) == 0)
    pw = getpwuid(geteuid());
 else
    pw = getpwnam(namebuf);

 if(NULL == pw)
    return NULL;

 if(strlen(pw->pw_dir) + strlen(filename) + 1 > PATHLEN)
    return NULL;
 strcpy(namebuf, pw->pw_dir);
 strcat(namebuf, filename);
 return namebuf;
}
