/* DCP a uucp clone. Copyright Richard H. Lamb 1985,1986,1987 */
#include <stdio.h>		/* Standard UNIX  definitions */

#define LSYS		"/usr/lib/uucp/L.sys"
#define NODENAME	"/etc/uucpname"
#define LOGFILE		"/usr/lib/uucp/LOGFILE"
#define PUBDIR		"/usr/spool/uucppublic"
#define SPOOLDIR	"/usr/spool/uucp"
#define CALLFILE	"C.%s"
#define XQTFILE		"X.%s"

#define SITENAMELEN	32
#define PATHLEN		256

#define MSGTIME         20
#define MAXPACK         256

#define DLE		'\020'	/* ASCII 'DLE' character */

#define	SLAVE	0
#define	MASTER	1

#ifndef TRUE
#define TRUE   (-1)
#define FALSE   0
#endif

#define SAME	0
#define FAILED	-1
#define OK		0

/* log messages */
#define M_ERROR		0	/* log regardless of debuglevel */
#define M_CALL		1	/* the call and pre-protocol negotiation */
#define M_CONVERSE	2	/* conversation level */
#define M_TRANSFER	3	/* file transfer */
#define M_SPOOL		4	/* spool files */
#define M_CALLMSG	5	/* messages sent out during call/pre-proto */
#define M_HIGHPROTO	6	/* high-level protocol */
#define M_MEDPROTO	7	/* med-level protocol */
#define M_LOWPROTO	8	/* low-level protocol (framing and such) */
#define M_DATA		9	/* actual packet data */
#define M_INFO		10	/* reading config files */

/* L.sys field defines */

#define	FLD_REMOTE	0	/* remote system name */
#define	FLD_CCTIME	1	/* legal call times */
#define	FLD_DEVICE	2	/* device, or ACU for modem */
#define	FLD_SPEED	3	/* bit rate */
#define FLD_PHONE	4	/* phone number */
#define	FLD_EXPECT	5	/* first login "expect" field */
#define FLD_SEND	6	/* first login "send" field */

typedef int (*procref) ();

typedef struct
{
   char type;
   procref a;
   procref b;
   procref c;
   procref d;
} Proto;

/* the various protocols available. Add here for others */
extern procref getpkt, sendpkt, openpk, closepk;

extern int ggetpkt(), gsendpkt(), gopenpk(), gclosepk();

/* [ I don't have these... ]
 * extern int	kgetpkt(), ksendpkt(), kopenpk(), kclosepk();
 * extern int	rgetpkt(), rsendpkt(), ropenpk(), rclosepk();
 * extern int	tgetpkt(), tsendpkt(), topenpk(), tclosepk(); 
 */

extern int pktsize;		/* packet size for this protocol */
extern FILE *logfile;		/* system log file */
extern FILE *fw;		/* cfile pointer */
extern char cfile[80];		/* work file name */
extern int remote;		/* -1 means we're remote */
extern int findwork;
extern int msgtime;		/* timeout setting */
extern char fromfile[132];	/* source of copy */
extern char tofile[132];	/* destiation of copy */
extern char state;		/* present state */
extern FILE *fp;		/* current disk file ptr */
extern int size;		/* nbytes in buff */
extern FILE *fsys;
extern char Rmtname[20];
extern char rmtname[20];
extern char *cctime;
	
extern int swritefd;		/* serial write file descriptor */
extern int sreadfd;		/* serial read file descriptor */
extern int timedout;

extern char sysline[BUFSIZ];
extern char s_systems[64];
extern char s_logfile[64];
extern char s_syslog[64];
extern char *flds[60];
extern int kflds;

extern int debuglevel;		/* debugging flag */
extern unsigned int checksum();
extern char *index();
extern char *rindex();

extern char *uucpname();
extern char *visib();

extern char speed[];
extern char device[];
extern char *nodename;
