/*
 * dcp.c 
 *
 * revised edition of dcp 
 *
 * stuart lynne may/87 
 *
 * copyright (c) richard h. lamb 1985, 1986, 1987 changes copyright (c) stuart
 * lynne 1987 
 *
 * "dcp" a uucp clone. copyright richard h. lamb 1985,1986,1987
 *
 * this program implements a uucico type file transfer and remote execution
 * type protocol. 
 */

#include <time.h>
#include "dcp.h"

int pktsize;			/* packet size for pro */
FILE *logfile;			/* system log file */
FILE *fw;			/* cfile pointer */
char state;			/* system state */
char cfile[80];			/* work file pointer */
int remote;			/* -1 means we're remote ..7 */
int msgtime;			/* timout setting */
char fromfile[132];		/* source of copy */
char tofile[132];		/* destination of copy */
FILE *fp;			/* current disk file ptr */
int size;			/* nbytes in buff */
time_t now;			/* current time */
FILE *fsys;			/* L.sys file pointer */
char Rmtname[20];
char rmtname[20];
char *cctime;			/* legal call times */
char proto[5];			/* list of protocols */
char *nodename;			/* UUCP node name */

char sysline[BUFSIZ];
char *flds[60];
int kflds;
int debuglevel;			/* debugging flag */

unsigned int checksum();

/*
 * usage:
 *
 *	dcp	[-xn]			slave mode
 *	dcp	[-xn] -r1 -shost 	call host
 *	dcp	[-xn] -r1 -sall		call all hosts
 *	dcp	[-xn] -r1		call any hosts as required by C. files 
 */

static void cant(file)
char *file;
{
   fprintf(stderr, "Can't open: \"%s\"\n", file);
   exit(NULL);
}

main(argc, argv)
int argc;
char *argv[];
{
 FILE *ftmp;
 char line[132];

 if((logfile = fopen(LOGFILE, "a")) == NULL)
    cant(LOGFILE);

 debuglevel = 0;
 fp = NULL;
 fw = NULL;
 nodename = uucpname();

 remote = SLAVE;
 strcpy(Rmtname, "any");
 
 while(--argc)
      {
       if(**++argv == '-')
	 {
	  switch(argv[0][1])
	        {
		 case 'x':
		 	debuglevel = atoi(&argv[0][2]);
			break;
		 case 's':
			remote = MASTER;
			sprintf(Rmtname, "%.7s", &argv[0][2]);
			break;
		 case 'r':
			remote = atoi(&argv[0][2]);
			break;

		 default:
			break;
		}
	 }
      }

 printmsg(M_INFO, "nodename = %s", nodename);

 if(remote == MASTER)
   {
    time(&now);
    printmsg(M_CALL, "Calling %s, debuglevel=%d (%.19s)", Rmtname, debuglevel,
		ctime(&now));

    if((fsys = fopen(LSYS, "r")) == NULL)
      exit(FAILED);
    state = 'I';

    while(TRUE)
         {
	  printmsg(M_CALL, "Mstate = %c", state);
	  switch(state)
	        {
		 case 'I':	/* no system, get one */
		 	state = getsystem();
			break;
		 case 'S':	/* got system, call it */
			state = callup();
			break;
		 case 'P':	/* called, negotiate protocol */
			state = startup();
			break;
		 case 'D':	/* got protocol, start running */
			state = master();
			break;
		 case 'Y':	/* abort */
			state = sysend();
			break;
		 case 'G':
			state = 'I';
			break;
#ifdef NOTDEF
			if(strcmp(Rmtname, "any") != SAME)
			  state = 'Y';
			else
			  state = 'I';
			break;
#endif
		}
	  if(state == 'A')
	    break;
	 }
    fclose(fsys);
   }
 else	/* slave */
   {
    state = '0';
    while(TRUE)
         {
	  printmsg(M_CALL, "Sstate = %c", state);
	  switch(state)
	        {
		 case '0':
			  if(initline() < 0)
			     state = 'Y';
			  else
			     state = 'I';
			  break;
		 case 'I':
			  state = startup();
			  break;
		 case 'R':
			  state = slave();
			  break;
		 case 'Y':
			  state = sysend();
			  break;
		}
	  if(state == 'A')
	    break;
	 }
    dcpundial();
   }

 /* fprintf( stderr, "calling dcxqt\n" ); */
 if (dcxqt())
   printmsg(M_ERROR, "ERROR in DCXQT");

 fclose(logfile);
 return 0;
}


/*
 * master
 */
master()
{
 state = 'I';
 while(TRUE)
      {
       printmsg(M_CONVERSE, "Top level state (master mode) %c", state);
       switch(state)
	     {
	      case 'I':
	      		state = sinit();
			break;
	      case 'B':
			state = scandir();
			break;
	      case 'S':
			state = sendf();
			break;
	      case 'Q':
			state = sbreak();
			break;
	      case 'G':
			state = recvf();
			break;
	      case 'C':
			state = 'Y';
			break;
	      case 'Y':
			state = endp();
			break;
	      case 'P':
			return ('Y');
	      case 'A':
			return ('A');
	      default:
			return ('A');
	     }
      }
}


/*
 * slave
 */
slave()
{
 state = 'I';
 while(TRUE)
      {
       printmsg(M_CONVERSE, "Top level state (slave mode) %c", state);
       switch(state)
	     {
	      case 'I':
	      		state = rinit();
			break;
	      case 'F':
			state = recvf();
			break;
	      case 'C':
			state = schkdir();
			break;
	      case 'T':
			state = 'B';
			break;
	      case 'B':
			state = scandir();
			break;
	      case 'S':
			state = sendf();
			break;
	      case 'Q':
			state = sbreak();
			break;
	      case 'G':
			return ('Y');
	      case 'Y':
			state = endp();
			break;
	      case 'P':
			return ('Y');
	      case 'A':
			return ('A');
	      default:
			return ('A');
	     }
      }
}

/*
 * r e c v f
 *
 * This is the state table switcher for receiving files. 
 */

recvf()
{
 state = 'F';			/* Receive-Init is the start state */

 while(TRUE)
      {
       printmsg(M_TRANSFER, " receive state: %c", state);
       switch(state)
	     {				/* Do until done */
	      case 'F':
	      		state = rfile();
			break;			/* Receive-File */
	      case 'D':
			state = rdata();
			break;			/* Receive-Data */
	      case 'C':
			return ('C');		/* Complete state */
	      case 'A':
			return ('Y');		/* "Abort" state */
	      default:
			return ('Y');
	     }
      }
}


/*
 * s e n d f
 *
 * Sendsw is the state table switcher for sending files. It loops until either
 * it finishes, or an error is encountered.  The routines called by sendsw
 * are responsible for changing the state. 
 *
 */
sendf()
{
 fp = NULL;			/* reset file getter/opener */
 state = 'F';			/* Send initiate is the start state */
 while(TRUE)
      {				/* Do this as long as necessary */
       printmsg(M_TRANSFER, "send state: %c", state);
       switch(state)
	     {
	      case 'F':
	      		state = sfile();
			break;			/* Send-File */
	      case 'D':
			state = sdata();
			break;			/* Send-Data */
	      case 'Z':
			state = seof();
			break;			/* Send-End-of-File */
	      case 'B':
			return ('B');		/* Complete */
	      case 'A':
			return ('Y');		/* "Abort" */
	      default:
			return ('Y');		/* Unknown, fail */
	     }
      }
}

/*
 * A command formatter for DCP. RH Lamb.
 * sets up stdin and stdout on various machines
 * There is NO command checking so watch what you send and who you
 * let accsess your machine. "C rm /usr/*.*" could be executed.
 */
dcxqt()
{
 int i;
 char command[60], input[60], output[60], line[BUFSIZ];
 char *cp;
 
 while(dscandir())
   {
    strcpy(line, cfile);
    fw = fopen(line, "r");	/* imported X file */
    strcpy(cfile, line);
    printmsg(M_INFO, "dcxqt:%s", cfile);
    input[0] = '\0';
    output[0] = '\0';
    command[0] = '\0';
    while(fgets(line, BUFSIZ, fw) != (char *) NULL)
         {
	  cp = index(line, '\n');
	  if(cp != (char *) NULL)
	    *cp = '\0';

	  printmsg(M_INFO, "dcxqt: %s", line);
	  switch(line[0])
	        {
		 case 'U':
		 	break;
		 case 'I':
			sprintf(input, "%s/%s", SPOOLDIR, &line[2]);
			break;
		 case 'O':
			sprintf(output, "%s/%s", SPOOLDIR, &line[2]);
			break;
		 case 'C':
			strcpy(command, &line[2]);
			break;
		 case 'R':
			break;
		 default:
			break;
		}
	 }
    fclose(fw);
    
    printmsg(M_CALL, "xqt: %s", command);

    shell(command, input, output, (char *) NULL);

    unlink(cfile);
    unlink(input);
    unlink(output);
   }
 return (0);
}
