/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Send a QUERY record to a name server.
 *
 * Version:	@(#)inet/res_send.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *              Changed for TNET, 07/12/92 by
 *              Michael Temari <temari@temari.ae.ge.com>
 */
#include <time.h>
#include <inet/socket.h>
#include <inet/in.h>
#include <errno.h>
#include <arpa/nameser.h>
#include <arpa/inet.h>
#include <resolv.h>
#include <stdio.h>
#ifdef _MINIX
#include <tnet/tnet.h>
#include <tnet/client.h>
#endif


#ifdef NETWORKED


#if _MINIX
typedef u_short fd_set;
#endif

static int s = -1;	/* socket used for communications */
#if _MINIX
static int _netout = -1;
#endif
static struct sockaddr no_addr;
  

#ifndef FD_SET
#   define NFDBITS		32
#   define FD_SETSIZE		32
#   define FD_SET(n, p)		((p)->fds_bits[(n)/NFDBITS] |= \
					(1 << ((n) % NFDBITS)))
#   define FD_CLR(n, p)		((p)->fds_bits[(n)/NFDBITS] &= \
					~(1 << ((n) % NFDBITS)))
#   define FD_ISSET(n, p)	((p)->fds_bits[(n)/NFDBITS] & \
					(1 << ((n) % NFDBITS)))
#   define FD_ZERO(p)		bzero((char *)(p), sizeof(*(p)))
#endif


_PROTOTYPE( void _res_close, (void)					);


int res_send(buf, buflen, answer, anslen)
char *buf;
int buflen;
char *answer;
int anslen;
{
  register int n;
  int try, v_circuit, resplen, ns;
  int gotsomewhere = 0, connected = 0;
  int connreset = 0;
  u_short id, len;
  char *cp;
#if 0
  fd_set dsmask;
  struct timeval timeout;
#endif
  HEADER *hp = (HEADER *) buf;
  HEADER *anhp = (HEADER *) answer;
#if 0
  struct iovec iov[2];
#endif
  int terrno = -1 /* ETIMEDOUT */;
  char junk[512];
#if _MINIX
  int status;
#endif

#ifdef DEBUG
  if (_res.options & RES_DEBUG) {
	printf("res_send()\n");
	p_query(buf);
  }
#endif
  if (!(_res.options & RES_INIT))
	if (res_init() == -1) {
			return(-1);
	}
#if 0
  v_circuit = (_res.options & RES_USEVC) || buflen > PACKETSZ;
#else
  v_circuit = 1;
#endif
  id = hp->id;
  /*
   * Send request, RETRY times, or until successful
   */
  for (try = 0; try < _res.retry; try++) {
	for (ns = 0; ns < _res.nscount; ns++) {
#ifdef DEBUG
		if (_res.options & RES_DEBUG)
			printf("Querying server (# %d) address = %s\n", ns+1,
			      inet_ntoa(_res.nsaddr_list[ns].sin_addr));
#endif
usevc:
		if (v_circuit) {
			int truncated = 0;

			/*
			 * Use virtual circuit;
			 * at most one attempt per server.
			 */
			try = _res.retry;
			if (s < 0) {
#if _MINIX
				status = client(TCP_PTCL, 0,
					htons(_res.nsaddr_list[ns].sin_port),
					_res.nsaddr_list[ns].sin_addr.s_addr,
					&s, &_netout);
				if (status != 0) {
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
						perror("CLIENT failed");
#endif
					s = -1;
					terrno = ECONNREFUSED;
					continue;
				}
#endif
#if 0
				s = socket(AF_INET, SOCK_STREAM, 0);
				if (s < 0) {
					terrno = errno;
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
					    perror("socket (vc) failed");
#endif
					continue;
				}
				if (connect(s, &(_res.nsaddr_list[ns]),
				   sizeof(struct sockaddr)) < 0) {
					terrno = errno;
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
					    perror("connect failed");
#endif
					(void) close(s);
					s = -1;
					continue;
				}
#endif
			}
			/*
			 * Send length & message
			 */
			len = htons((u_short)buflen);
#if 0
			iov[0].iov_base = (caddr_t)&len;
			iov[0].iov_len = sizeof(len);
			iov[1].iov_base = buf;
			iov[1].iov_len = buflen;
			if (writev(s, iov, 2) != sizeof(len) + buflen) {
				terrno = errno;
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("write failed");
#endif
				(void) close(s);
				s = -1;
				continue;
			}
#endif
#if _MINIX
			if (write(_netout, (char *)&len, sizeof(len)) !=
				sizeof(len)) {
				terrno = ECONNREFUSED;
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("WRITE LEN FAILED");
#endif
				(void) close(s);
				(void) close(_netout);
				s = -1;
				continue;
			}
			if (write(_netout, (char *)buf, buflen) != buflen) {
				terrno = ECONNREFUSED;
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("WRITE BUF FAILED");
#endif
				(void) close(s);
				(void) close(_netout);
				s = -1;
				continue;
			}
#endif	/* _MINIX */
			/*
			 * Receive length & response
			 */
			cp = answer;
			len = sizeof(short);
			while (len != 0 &&
			    (n = read(s, (char *)cp, (int)len)) > 0) {
				cp += n;
				len -= n;
			}
			if (n <= 0) {
				terrno = errno;
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("read failed");
#endif
				(void) close(s);
#if _MINIX
				(void) close(_netout);
#endif
				s = -1;
				/*
				 * A long running process might get its TCP
				 * connection reset if the remote server was
				 * restarted.  Requery the server instead of
				 * trying a new one.  When there is only one
				 * server, this means that a query might work
				 * instead of failing.  We only allow one reset
				 * per query to prevent looping.
				 */
				if (terrno == -1 /* ECONNRESET */ && !connreset) {
					connreset = 1;
					ns--;
				}
				continue;
			}
			cp = answer;
			if ((resplen = ntohs(*(u_short *)cp)) > anslen) {
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					fprintf(stderr, "response truncated\n");
#endif
				len = anslen;
				truncated = 1;
			} else
				len = resplen;
			while (len != 0 &&
			   (n = read(s, (char *)cp, (int)len)) > 0) {
				cp += n;
				len -= n;
			}
			if (n <= 0) {
				terrno = errno;
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("read failed");
#endif
				(void) close(s);
#if _MINIX
				(void) close(_netout);
#endif
				s = -1;
				continue;
			}
			if (truncated) {
				/*
				 * Flush rest of answer
				 * so connection stays in synch.
				 */
#if 0
				anhp->tc = 1;
#endif
				len = resplen - anslen;
				while (len != 0) {
					n = (len > sizeof(junk) ?
					    sizeof(junk) : len);
					if ((n = read(s, junk, n)) > 0)
						len -= n;
					else
						break;
				}
			}
		} else {
#if 0
			/*
			 * Use datagrams.
			 */
			if (s < 0) {
				s = socket(AF_INET, SOCK_DGRAM, 0);
				if (s < 0) {
					terrno = errno;
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
					    perror("socket (dg) failed");
#endif
					continue;
				}
			}
#if	BSD >= 43
			/*
			 * I'm tired of answering this question, so:
			 * On a 4.3BSD+ machine (client and server,
			 * actually), sending to a nameserver datagram
			 * port with no nameserver will cause an
			 * ICMP port unreachable message to be returned.
			 * If our datagram socket is "connected" to the
			 * server, we get an ECONNREFUSED error on the next
			 * socket operation, and select returns if the
			 * error message is received.  We can thus detect
			 * the absence of a nameserver without timing out.
			 * If we have sent queries to at least two servers,
			 * however, we don't want to remain connected,
			 * as we wish to receive answers from the first
			 * server to respond.
			 */
			if (_res.nscount == 1 || (try == 0 && ns == 0)) {
				/*
				 * Don't use connect if we might
				 * still receive a response
				 * from another server.
				 */
				if (connected == 0) {
					if (connect(s, &_res.nsaddr_list[ns],
					    sizeof(struct sockaddr)) < 0) {
#ifdef DEBUG
						if (_res.options & RES_DEBUG)
							perror("connect");
#endif
						continue;
					}
					connected = 1;
				}
				if (send(s, buf, buflen, 0) != buflen) {
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
						perror("send");
#endif
					continue;
				}
			} else {
				/*
				 * Disconnect if we want to listen
				 * for responses from more than one server.
				 */
				if (connected) {
					(void) connect(s, &no_addr,
					    sizeof(no_addr));
					connected = 0;
				}
#endif	/* BSD */
				if (sendto(s, buf, buflen, 0,
				    &_res.nsaddr_list[ns],
				    sizeof(struct sockaddr)) != buflen) {
#ifdef DEBUG
					if (_res.options & RES_DEBUG)
						perror("sendto");
#endif
					continue;
				}
#if	BSD >= 43
			}
#endif

			/*
			 * Wait for reply
			 */
			timeout.tv_sec = (_res.retrans << try);
			if (try > 0)
				timeout.tv_sec /= _res.nscount;
			if (timeout.tv_sec <= 0)
				timeout.tv_sec = 1;
			timeout.tv_usec = 0;
wait:
			FD_ZERO(&dsmask);
			FD_SET(s, &dsmask);
			n = select(s+1, &dsmask, (fd_set *)NULL,
				(fd_set *)NULL, &timeout);
			if (n < 0) {
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("select");
#endif
				continue;
			}
			if (n == 0) {
				/*
				 * timeout
				 */
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					printf("timeout\n");
#endif
#if BSD >= 43
				gotsomewhere = 1;
#endif
				continue;
			}
			if ((resplen = recv(s, answer, anslen, 0)) <= 0) {
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					perror("recvfrom");
#endif
				continue;
			}
			gotsomewhere = 1;
			if (id != anhp->id) {
				/*
				 * response from old query, ignore it
				 */
#ifdef DEBUG
				if (_res.options & RES_DEBUG) {
					printf("old answer:\n");
					p_query(answer);
				}
#endif
				goto wait;
			}
			if (!(_res.options & RES_IGNTC) && anhp->tc) {
				/*
				 * get rest of answer;
				 * use TCP with same server.
				 */
#ifdef DEBUG
				if (_res.options & RES_DEBUG)
					printf("truncated answer\n");
#endif
				(void) close(s);
				s = -1;
				v_circuit = 1;
				goto usevc;
			}
#endif
		}
#ifdef DEBUG
		if (_res.options & RES_DEBUG) {
			printf("got answer:\n");
			p_query(answer);
		}
#endif
		/*
		 * If using virtual circuits, we assume that the first server
		 * is preferred * over the rest (i.e. it is on the local
		 * machine) and only keep that one open.
		 * If we have temporarily opened a virtual circuit,
		 * or if we haven't been asked to keep a socket open,
		 * close the socket.
		 */
		if ((v_circuit &&
		    ((_res.options & RES_USEVC) == 0 || ns != 0)) ||
		    (_res.options & RES_STAYOPEN) == 0) {
			(void) close(s);
#if _MINIX
			(void) close(_netout);
#endif
			s = -1;
		}
		return (resplen);
	   }
	}
	if (s >= 0) {
		(void) close(s);
#if _MINIX
		(void) close(_netout);
#endif
		s = -1;
	}
	if (v_circuit == 0)
		if (gotsomewhere == 0)
			errno = ECONNREFUSED;	/* no nameservers found */
		else
			errno = ETIMEDOUT;	/* no answer obtained */
	else
		errno = terrno;
	return (-1);
}

/*
 * This routine is for closing the socket if a virtual circuit is used and
 * the program wants to close it.  This provides support for endhostent()
 * which expects to close the socket.
 *
 * This routine is not expected to be user visible.
 */
void _res_close()
{
	if (s != -1) {
		(void) close(s);
#if _MINIX
		(void) close(_netout);
#endif
		s = -1;
	}
}
#endif	/* NETWORKED */
