/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles lookups in the /etc/services database.
 *		It is used to map service names to Internet ports.
 *
 * Version:	@(#)inet/getservent.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <netdb.h>
#include <ctype.h>
#include <stdio.h>


#define	MAXALIASES	35


static FILE		*servf = (FILE *)NULL;
static char		line[BUFSIZ+1];
static struct servent	serv;
static char		*aliases[MAXALIASES];
static int		stayopen;


_PROTOTYPE( char *any, (char *cp, char *match)				);


static char *any(cp, match)
register char *cp;
char *match;
{
  register char *mp, c;

  while (c = *cp) {
	for (mp = match; *mp; mp++)
		if (*mp == c) return(cp);
	cp++;
  }
  return((char *)NULL);
}


void setservent(f)
int f;
{
  if (servf == (FILE *)NULL) servf = fopen(_PATH_SERVICES, "r");
    else rewind(servf);
  stayopen |= f;
}


void endservent()
{
  if (servf) {
	fclose(servf);
	servf = (FILE *)NULL;
  }
  stayopen = 0;
}


struct servent *getservent()
{
  char *p;
  register char *cp, **q;

  if (servf == (FILE *)NULL &&
      (servf = fopen(_PATH_SERVICES, "r")) == (FILE *)NULL)
					return((struct servent *)NULL);
again:
  if ((p = fgets(line, BUFSIZ, servf)) == (char *)NULL)
					return((struct servent *)NULL);
  if (*p == '#') goto again;
  cp = any(p, "#\n");
  if (cp == (char *)NULL) goto again;
  *cp = '\0';
  serv.s_name = p;
  p = any(p, " \t");
  if (p == (char *)NULL) goto again;
  *p++ = '\0';
  while (*p == ' ' || *p == '\t') p++;
  cp = any(p, ",/");
  if (cp == (char *)NULL) goto again;
  *cp++ = '\0';
  serv.s_port = (u_short)atoi(p);
  serv.s_proto = cp;
  q = serv.s_aliases = aliases;
  cp = any(cp, " \t");
  if (cp != (char *)NULL) *cp++ = '\0';
  while (cp && *cp) {
	if (*cp == ' ' || *cp == '\t') {
		cp++;
		continue;
	}
	if (q < &aliases[MAXALIASES - 1]) *q++ = cp;
	cp = any(cp, " \t");
	if (cp != (char *)NULL) *cp++ = '\0';
  }
  *q = (char *)NULL;
  return(&serv);
}


struct servent *getservbyname(name, proto)
char *name, *proto;
{
  register struct servent *p;
  register char **cp;

  setservent(stayopen);
  while (p = getservent()) {
	if (strcmp(name, p->s_name) == 0) goto gotname;
	for (cp = p->s_aliases; *cp; cp++)
		if (strcmp(name, *cp) == 0) goto gotname;
	continue;
gotname:
	if (proto == 0 || strcmp(p->s_proto, proto) == 0) break;
  }
  if (!stayopen) endservent();
  return(p);
}


struct servent *getservbyport(port, proto)
int port;
char *proto;
{
  register struct servent *p;

  setservent(stayopen);
  while (p = getservent()) {
	if (p->s_port != port) continue;
	if (proto == 0 || strcmp(p->s_proto, proto) == 0) break;
  }
  if (!stayopen) endservent();
  return(p);
}
