/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles lookups in the /etc/protocols database.
 *		It is used to map from protocol names to Internet ports.
 *
 * Version:	@(#)inet/getprtoent.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <netdb.h>
#include <ctype.h>
#include <stdio.h>


#define	MAXALIASES	35


static FILE		*protof = (FILE *)NULL;
static char		line[BUFSIZ+1];
static struct protoent	proto;
static char		*aliases[MAXALIASES];
static char		*any();
static int		stayopen;


_PROTOTYPE( char *any, (char *cp, char *match)				);


static char *any(cp, match)
register char *cp;
char *match;
{
  register char *mp, c;

  while (c = *cp) {
	for (mp = match; *mp; mp++) {
		if (*mp == c) return (cp);
	}
	cp++;
  }
  return((char *)NULL);
}


void setprotoent(f)
int f;
{
  if (protof == (FILE *)NULL) protof = fopen(_PATH_PROTOCOLS, "r");
    else rewind(protof);
  stayopen |= f;
}


void endprotoent()
{
  if (protof) {
	fclose(protof);
	protof = (FILE *)NULL;
  }
  stayopen = 0;
}


struct protoent *getprotoent()
{
  char *p;
  register char *cp, **q;

  if (protof == (FILE *)NULL &&
      (protof = fopen(_PATH_PROTOCOLS, "r" )) == (FILE *)NULL)
					return((struct protoent *)NULL);
again:
  if ((p = fgets(line, BUFSIZ, protof)) == (char *)NULL)
					return((struct protoent *)NULL);
  if (*p == '#') goto again;
  cp = any(p, "#\n");
  if (cp == (char *)NULL) goto again;
  *cp = '\0';
  proto.p_name = p;
  cp = any(p, " \t");
  if (cp == (char *)NULL) goto again;
  *cp++ = '\0';
  while (*cp == ' ' || *cp == '\t') cp++;
  p = any(cp, " \t");
  if (p != (char *)NULL) *p++ = '\0';
  proto.p_proto = atoi(cp);
  q = proto.p_aliases = aliases;
  if (p != (char *)NULL) {
	cp = p;
	while (cp && *cp) {
		if (*cp == ' ' || *cp == '\t') {
			cp++;
			continue;
		}
		if (q < &aliases[MAXALIASES - 1]) *q++ = cp;
		cp = any(cp, " \t");
		if (cp != (char *)NULL) *cp++ = '\0';
	}
  }
  *q = (char *)NULL;
  return(&proto);
}


struct protoent *getprotobynumber(proto)
register int proto;
{
  register struct protoent *p;

  setprotoent(stayopen);
  while (p = getprotoent()) {
	if (p->p_proto == proto) break;
  }
  if (!stayopen) endprotoent();
  return(p);
}


struct protoent *getprotobyname(name)
register char *name;
{
  register struct protoent *p;
  register char **cp;

  setprotoent(stayopen);
  while (p = getprotoent()) {
	if (strcmp(p->p_name, name) == 0) break;
	for (cp = p->p_aliases; *cp != 0; cp++)
		if (strcmp(*cp, name) == 0) goto found;
  }
found:
  if (!stayopen) endprotoent();
  return(p);
}
