/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles lookups in the /etc/networks database.
 *		It is used to map from network names to Internet
 *		addresses.
 *
 * Version:	@(#)inet/getnetent.c	1.00		07/11/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/inet.h>
#include <inet/socket.h>
#include <netdb.h>
#include <ctype.h>
#include <stdio.h>


#define	MAXALIASES	35


static FILE		*netf = (FILE *)NULL;
static char		line[BUFSIZ+1];
static struct netent	net;
static char		*aliases[MAXALIASES];
static int		stayopen;


_PROTOTYPE( char *any, (char *cp, char *match)				);


static char *any(cp, match)
register char *cp;
char *match;
{
  register char *mp, c;

  while (c = *cp) {
	for (mp = match; *mp; mp++)
		if (*mp == c) return(cp);
	cp++;
  }
  return((char *)NULL);
}


void setnetent(f)
int f;
{
  if (netf == (FILE *)NULL) netf = fopen(_PATH_NETWORKS, "r");
    else rewind(netf);
  stayopen |= f;
}


void endnetent()
{
  if (netf) {
	fclose(netf);
	netf = (FILE *)NULL;
  }
  stayopen = 0;
}


struct netent *getnetent()
{
  char *p;
  register char *cp, **q;

  if (netf == (FILE *)NULL &&
      (netf = fopen(_PATH_NETWORKS, "r" )) == (FILE *)NULL)
					return((struct netent *)NULL);
again:
  p = fgets(line, BUFSIZ, netf);
  if (p == (char *)NULL) return((struct netent *)NULL);
  if (*p == '#') goto again;
  cp = any(p, "#\n");
  if (cp == (char *)NULL) goto again;
  *cp = '\0';
  net.n_name = p;
  cp = any(p, " \t");
  if (cp == (char *)NULL) goto again;
  *cp++ = '\0';
  while (*cp == ' ' || *cp == '\t') cp++;
  p = any(cp, " \t");
  if (p != (char *)NULL) *p++ = '\0';
  net.n_net = inet_network(cp);
  net.n_addrtype = AF_INET;
  q = net.n_aliases = aliases;
  if (p != (char *)NULL) cp = p;
  while (cp && *cp) {
	if (*cp == ' ' || *cp == '\t') {
		cp++;
		continue;
	}
	if (q < &aliases[MAXALIASES - 1]) *q++ = cp;
	cp = any(cp, " \t");
	if (cp != (char *)NULL) *cp++ = '\0';
  }
  *q = (char *)NULL;
  return(&net);
}


struct netent *getnetbyaddr(net, type)
register u_long net;
register int type;
{
  register struct netent *p;

  setnetent(stayopen);
  while (p = getnetent()) {
	if (p->n_addrtype == type && p->n_net == net) break;
  }
  if (!stayopen) endnetent();
  return(p);
}


struct netent *getnetbyname(name)
register char *name;
{
  register struct netent *p;
  register char **cp;

  setnetent(stayopen);
  while (p = getnetent()) {
	if (strcmp(p->n_name, name) == 0) break;
	for (cp = p->n_aliases; *cp != 0; cp++) {
		if (strcmp(*cp, name) == 0) goto found;
	}
  }
found:
  if (!stayopen) endnetent();
  return(p);
}
