/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file handles problems of byte ordering and word
 *		ordering between the Network Standard Order (as used
 *		inside TCP/IP packets) and the host's internal order.
 *
 * NOTE:	This implementation is for Little Endian machines,
 *		like the entire iNTEL family of microprocessors.
 *
 * Version:	@(#)inet/_byteorder.c	1.00		07/11/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <arpa/internet.h>
#include <inet/in.h>

/*
 * Routines to insert/extract short/long's. Must account for byte
 * order and non-alignment problems. This code at least has the
 * advantage of being portable.
 */
u_short _getshort(msgp)
u_char *msgp;
{
  u_char *p = (u_char *) msgp;
  u_short u;

  u = *p++;
  u <<= 8;
  u |= *p;
  return(u);
}


u_long _getlong(msgp)
u_char *msgp;
{
  u_char *p = (u_char *) msgp;
  u_long u;
  u_short x;

  x = *p; u = x; p++; u <<= 8;
  x = *p; u |= x; p++; u <<= 8;
  x = *p; u |= x; p++; u <<= 8;
  x = *p; u |= x;
  return(u);
}


void putshort(s, msgp)
u_short s;
u_char *msgp;
{
  msgp[1] = s;
  msgp[0] = s >> 8;
}


void putlong(l, msgp)
u_long l;
u_char *msgp;
{
  msgp[3] = (u_char) l;
  l >>= 8;
  msgp[2] = (u_char) l;
  l >>= 8;
  msgp[1] = (u_char) l;
  l >>= 8;
  msgp[0] = (u_char) l;
}
