/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *		This file holds the general definitions of the TNET
 *		package, including configuration and feature selection.
 *		It gets included by every single file of this package,
 *		and it should handle most of the OS-dependent and
 *		configuration-dependent things.
 *
 * Version:	@(#)tnet.h		1.00	07/07/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>

/*
 * The next few files are "generalized" versions of the ones
 * supplied with KA9Q/NET.  Many files have been added (these
 * come from BSD 4.3RENO and BSD 4.3TAHOE).
 */
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>

/* TNET feature selection. */
#define HAVE_DEBUG	0		/* include debugging code	*/
#define HAVE_TRACE	0		/* include packet tracing code	*/
#define HAVE_SLIP	1		/* include the SLIP support	*/
#define HAVE_CSLIP	0		/* include the CSLIP supprt	*/
#define HAVE_PPP	0		/* include the PPP support	*/
#define HAVE_ETHER	1		/* include the Ethernet support	*/
#define HAVE_TEMARI	0		/* include Temari's work stuff	*/
#define HAVE_LOCK	1		/* use the device locking code	*/
#define	HAVE_SELECT	1		/* use the select system call   */

#include "machdep.h"
#include "global.h"
