/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Various definitions for the 'nproc' module.
 *
 * Version:	@(#)nproc.h		1.00	07/02/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

#define	NNPROC		20


struct nproc {
  int		type;
  int		sendok;
  struct tcb	*tcb;
  struct socket	lsocket;
  int		fdin;
  int		fdout;
  int		pid;
};
extern struct nproc nproc[];


_PROTOTYPE( void initnproc, (void)					);
_PROTOTYPE( int ffnproc, (void)						);
_PROTOTYPE( void icmp_proc, (struct mbuf *)					);
_PROTOTYPE( void freenproc, (int i)					);
_PROTOTYPE( int cnproc, (int protocol, int16 *lport, int16 *rport,
			 int32 *addr, int32 flags)			);
_PROTOTYPE( void DOnproc, (void)					);
_PROTOTYPE( void in_char, (struct tcb *, int16)				);
_PROTOTYPE( void send_okay, (struct tcb *, int16)			);
_PROTOTYPE( int  data_in, (struct mbuf *, int)				);
/* _PROTOTYPE( void chg_state, (struct tcb *, char, char)			); */
