/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for the IFACE (device interface) module.
 *		This is the link between IP routes and the attached
 *		device drivers.
 *
 * Version:	@(#)iface.h		1.00	07/12/92
 *
 * Authors:	Original by Phil Karn KA9Q.
 *		Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */

/* Interface control structure */
struct interface {
  struct interface *next;	/* Linked list pointer			*/
  char	*name;			/* Ascii string with interface name	*/
  int16	mtu;			/* Maximum transmission unit size	*/
  int	(*send)();		/* Routine to call to send IP datagram	*/
  int	(*output)();		/* Routine to call to send raw packet	*/
  int	(*recv)();		/* Routine to kick to process input	*/
  int	(*stop)();		/* Routine to call before detaching	*/
  int	fdin;
  int	fdout;
  int	pid;
  int	class;			/* device driver class			*/
  int16	flags;			/* State of interface			*/
  char	*lock;			/* Lock file for device			*/
  char	*devname;		/* name of /dev/XXXX device file	*/
  int32	ipaddr;			/* IP addr of this interface		*/
  int32	netmask;		/* IP address net mask			*/
  int16	trace;			/* tracing mask				*/
  int16	pkt_in;			/* #packets received			*/
  int16	pkt_out;		/* #packets sent out			*/
};
#define	IF_ACTIVE	0x01
#define	IF_TAKENF	0x02	/* Accept packets marked "no forwarding"*/
#define	IF_BROADCAST	0x04	/* Interface is capable of broadcasting */
#define	NULLIF	(struct interface *)NULL
extern struct interface *ifaces;	/* Head of interface list */
