/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Global defines and variables for resolver stub.
 *
 * Version:	@(#)resolv.h		1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _RESOLV_H
#define _RESOLV_H

#define ADDRSORT	1	/* enable the addr-sorting option	*/
#define MAXADDR		10	/* max # addresses to sort by		*/

#define	MAXNS		3	/* max # name servers we'll track	*/
#define	MAXDNSRCH	3	/* max # default domain levels to try 	*/
#define	MAXDFLSRCH	3	/* max # default domain levels to try	*/
#define	LOCALDOMAINPARTS 2	/* min levels in name that is "local"	*/

#define	RES_TIMEOUT	6	/* seconds between retries		*/

struct state {
  int			retrans;	/* retransmition time interval	*/
  int			retry;		/* #times to retransmit		*/
  long			options;	/* option flags - see below.	*/
  int			nscount;	/* number of name servers	*/
  struct sockaddr_in	nsaddr_list[MAXNS];	/* addr of name server	*/
#define	nsaddr    	nsaddr_list[0]	/* for backward compatibility	*/
  u_short         	id;			/* current packet id	*/
  char            	defdname[MAXDNAME];	/* default domain	*/
  char            	*dnsrch[MAXDNSRCH+1];	/* components of domain	*/
						/*	 to search	*/
  int             	ascount;		/* number of addresses	*/
  struct in_addr  	sort_list[MAXADDR]; /* address sorting list	*/
};


/* Resolver options. */
#define RES_INIT	0x0001		/* address initialized		*/
#define RES_DEBUG	0x0002		/* print debug messages		*/
#define RES_AAONLY	0x0004		/* authoritative answers only	*/
#define RES_USEVC	0x0008		/* use virtual circuit		*/
#define RES_PRIMARY	0x0010		/* query primary server only	*/
#define RES_IGNTC	0x0020		/* ignore trucation errors	*/
#define RES_RECURSE	0x0040		/* recursion desired		*/
#define RES_DEFNAMES	0x0080		/* use default domain name	*/
#define RES_STAYOPEN	0x0100		/* Keep TCP socket open		*/
#define RES_DNSRCH	0x0200		/* search up local domain tree	*/

#define RES_DEFAULT	(RES_RECURSE | RES_DEFNAMES | RES_DNSRCH)

extern struct state _res;

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

#if 0
_PROTOTYPE( char *p_cdname, ()						);
_PROTOTYPE( char *p_rr, ()						);
_PROTOTYPE( char *p_type, ()						);
_PROTOTYPE( p_class, ()							);
#endif
_PROTOTYPE( char *hostalias, (char *name)				);

#endif /* _RESOLV_H */
