/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for the Trivial File Transfer Protocol
 *		(see IEN-133) .
 *
 * Version:	@(#)arpa/tftp.h		1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _ARPA_TFTP_H
#define _ARPA_TFTP_H

#define	SEGSIZE		512		/* data segment size		*/

/* Packet types. */
#define	RRQ		01		/* read request			*/
#define	WRQ		02		/* write request		*/
#define	DATA		03		/* data packet			*/
#define	ACK		04		/* acknowledgement		*/
#define	ERROR		05		/* error code			*/

struct	ftphdr {
  u_short	th_opcode;		/* packet type			*/
  union {
	u_short	tu_block;		/* block #			*/
	u_short	tu_code;		/* error code			*/
	char	tu_stuff[1];		/* request packet stuff		*/
  } th_u;
  char		th_data[1];		/* data or error string		*/
};
#define	th_block	th_u.tu_block
#define	th_code		th_u.tu_code
#define	th_stuff	th_u.tu_stuff
#define	th_msg		th_data

/* Error codes. */
#define	EUNDEF		0		/* not defined			*/
#define	ENOTFOUND	1		/* file not found		*/
#define	EACCESS		2		/* access violation		*/
#define	ENOSPACE	3		/* disk full or alloc exceeded	*/
#define	EBADOP		4		/* illegal TFTP operation	*/
#define	EBADID		5		/* unknown transfer ID		*/
#define	EEXISTS		6		/* file already exists		*/
#define	ENOUSER		7		/* no such user			*/

#endif /* _ARPA_TFTP_H */
