/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Global structures and constants pertaining to the
 *		interface between IP and higher level protocols.
 *
 * Version:	@(#)arpa/internet.h	1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _ARPA_INTERNET_H
#define _ARPA_INTERNET_H

typedef unsigned long	u_long;		/* 32-bit unsigned integer	*/
typedef unsigned short	u_short;	/* 16-bit unsigned integer	*/
typedef unsigned char	u_char;		/* unsigned char		*/


/* IP protocol field values. */
#define	ICMP_PTCL	1		/* Control Message Protocol	*/
#define	TCP_PTCL	6		/* Transmission Control Protocol */
#define	UDP_PTCL	17		/* User Datagram Protocol	*/

#define	MAXTTL		255		/* max possible IP "ttl" value	*/

/* DoD-style precedences. */
#define	ROUTINE		0x00
#define	PRIORITY	0x20
#define	IMMEDIATE	0x40
#define	FLASH		0x60
#define	FLASH_OVER	0x80
#define	CRITIC		0xa0
#define	INET_CTL	0xc0
#define	NET_CTL		0xe0

/* Amateur-style precedences */
#define	AM_ROUTINE	0x00
#define	AM_WELFARE	0x20
#define	AM_PRIORITY	0x40
#define	AM_EMERGENCY	0x60

/* Class-of-service bits. */
#define	LOW_DELAY	0x10
#define	THROUGHPUT	0x08
#define	RELIABILITY	0x04

/* IP TOS fields. */
#define	PREC(x)		((x)>>5 & 7)
#define	DELAY		0x10
#define	THRUPUT		0x8
#define	RELIABLITY	0x4

/* Pseudo-header for TCP and UDP checksumming. */
struct pseudo_header {
  u_long	source;			/* IP source			*/
  u_long	dest;			/* IP destination		*/
  char		zero;
  char		protocol;		/* Protocol			*/
  u_short	length;			/* Data field length		*/
};
#define	NULLHEADER	((struct pseudo_header *)0)

#endif	/* _ARPA_INTERNET_H */
