/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Definitions for INET(3N) functions.
 *
 * Version:	@(#)arpa/inet.h		1.00		07/02/92
 *
 * Authors:	Original taken from BSD 4.3/TAHOE.
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#ifndef _ARPA_INET_H
#define _ARPA_INET_H

#include <arpa/internet.h>


/* MINIX short names :-( */
#if _MINIX
#   define inet_addr		in_addr
#   define inet_aton		in_aton
#   define inet_lnaof		in_lnaof
#   define inet_makeaddr	in_mkadr
#   define inet_netof		in_netof
#   define inet_network		in_ntwrk
#   define inet_ntoa		in_ntoa
#endif

/* Function prototyping according to ANSI. */
#ifndef _PROTOTYPE
#    if _MINIX
#	include <ansi.h>
#    else
#	define _ANSI		0
#	ifdef __STDC__		
#	    if (__STDC__ == 1)	
#	    	undef _ANSI
#	    	define _ANSI	1
#	    endif
#	endif
#	if _ANSI
#	    define	_PROTOTYPE(function, params)	function params
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST		const
#	    define	_VOLATILE	volatile
#	    define	_SIZET		size_t
#	else
#	    define	_PROTOTYPE(function, params)	function()
#	    define	_VOIDSTAR	void *
#	    define	_VOID		void
#	    define	_CONST
#	    define	_VOLATILE
#	    define	_SIZET		int
#	endif /* _ANSI */
#    endif /* _MINIX */
#endif	/* _PROTOTYPE */

_PROTOTYPE( u_long inet_addr, (char *cp)				);
_PROTOTYPE( u_long inet_network, (char *cp)				);
_PROTOTYPE( u_long inet_makeaddr, (u_long net, u_long lna)		);
_PROTOTYPE( u_long inet_lnaof, (u_long in)				);
_PROTOTYPE( u_long inet_netof, (u_long in)				);
_PROTOTYPE( char *inet_ntoa, (u_long in)				);
_PROTOTYPE( int inet_aton, (char *cp, u_long *in)			);

#endif /* _ARPA_INET_H */
