/*
 * ether.drv	A program for TNET, which reads IEEE Ethernet encapsu-
 *		lated IP datagrams from an Ethernet driver, and sends
 *		them to TNET for further processing.
 *
 * Usage:	ether [-dv] [-m mtu] [-n buffs] [-i inpipe] \
 *		      [-o outpipe] dev_name
 *
 * Version:	2.00	07/07/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <sgtty.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <arpa/inet.h>
#include <arpa/ip.h>
#define GLOBAL
#include "ether.h"


#define VERSION	"2.00"


static char *Version = "@(#) ether.drv 2.00 (07/07/92)";


_PROTOTYPE( int tnio_init, (char *in_name, char *out_name)		);
_PROTOTYPE( void usage, (void)						);


extern int getopt(), opterr, optind;
extern char *optarg;


/* Initialize the TNET I/O channels. */
static int tnio_init(in_name, out_name, ipipe, opipe)
char *in_name, *out_name;
int *ipipe, *opipe;
{
  /* Set up the I/O channels to the TNET kernel. */
  if (strcmp(in_name, "(stdin)")) {
	*ipipe = open(in_name, O_RDONLY);
	if (*ipipe < 0) {
		fprintf(stderr, "ETHER: cannot open(%s, R): %d\n",
							in_name, errno);
		return(-errno);
	}
  } else *ipipe = 0;
  if (opt_v) fprintf(stderr, "IN  = %s (%d)\n", in_name, *ipipe);
  if (strcmp(out_name, "(stdout)")) {
	*opipe = open(out_name, O_WRONLY);
	if (*opipe < 0) {
		fprintf(stderr, "ETHER: cannot open(%s, W): %d\n",
							out_name, errno);
		return(-errno);
	}
  } else *opipe = 1;
  if (opt_v) fprintf(stderr, "OUT = %s (%d)\n", out_name, *opipe);

  return(0);
}


void usage()
{
  fprintf(stderr,
    "Usage: ether [-dv] [-m mtu] [-n buffs] [-i in_pipe]\n");
  fprintf(stderr, "            [-o out_pipe] dev_name\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char dev_name[128];
  char in_pipe[128], out_pipe[128];
  int s, fd_in, fd_out;

  /* Set program defaults. */
  ec_mtu = DEF_MTU;
  ec_bufs = DEF_BUFS;
  strcpy(in_pipe, "(stdin)");
  strcpy(out_pipe, "(stdout)");
  strcpy(dev_name,  "");
  opt_d = 0;
  opt_v = 0;

  /* Scan command line for any arguments. */
  opterr = 0;
  while ((s = getopt(argc, argv, "dm:n:i:o:v")) != EOF) switch(s) {
	case 'd':
		opt_d = 1 - opt_d;
		break;
	case 'm':
		ec_mtu = atoi(optarg);
		if (ec_mtu <= 0 || ec_mtu > 32767) usage();
		break;
	case 'n':
		ec_bufs = atoi(optarg);
		if (ec_bufs < 1 || ec_bufs > 16) usage();
		break;
	case 'i':
		strcpy(in_pipe, optarg);
		break;
	case 'o':
		strcpy(out_pipe, optarg);
		break;
	case 'v':
		opt_v = 1 - opt_v;
		break;
	default:
		usage();
  }

  /* One more argument required. */
  if (optind != --argc) usage();
  strcpy(dev_name, argv[optind]);

  /* Set up signal catchers to allow TNET to have us switch modes. */
  signal(SIGINT, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);

  fprintf(stderr, "TNET ETHER Protocol Driver version %s\n", VERSION);
  fprintf(stderr, "Written by Michael Temari and Fred N. van Kempen.\n\n");

  /* Initialize the ethernet channel. */
  if ((s = dev_init(dev_name)) != 0) return(s);

  /* Initialize the TNET I/O channels. */
  if ((s = tnio_init(in_pipe, out_pipe, &fd_in, &fd_out)) != 0) return(s);

  /*
   * Fork off a child process that handles the WRITE DGRAM
   * operations.  The parent then takes care of receiving
   * any data from the Ethernet channel.
   */
  if ((s = fork()) < 0) {
	fprintf(stderr, "ETHER: cannot fork (%s)\n", errno);
	return(-errno);
  }
  if (s == 0) out_eth(fd_in);
    else in_eth(fd_out);

  /* NOTREACHED */
  exit(0);
}
