/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		Handle the TERMINAL module.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *              Michael Temari, <temari@temari.ae.ge.com>
 *
 * 07/29/92 MT  Telnet options hack which seems to work okay
 * 01/12/93 MT  Better telnet options processing instead of hack
 */
#include <sys/types.h>
#include <errno.h>
#include <fcntl.h>
#include <sgtty.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <arpa/telnet.h>
#include "telnetd.h"
#include "telnet.h"


static int pty_in, pty_out;			/* file descriptors	*/


static int sig_int()
{
  signal(SIGINT, sig_int);
}


static got_hup = 0;

static int sig_hup()
{
  signal(SIGHUP, SIG_IGN);
  got_hup = 1;
}

void terminal(pty_in, pty_out)
int pty_in, pty_out;
{
  char buff[256];
  struct sgttyb o_tty, n_tty;
  int old_flags;
  register int i, l;

  /* Put the READ ends into non-blocking mode. */
#ifdef _MINIX
  (void) fcntl(0, F_GETFL, &old_flags);
#else
  old_flags = fcntl(0, F_GETFL, 0);
#endif
  (void) fcntl(0, F_SETFL, O_NONBLOCK);
  (void) fcntl(pty_in, F_SETFL, O_NONBLOCK);

  /* Put the NETWORK READ end into RAW mode. */
  (void) ioctl(0, TIOCGETP, &o_tty);
  (void) ioctl(0, TIOCGETP, &n_tty);
  n_tty.sg_flags |= CBREAK;
  n_tty.sg_flags &= ~(ECHO | XTABS | CRMOD);
  (void) ioctl(0, TIOCSETP, &n_tty);

  /* Flush any pending output garbage. */
  (void) ioctl(pty_out, TIOCFLUSH, (struct sgttyb *)NULL);

  signal(SIGINT, sig_int);

  signal(SIGHUP, sig_hup);

  tel_init();

  telopt(1, WILL, TELOPT_SGA);
  telopt(1, DO,   TELOPT_SGA);
  telopt(1, WILL, TELOPT_BINARY);
  telopt(1, DO,   TELOPT_BINARY);
  telopt(1, WILL, TELOPT_ECHO);

  while(!got_hup) {
	i = read(0, buff, 250);
	if (i == 0 || (i < 0 && errno != EAGAIN)) break;
	if (i > 0)
		tel_in(pty_out, 1, buff, i);

	i = read(pty_in, buff, 250);
	if (i == 0 || (i < 0 && errno != EAGAIN)) break;
	if (i > 0)
		tel_out(1, buff, i);
  }

  /* EOF.  Hang up the PTY channel and close up. */
  (void) ioctl(pty_in, TIOCFLUSH, (struct sgttyb *)NULL);
  (void) ioctl(pty_out, TIOCFLUSH, (struct sgttyb *)NULL);
  (void) ioctl(pty_out, TIOCGETP, &n_tty);
  n_tty.sg_ispeed = n_tty.sg_ospeed = B0;
  (void) ioctl(pty_out, TIOCSETP, &n_tty);

  /* Restore STDIN descriptor. */
  (void) fcntl(0, F_SETFL, old_flags);
  (void) ioctl(0, TIOCSETP, &o_tty);
}


void cooked(fd)
int fd;
{
  struct sgttyb x;

  (void) ioctl(fd, TIOCGETP, &x);
  x.sg_flags &= ~(RAW | CBREAK);
  x.sg_flags |= (ECHO | XTABS | CRMOD);
  (void) ioctl(fd, TIOCSETP, &x);
}
