/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains an implementation of the "server"
 *		for the TELNET protocol.  This protocol can be used to
 *		remote-login on other systems, just like a normal TTY
 *		session.
 *
 * Usage:	telnetd [-dv]
 *
 * Version:	@(#)telnetd.c	1.00	07/26/92
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Michael Temari, <temari@temari.ae.ge.com>
 */
#include <sys/types.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <errno.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <utmp.h>
#include <time.h>
#include <stdio.h>
#include "telnetd.h"

#define NIL	      (char *)0		/* return value from routines */

#define LOGIN_PRG	"/bin/login"


static char *Version = "@(#) telnetd 1.00 (07/26/92)";


int opt_d = 0;				/* debugging output flag	*/


extern int getopt(), optind, opterr;
extern char *optarg;

extern char ttynam[];

wtmp(user, id, line, pid, type, lineno)
char *user;			/* name of user */
char *id;			/* inittab ID */
char *line;			/* TTY name */
int pid;			/* PID of process */
int type;			/* TYPE of entry */
int *lineno;			/* slot number in UTMP */
{
/* Log an event into the WTMP and UTMP files. */

  struct utmp utmp,tmp;		/* UTMP/WTMP User Accounting */
  char *sp = "               ";	/* blank space */
  register int fd;
  long loc;

  /* Clear the fields. */
  strncpy(utmp.ut_name, sp, sizeof(utmp.ut_name));
  strncpy(utmp.ut_id, sp, sizeof(utmp.ut_id));
  strncpy(utmp.ut_line, sp, sizeof(utmp.ut_line));

  /* Strip the /dev part of the TTY name. */
  if (*line == '/') line += 5;

  /* Enter new values. */
  strncpy(utmp.ut_name, user, sizeof(utmp.ut_name));
  strncpy(utmp.ut_id, id, sizeof(utmp.ut_id));
  strncpy(utmp.ut_line, line, sizeof(utmp.ut_line));
  utmp.ut_pid = pid;
  utmp.ut_type = type;
  utmp.ut_time = time((time_t *)0);

  if ((fd = open(WTMP, O_WRONLY)) < 0) return;
  if (lseek(fd, 0L, SEEK_END) >= 0L)
		write(fd, (char *) &utmp, sizeof(struct utmp));
  close(fd);

  if (*lineno == -1)
	if ((fd = open(UTMP, O_RDONLY)) >= 0) {
		loc = 0;
		while (read(fd, (char *) &tmp,
			 sizeof(struct utmp)) == sizeof(struct utmp))
			if(strcmp(utmp.ut_line,tmp.ut_line)==0) {
				*lineno = (int) loc;
				break;
			} else
				loc++;
		close(fd);
	}

  if (*lineno >= -1) {		/* remove entry from utmp */
	if ((fd = open(UTMP, O_WRONLY)) < 0) return;
	if (*lineno == -1) {
		if ((loc=lseek(fd, 0L, SEEK_END)) >= 0L)
			write(fd, (char *) &utmp, sizeof(struct utmp));
		*lineno = (int) (loc / sizeof(struct utmp));
	} else {
		loc = *lineno * sizeof(struct utmp);
		if (lseek(fd, loc, SEEK_SET) >= 0L)
			write(fd, (char *) &utmp, sizeof(struct utmp));
	}
	close(fd);
  }
}


void usage()
{
  fprintf(stderr, "Usage: telnetdd [-dv]\n");
  exit(-1);
}


int main(argc, argv)
int argc;
char *argv[];
{
  char os_name[64], sys_name[128];
  char buff[128];
  register int c;
  int pty_in, pty_out;
  int tty_in, tty_out, pid;
  int spid, lineno;

  opterr = 0;
  while ((c = getopt(argc, argv, "dv")) != EOF) switch(c) {
	case 'd':
	case 'v':
		opt_d = 1;
		break;
	default:
		usage();
  }

  /* No more arguments allowed. */
  if (optind != argc) usage();

  /* Fetch some OS info. */
  os_info(os_name, sys_name);

  /* Try allocating a PTY. */
  if (get_pty(&pty_in, &pty_out, &tty_in, &tty_out) < 0) {
	sprintf(buff, "I am sorry, but there is no free PTY left!\r\n");
	(void) write(1, buff, strlen(buff));
	return(-1);
  }

  /* Tell the caller who we are. */
  sprintf(buff, "\r\n\r\n%s (%s)\r\n\r\n", sys_name, ttynam+5);
  (void) write(1, buff, strlen(buff));

  /* Fork off a child process and have it execute login(1). */
  if ((pid = fork()) == 0) {
	(void) close(0); (void) dup(tty_in);	/* this order so we can */
	(void) close(1); (void) close(2);	/* keep our controlling */
	(void) dup(tty_out); (void) dup(tty_out); /* terminal */
	cooked(0);

	(void) execl(LOGIN_PRG, LOGIN_PRG, (char *)NULL);
	(void) write(1, "EXEC failed!\r\n", 14);
  } else if (pid < 0) {
	sprintf(buff, "I am sorry, but the fork(2) call failed!\r\n");
	(void) write(1, buff, strlen(buff));
	(void) close(tty_in); (void) close(tty_out);
	(void) close(pty_in); (void) close(pty_out);
	return(-1);
  }

  /* Fork again so we can wait for the shell to exit and tell telnetd child. */
  if ((spid = fork()) > 0) {
	while(wait(NULL) != pid) ;
	kill(spid, SIGHUP);
	exit(0);
  } else if (spid < 0) {
	sprintf(buff, "I am sorry, but the fork(2) call failed!\r\n");
	(void) write(1, buff, strlen(buff));
	(void) close(tty_in); (void) close(tty_out);
	(void) close(pty_in); (void) close(pty_out);
	return(-1);
  }

  (void) close(tty_in); (void) close(tty_out);

  lineno = -1;
  wtmp("", &ttynam[strlen(ttynam)-4], ttynam, pid, LOGIN_PROCESS, &lineno);

  terminal(pty_in, pty_out);

  (void) close(pty_in); (void) close(pty_out);

  /* Shoot any left-over shell or login process. */
  (void) kill(pid, SIGKILL);

  /* We should do some UTMP/WATP accounting here, I think. */
  wtmp("", &ttynam[strlen(ttynam)-4], ttynam, pid, DEAD_PROCESS, &lineno);

  return(0);
}
