/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		TNET ARP cache management.
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "netcom.h"


int do_arp(argc, argv)
int argc;
char **argv;
{
  char buff[128];
  RMTHDR hdr;
  int st, netin;

  /* Tell TNET to dump the list of interfaces. */
  hdr.c_opcode = RMT_ARP;
  hdr.c_length = 0;
  hdr.c_i1 = ARP_DUMP;

  st = tn_rlink(&hdr, (char *)NULL, 0, 10, &netin);
  if (st < 0) {
	printf("arp dump: error code %d\n\n", st);
	return;
  }
  if (hdr.c_opcode == 0) {
	while(1) {
		st = read(netin, buff, 128);
		if (st > 0) (void) write(1, buff, st);
		  else break;
	}
  } else printf("Error code: %d\n\n", hdr.c_opcode);
  (void) close(netin);
  return(0);
}
