/* ftp.c by Michael Temari 06/21/92 */
/*
 * ftp		An ftp client program for use with TNET.
 *
 * Usage:	ftp [host] [port]
 *
 * Version:	0.10	06/21/92 (pre-release not yet completed)
 * 		0.20	07/01/92
 *
 * Author:	Michael Temari, <temari@temari.ae.ge.com>
 */

#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <arpa/ftp.h>
#include <inet/in.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <netdb.h>
#include <fcntl.h>
#include <sgtty.h>
#include <ctype.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <stdio.h>

#define RETR	0
#define	STOR	1

static char comline[1024];
static char line[1024];
static char line2[1024];

static char host[128];
static u_long hostip;
static u_long myip;
#define	NUMARGS	10
static int cmdargc;
static char *cmdargv[NUMARGS];

static int netin, netout;
static int datain, dataout;
static FILE *fpnetin, *fpnetout;
static int linkopen, loggedin;
static int type, format, mode, structure;
static u_long data_addr;
static u_short data_port;

static int init()
{
   linkopen = 0;
   loggedin = 0;
   type = TYPE_A;
   format = FORM_N;
   mode = MODE_S;
   structure = STRU_F;
}

char *dir(path, full)
char *path;
int full;
{
char cmd[128];
static char name[32];
extern char *tmpnam();

   tmpnam(name);
   if(full)
	sprintf(cmd, "ls -lg %s > %s", path, name);
   else
	sprintf(cmd, "ls %s > %s", path, name);
   system(cmd);
   return(name);
}

static char buffer[4096];

static int asciisend(fd, fdout)
int fd;
int fdout;
{
int s, len;
char *p, *pp;
long total=0L;

   printf("Sent ");
   while((s = read(fd, buffer, sizeof(buffer))) > 0) {
	buffer[s] = '\0';
	total += (long)s;
	p = buffer;
	while(s > 0) {
		if((pp = strchr(p, '\n')) == (char *)NULL) {
			write(fdout, p, s);
			break;
		}
		len = pp - p;
		write(fdout, p, len);
		write(fdout, "\r\n", 2);
		p = pp + 1;
		s = s - len - 1;
	}
	printf("%8ld bytes\b\b\b\b\b\b\b\b\b\b\b\b\b\b", total);
   }
   printf("\n");
   return(s);
}

static int binarysend(fd, fdout)
int fd;
int fdout;
{
int s;
long total=0L;

   printf("Sent ");
   while((s = read(fd, buffer, sizeof(buffer))) > 0) {
	write(fdout, buffer, s);
	total += (long)s;
	printf("%8ld bytes\b\b\b\b\b\b\b\b\b\b\b\b\b\b", total);
   }
   printf("\n");
   return(s);
}

static int sendfile(fd, fdout)
int fd;
int fdout;
{
int s;

   switch(type) {
	case TYPE_A:
		s = asciisend(fd, fdout);
		break;
	default:
		s = binarysend(fd, fdout);
   }

   if(fd > 2)
	close(fd);
   if(s < 0)
	return(-1);
   else
	return(0);
}

static int asciirecv(fd, fdin)
int fd;
int fdin;
{
int s, len;
char *p, *pp;
long total=0L;

   if(fd > 2)
	printf("Received ");
   while((s = read(fdin, buffer, sizeof(buffer))) > 0) {
	p = buffer;
	total += (long)s;
	buffer[s] = '\0';
	while(s > 0) {
		if((pp = strchr(p, '\r')) == (char *)NULL) {
			write(fd, p, s);
			break;
		}
		len = pp - p;
		write(fd, p, len);
		p = pp + 1;
		s = s - len - 1;
	}
	if(fd > 2)
		printf("%8ld bytes\b\b\b\b\b\b\b\b\b\b\b\b\b\b", total);
   }
   if(fd > 2)
	printf("\n");
   return(s);
}

static binaryrecv(fd, fdin)
int fd;
int fdin;
{
int s;
long total=0L;

   if(fd > 2)
	printf("Received ");
   while((s = read(fdin, buffer, sizeof(buffer))) > 0) {
	write(fd, buffer, s);
	total += (long)s;
	if(fd > 2)
		printf("%8ld bytes\b\b\b\b\b\b\b\b\b\b\b\b\b\b", total);
   }
   if(fd > 2)
	printf("\n");
   return(s);
}

int recvfile(fd, fdin)
int fd;
int fdin;
{
int s;

   switch(type) {
	case TYPE_A:
		s = asciirecv(fd, fdin);
		break;
	default:
		s = binaryrecv(fd, fdin);
   }

   if(fd > 2)
	close(fd);
   if(s < 0)
	return(-1);
   else
	return(0);
}

static int DOgetreply()
{
char *p;
char buff[6];
int s;
int firsttime;

   do {
	firsttime = 1;
	do {
		if(fgets(line, sizeof(line), fpnetin) == (char *)0)
			return(-1);
		p = line + strlen(line) - 1;
		while(p != line)
			if(*p == '\r' || *p == '\n' || isspace(*p))
				*p-- = '\0';
			else
				break;
		printf("%s\n", line); fflush(stdout);
		if(firsttime) {
			firsttime = 0;
			strncpy(buff, line, 4);
			buff[3] = ' ';
		}
	   } while(strncmp(line, buff, 4));
	   s = atoi(buff);
   } while(s<200 && s != 125 & s != 150);

   return(s);
}

static int DOcmdcheck()
{
   if(!linkopen) {
	printf("You must \"OPEN\" a connection first.\n");
	return(1);
   }
   if(!loggedin) {
	printf("You must login first.\n");
	return(1);
   }
   return(0);
}

static int DOcommand(ftpcommand)
char *ftpcommand;
{
   fprintf(fpnetout, "%s\r\n", ftpcommand);  fflush(fpnetout);
   return(DOgetreply());
}

static int DOopen()
{
u_short port;
int s;
struct hostent *hp;

   if(linkopen) {
	printf("Use \"CLOSE\" to close the connection first.\n");
	return(0);
   }
   strncpy(host, cmdargv[1], 128);
   port = (u_short)21;
   if(cmdargc < 2) {
	readline("Host: ", line2);
	strncpy(host, line2, 128);
   }
   if(cmdargc > 2) {
	port = (u_short)atoi(cmdargv[2]);
	if(port == (u_short)0)
		port = (u_short)21;
   }

  hp = gethostbyname(host);
  if (hp == (struct hostent *)NULL) {
	hostip = (u_long)0;
	printf("Unresolved host %s\n", host);
	return(0);
  } else
	memcpy((char *) &hostip, (char *) hp->h_addr, hp->h_length);
   s = client(TCP_PTCL, (u_short)0, port, hostip, &netin, &netout);
   if(s != 0) {
	printf("Error %d connecting to host.\n", s);
	return(0);
   }
   fpnetin  = fdopen(netin,  "r");
   fpnetout = fdopen(netout, "w");
   s = DOgetreply();
   if(s < 0) {
	close(netin);
	close(netout);
	return(s);
   }
   if(s != 220) {
	close(netin);
	close(netout);
	return(0);
   }
   linkopen = 1;
   return(s);
}

static int DOpass()
{
int s;
struct sgttyb oldtty, newtty;
char *pass;

   pass = cmdargv[1];
   if(cmdargc < 2) {
	ioctl(fileno(stdout), TIOCGETP, &newtty);
	oldtty = newtty;
	newtty.sg_flags &= ~ECHO;
	ioctl(fileno(stdout), TIOCSETP, &newtty);
	readline("Password: ", line2);
	ioctl(fileno(stdout), TIOCSETP, &oldtty);
	printf("\n");
	pass = line2;
   }
   sprintf(comline, "PASS %s", pass);
   s = DOcommand(comline);
   return(s);
}

static int DOuser()
{
char *user;
int s;

   if(!linkopen) {
	printf("You must \"OPEN\" a connection first.\n");
	return(0);
   }
   loggedin = 0;
   user = cmdargv[1];
   if(cmdargc < 2) {
	readline("Username: ", line2);
	user = line2;
   }
   sprintf(comline, "USER %s", user);
   s = DOcommand(comline);
   if(s == 331) {
	sprintf(line, "password");
	makeargs();
	s = DOpass();
   }
   if(s == 230)
	loggedin = 1;
   return(s);
}

static int DOascii()
{
int s;

   if(DOcmdcheck())
	return(0);
   sprintf(comline, "TYPE A");
   s = DOcommand(comline);
   type = TYPE_A;
   return(s);
}

static int DObinary()
{
int s;

   if(DOcmdcheck())
	return(0);
   sprintf(comline, "TYPE I");
   s = DOcommand(comline);
   type = TYPE_I;
   return(s);
}

static int DOclose()
{
   if(!linkopen) {
	printf("You can't close a connection that isn't open.\n");
	return(0);
   }
   fclose(fpnetin); fclose(fpnetout);
   close(netin); close(netout);
   linkopen = 0;
   loggedin = 0;

   return(0);
}

static int DOquit()
{
int s;

   if(linkopen) {
	sprintf(comline, "quit");
	s = DOcommand(comline);
	linkopen = 0;
	fclose(fpnetin);
	fclose(fpnetout);
	close(netin);
	close(netout);
   }
   printf("FTP done.\n");
   exit(0);
}

static int DOpwd()
{
int s;

   if(DOcmdcheck())
	return(0);
   s = DOcommand("PWD");
   if(s == 500 || s == 502)
	s = DOcommand("XPWD");
   return(s);
}

static int DOcd()
{
char *path;
int s;

   if(DOcmdcheck())
	return(0);
   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Path: ", line2);
	path = line2;
   }
   if(!strcmp(path, ".."))
	sprintf(comline, "CDUP");
   else
	sprintf(comline, "CWD %s", path);
   s = DOcommand(comline);
   if(s == 500 || s == 502) {
	if(!strcmp(path, ".."))
		sprintf(comline, "XCUP");
	else
		sprintf(comline, "XCWD %s", path);
	s = DOcommand(comline);
   }
   return(s);
}

static int DOlpwd()
{
   if(getcwd(line2, sizeof(line2)) == (char *)0)
	printf("Could not determine local directory.\n");
   else
	printf("Current local directory: %s\n", line2);

   return(0);
}

static int DOlcd()
{
char *path;
int s;

   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Path: ", line2);
	path = line2;
   }
   if(chdir(path))
	printf("Could not change local directory.\n");
   else
	DOlpwd();
   
   return(0);
}

static int DOmkdir()
{
char *path;
int s;

   if(DOcmdcheck())
	return(0);
   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Directory: ", line2);
	path = line2;
   }
   sprintf(comline, "MKD %s", path);
   s = DOcommand(comline);
   if(s == 500 || s == 502) {
	sprintf(comline, "XMKD %s", path);
	s = DOcommand(comline);
   }
   return(s);
}

static int DOrmdir()
{
char *path;
int s;

   if(DOcmdcheck())
	return(0);
   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Directory: ", line2);
	path = line2;
   }
   sprintf(comline, "RMD %s", path);
   s = DOcommand(comline);
   if(s == 500 || s == 502) {
	sprintf(comline, "XRMD %s", path);
	s = DOcommand(comline);
   }
   return(s);
}

static int DOlmkdir()
{
char *path;
int s;

   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Directory: ", line2);
	path = line2;
   }
   if(mkdir(path, 0777))
	printf("Could not make directory %s.\n", path);
   else
	printf("Directory created.\n");
   
   return(0);
}

static int DOlrmdir()
{
char *path;
int s;

   path = cmdargv[1];
   if(cmdargc < 2) {
	readline("Directory: ", line2);
	path = line2;
   }
   if(rmdir(path))
	printf("Could not remove directory %s.\n", path);
   else
	printf("Directory removed.\n");
   
   return(0);
}

static int DOdelete()
{
char *file;

   if(DOcmdcheck())
	return(0);
   file = cmdargv[1];
   if(cmdargc < 2) {
	readline("File: ", line2);
	file = line2;
   }
   sprintf(comline, "DELE %s", file);
   return(DOcommand(comline));
}

static int DOnoop()
{
   return(DOcommand("NOOP"));
}

static int DOremotehelp()
{
   return(DOcommand("HELP"));
}

static int DOdata(datacom, direction, fd)
char *datacom;
int direction;	/* RETR or STOR */
int fd;
{
u_long raddr;
u_short lport, port;
int s;

   lport = 0;
   port = 20;
   raddr = hostip;
   s = tconnect(TCP_PTCL, &lport, &port, &raddr, 0L, &datain, &dataout);
   if(s < 0)
	return(s);
#define	hiword(x)	((u_short)((x) >> 16))
#define	loword(x)	((u_short)(x & 0xffff))	
#define	hibyte(x)	(((x) >> 8) & 0xff)
#define	lobyte(x)	((x) & 0xff)
   sprintf(comline, "PORT %u,%u,%u,%u,%u,%u",
		hibyte(hiword(myip)), lobyte(hiword(myip)),
		hibyte(loword(myip)), lobyte(loword(myip)),
		hibyte(lport), lobyte(lport));
   s = DOcommand(comline);
   if(s != 200) {
	close(datain);
	close(dataout);
	return(s);
   }
   s = DOcommand(datacom);
   if(s == 125 || s == 150) {
	switch(direction) {
		case RETR:
			s = recvfile(fd, datain);
			break;
		case STOR:
			s = sendfile(fd, dataout);
			break;
	}
	close(datain);
	close(dataout);
	s = DOgetreply();
   } else {
	close(datain);
	close(dataout);
   }
   return(s);
}

static int DOlist()
{
char *path;
char *local;
int fd;
char datacom[128];

   if(DOcmdcheck())
	return(0);
   path = cmdargv[1];
   if(cmdargc < 2)
	path = "";
   if(cmdargc < 3)
	local = "";
   else
	local = cmdargv[2];
   if(*path == '\0')
	sprintf(datacom, "LIST");
   else
	sprintf(datacom, "LIST %s", path);
   if(*local == '\0')
	fd = 1;
   else
	fd = open(local, O_WRONLY | O_CREAT | O_TRUNC, 0666);
   return(DOdata(datacom, RETR, fd));
}

static int DOnlst()
{
char *path;
char *local;
int fd;
char datacom[128];

   if(DOcmdcheck())
	return(0);
   path = cmdargv[1];
   if(cmdargc < 2)
	path = "";
   if(cmdargc < 3)
	local = "";
   else
	local = cmdargv[2];
   if(*path == '\0')
	sprintf(datacom, "NLST");
   else
	sprintf(datacom, "NLST %s", path);
   if(*local == '\0')
	fd = 1;
   else
	fd = open(local, O_WRONLY | O_CREAT | O_TRUNC, 0666);
   return(DOdata(datacom, RETR, fd));
}

static int DOretr()
{
char *file, *localfile;
int fd;
char datacom[128];

   if(DOcmdcheck())
	return(0);
   file = cmdargv[1];
   if(cmdargc < 2) {
	readline("Remote File: ", line2);
	file = line2;
   }
   if(cmdargc < 3)
	localfile = file;
   else
	localfile = cmdargv[2];

   fd = open(localfile, O_WRONLY | O_CREAT | O_TRUNC, 0666);
   sprintf(datacom, "RETR %s", file);
   return(DOdata(datacom, RETR, fd));
}

static int DOMretr()
{
char *files;
char datacom[128];
int fd, s;
FILE *fp;
extern char *tmpnam();
char name[32];

   if(DOcmdcheck())
	return(0);
   files = cmdargv[1];
   if(cmdargc < 2) {
	readline("Files: ", line2);
	files = line2;
   }
   tmpnam(name);
   fd = open(name, O_WRONLY | O_CREAT | O_TRUNC, 0666);
   sprintf(datacom, "NLST %s", files);
   s = DOdata(datacom, RETR, fd);
   if(s == 226) {
	fp = fopen(name, "r");
	unlink(name);
	while(fgets(line2, sizeof(line2), fp) != (char *)NULL) {
		line2[strlen(line2)-1] = '\0';
		printf("Retrieving file: %s\n", line2); fflush(stdout);
		fd = open(line2, O_WRONLY | O_CREAT | O_TRUNC, 0666);
		sprintf(datacom, "RETR %s", line2);
		s = DOdata(datacom, RETR, fd);
		/* FIX */
	}
   }
   return(s);
}

static int DOstor()
{
char *file, *remotefile;
int fd;
char datacom[128];

   if(DOcmdcheck())
	return(0);
   file = cmdargv[1];
   if(cmdargc < 2) {
	readline("Local File: ", line2);
	file = line2;
   }
   if(cmdargc < 3)
	remotefile = file;
   else
	remotefile = cmdargv[2];

   fd = open(file, O_RDONLY);
   sprintf(datacom, "STOR %s", remotefile);
   return(DOdata(datacom, STOR, fd));
}

static int DOMstor()
{
char *files;
char *name;
char datacom[128];
int fd, s;
FILE *fp;

   if(DOcmdcheck())
	return(0);
   files = cmdargv[1];
   if(cmdargc < 2) {
	readline("Files: ", line2);
	files = line2;
   }
   name = dir(files, 0);
   fp = fopen(name, "r");
   while(fgets(line2, sizeof(line2), fp) != (char *)NULL) {
	line2[strlen(line2)-1] = '\0';
	printf("Sending file: %s\n", line2); fflush(stdout);
	fd = open(line2, O_RDONLY);
	sprintf(datacom, "STOR %s", line2);
	s = DOdata(datacom, STOR, fd);
	/* FIX */
   }
   unlink(name);
   return(s);
}

static int DOquote()
{
int i;

   comline[0] = '\0';
   for(i = 1; i < cmdargc; i++) {
	if(i != 1)
		strcat(comline, " ");
	strcat(comline, cmdargv[i]);
   }
   return(DOcommand(comline));
}

static int DOhelp()
{
   printf("Command:      Description\n");
   printf("ascii         Set file transfer mode to ascii\n");
   printf("binary        Set file transfer mode to binary\n");
   printf("bye           Close connection and exit\n");
   printf("cd            Change directory on remote host\n");
   printf("close         Close connection\n");
   printf("dir           Display long form remote host directory listing\n");
   printf("exit          Close connection and exit\n");
   printf("del           Remove file on remote host\n");
   printf("get           Retrieve a file from remote host\n");
   printf("help          Display this text\n");
   printf("open          Open connection to remote host\n");
   printf("pwd           Display current directory on remote host\n");
   printf("mkdir         Create directory on remote host\n");
   printf("rmdir         Remove directory on remote host\n");
   printf("lcd           Change directory on local host\n");
   printf("lmkdir        Create directory on local host\n");
   printf("lpwd          Display current directory on local host\n");
   printf("lrmdir        Remove directory on local host\n");
   printf("ls            Display remote host directory listing\n");
   printf("mget          Retrieve multiple files from remote host\n");
   printf("mput          Send multiple files to remote host\n");
   printf("noop          Send the ftp NOOP command\n");
   printf("put           Send a file to remote host\n");
   printf("quit          Close connection and exit\n");
   printf("quote         Send raw ftp command to remote host\n");
   printf("remotehelp    Display ftp command implemented on remote host\n");
   printf("rm            Remove file on remote host\n");
   printf("user          Enter remote user information\n");
   return(0);
}

struct commands {
	char *name;
	int (*func)();
};

static struct commands commands[] = {
	"open", 	DOopen,
	"user",		DOuser,
	"ascii",	DOascii,
	"binary",	DObinary,
	"close",	DOclose,
	"quit",		DOquit,
	"bye",		DOquit,
	"pwd",		DOpwd,
	"cd",		DOcd,
	"lpwd",		DOlpwd,
	"lcd",		DOlcd,
	"mkdir",	DOmkdir,
	"rmdir",	DOrmdir,
	"lmkdir",	DOlmkdir,
	"lrmdir",	DOlrmdir,
	"rm",		DOdelete,
	"del",		DOdelete,
	"noop",		DOnoop,
	"remotehelp",	DOremotehelp,
	"dir",		DOlist,
	"ls",		DOnlst,
	"get",		DOretr,
	"mget",		DOMretr,
	"put",		DOstor,
	"mput",		DOMstor,
	"quote",	DOquote,
	"help",		DOhelp,
	"exit",		DOquit,
	"",	(int (*)())0
};

int makeargs()
{
char *p;
int i;

   for(i = 0; i < NUMARGS; i++)
	cmdargv[i] = (char *)0;

   p = line + strlen(line) - 1;
   while(p != line)
	if(*p == '\r' || *p == '\n' || isspace(*p))
		*p-- = '\0';
	else
		break;

   p = line;
   cmdargc = 0;
   while(cmdargc < NUMARGS) {
	while(*p && isspace(*p))
		p++;
	if(*p == '\0')
		break;
	cmdargv[cmdargc++] = p;
	while(*p && !isspace(*p)) {
		if(cmdargc == 1)
			*p = tolower(*p);
		p++;
	}
	if(*p == '\0')
		break;
	*p = '\0';
	p++;
   }
}

static int readline(prompt, buff)
char *prompt;
char *buff;
{
   printf(prompt); fflush(stdout);
   if(gets(buff) == (char *)NULL) {
	printf("\nEnd of file on input!\n");
	exit(1);
   }
   return(0);
}

int main(argc, argv)
int argc;
char *argv[];
{
int status;
struct commands *cmd;

   myip = ntohl(gethostid());
   init();
   if(argc > 1) {
	sprintf(line, "open %s ", argv[1]);
	if(argc > 2)
		strcat(line, argv[2]);
	makeargs();
	status = DOopen();
	if(status > 0) {
		sprintf(line, "user");
		makeargs();
		status = DOuser();
	}
   }

   while(1) {
	readline("ftp>", line);
	makeargs();
	for(cmd = commands; *cmd->name != '\0'; cmd++)
		if(!strcmp(cmdargv[0], cmd->name))
			break;
	if(*cmd->name != '\0')
		status = (*cmd->func)();
	else {
		status = 0;
		if(cmdargc > 0)
			printf("Command \"%s\" not recongnized.\n", cmdargv[0]);
	}
   }
}
