/*
 * TNET		A server program for MINIX which implements the TCP/IP
 *		suite of networking protocols.  It is based on the
 *		TCP/IP code written by Phil Karn et al, as found in
 *		his NET package for Packet Radio communications.
 *
 *		This file contains a server for the DAYTIME protocol.
 *
 * Usage:	daytimed [-dv]
 *
 * Version:	@(#)daytimed.c	1.00	07/02/92
 *
 * Authors:	Michael Temari, <temari@temari.ae.ge.com>
 *		Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 */
#include <sys/types.h>
#include <arpa/internet.h>
#include <arpa/inet.h>
#include <inet/in.h>
#include <inet/socket.h>
#include <tnet/tnet.h>
#include <tnet/client.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <stdio.h>


static char *Version = "@(#) daytimed 1.00 (07/02/92)";


int opt_d = 0;				/* debugging output flag	*/
static char *days[] = {
  "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};
static char *months[] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};


extern int getopt(), optind, opterr;
extern char *optarg;
extern char *tzname[2];


int main(argc, argv)
int argc;
char *argv[];
{
  time_t t; 
  struct tm *tm;

  (void) time(&t);

  if (argc != 1)	/* any arguments get old style */
	/* old stype */
	printf("%24.24s\r\n", ctime(&t));
   else {
	/* smtp style */
	tm = localtime(&t);
	printf("%s, %d %s %d %02d:%02d:%02d %s\r\n", days[tm->tm_wday],
		tm->tm_mday, months[tm->tm_mon], tm->tm_year,
		tm->tm_hour, tm->tm_min, tm->tm_sec,
		tzname[tm->tm_isdst]);
   }
   return(0);
}
