#
# Install shell script for minicom and friends.
#

if test $# != 3
then
	echo "Usage: install.sh libdir bindir mandir"
	exit 1
fi

if test ! -d $1
then
	echo "$1: No such directory"
	exit 1
fi

if test ! -d $2
then
	echo "$2: No such directory"
	exit 1
fi

if test ! -d $3
then
	echo "$3: No such directory"
	exit 1
fi

if test -f minicom
then
	echo "Installing minicom in $2"
	cp minicom $2/minicom
	chmod 4511 $2/minicom
	chown root $2/minicom
	chgrp bin $2/minicom
fi

for i in runscript xminicom
do
  if test -f $i
  then
	echo "Installing $i in $2"
	cp $i $2/$i
	chmod 555 $2/$i
	chown bin $2/$i
	chgrp bin $2/$i
  fi
done

if test -f keyserv
then
	echo "Installing keyserv in $1"
	cp keyserv $1/keyserv
	chmod 555 $1/keyserv
	chown bin $1/keyserv
	chgrp bin $1/keyserv
fi

for i in saralogin unixlogin scriptdemo
do
	echo "Installing script demo $i in $1"
	cp ../demos/$i $1/$i
	chmod 644 $1/$i
	chown bin $1/$i
	chgrp bin $1/$i
done

echo "Installing manpages in $3"
for i in minicom.1 runscript.1
do
	cp ../man/$i $3
	chmod 644 $3/$i
	chown bin $3/$i
	chgrp bin $3/$i
done

exit 0
