#include "etherframe.h"
#include "etherproto.h"
#include "8390.h"
#include "wd8003.h"
#include "3c503.h"
#include "ne1000.h"

/* I/O macros */
#define input(port)		in_byte(ETHER_PORT+port)
#define output(port, value)	out_byte(ETHER_PORT+port, value)

/* a few useful Ethernet definitions */
#define RUNT		60	/* smallest legal size packet, no fcs */
#define GIANT		1514	/* largest legal size packet, no fcs */
#define EADDR_LEN	6	/* Ethernet address length */

/* packet classes */
#define BLUEBOOK	1
#define IEEE8023	11

/* calling process state (i.e. read request status) */
#define IN_NONE		0	/* no read request */
#define IN_WAITING	1	/* waiting to finish frame copying */
#define IN_HANGING	2	/* hanging up to frame arrival */

/* packet processing responses (see recv_find) */
#define LEAVE_PKT	((phys_bytes)  0)	/* leave pkt in s.m. */
#define DISCARD_PKT	((phys_bytes) -1)	/* discard it from s.m. */

/* GLOBAL VARIABLES */
extern Eth_addr curr_hw_addr;
extern unsigned sm_rstop_ptr;
extern unsigned endcfg;

/* FUNCTION PROTOTYPES */

/* ether.c */
phys_bytes recv_find();
void recv_copy();

/* wd8003.c, 3c503.c, ne1000.c */
void ram_enable();
void reset_8390();
int block_output();
void block_input();
void init_card();

/* 8390.c */
int recv_pkt();
int send_pkt();
void set_8390_eaddr();
void reset_board();
void recv();
void etopen();
