/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  xmd.c						   */
/*        FUNKTIONEN  brief(), mailing(), main()			   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  07.12.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"


char tmp[STRING];
int INTERACT;



/***************************************************************************/
/*      FUNKTION  brief()						   */
/*  BESCHREIBUNG  Leitet einen Brief weiter an einen MBox-Account.	   */
/*		  Auf diese Weise ist der Mbox-User auch unter der         */
/*		  Adresse 'Real.Name@UUCPID' erreichbar.		   */
/*     PARAMETER  arg  =  Mbox-User-Name                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

brief(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  int fd;
  int i;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;

  int receiver;
  static int mail_id;
  int EX_PM = 0;
  int REPLY = 0;
  int lines = 0;
  int local = 0;


  char s[STRING];
  char t[STRING];
  char top[STRING];
  char subject[STRING];
  char autor[STRING];
  char rec_char[STRING];
  char ex[255];
  char user[STRING];
  char c;
  char protokoll;
  char destination[STRING];

  i = 0;
  ok = 0;

  strcpy(user, (char *) stripped(arg));
  strcpy(subject, XMD01_MSG);

  JUNK:	receiver = 0;

  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	printf("\nSHIT!\n");
	exit(-1);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)) {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);

  if (receiver == 0) {
	sprintf(subject, "[xmd:] '%s' ???   ", user);
	strcpy(user, POSTMASTER);
	goto JUNK;
  }
  sprintf(s, "%s/usr/%d/seq", HOME, receiver);
  fp = fopen(s, "r");
  fgets(s, 80, fp);
  mail_id = atoi( s );
  fclose(fp);

  sprintf(destination, "%s/usr/%d/%d", HOME, receiver, mail_id);
  fp = fopen(destination, "w");

  sprintf(s, "%s %s (%s)\n", GBL01_MSG, X_MAIL_DEMON, "xmd");
  fputs(s, fp);

  time(&timer);
  timeptr = localtime(&timer);
  strcpy(t, (char *) asctime(timeptr));

  sprintf(s, "%s %s", GBL02_MSG, t);
  fputs(s, fp);

  sprintf(s, "%s %s\n\n", GBL03_MSG, subject);
  fputs(s, fp);

  fprintf(fp, "%s\n\n", XMD02_MSG);

  lines = 7;

  ff = fopen(tmp, "r");
  if (ff == NULL) {
	return;
  }
  while (fgets(s, 80, ff) != NULL) {
	fputs(s, fp);
	lines++;
	if(strcomp("Subject: ", s) == 0){
		strcpy(subject, (char *) stripped(strcopy(s, 9, 80)));
	}
	if(strcomp("From: ", s) == 0){
		strcpy(autor, (char *) stripped(strcopy(s, 6, 80)));
		local = 0;
	}
	if(strcomp("From ", s) == 0){
		strcpy(autor, (char *) stripped(strcopy(s, 5, 80)));
		local = 1;
	}
  }
  fclose(ff);
  fclose(fp);

  i = 0; 
  while(autor[i] != '\0'){
	if(autor[i] == '(') autor[(i-1)] = '\0';
	i++;
  }

  if((local == 1) && (strcomp("postmaster", autor) == 0)){
	fclose(fp);
	unlink(destination);
	if(INTERACT == 0) printf("[%s]\n", arg);
	fp = fopen( XMDLOG, "a" );
	fprintf(fp, "-%-30.30s%s\n", (char *) stripped(arg), subject);
	fclose(fp);
	return;
  }

  sprintf(s, "%s/usr/%d/INDEX", HOME, receiver);
  fp = fopen(s, "a");

  sprintf(s, "%d              ", mail_id);
  s[6] = '\0';
  fputs(s, fp);

  sprintf(ex, "%s                                  ", subject);
  ex[26] = '\0';
  fputs(ex, fp);

  sprintf(ex, "  %s                                        ", autor);
  ex[22] = '\0';
  fputs(ex, fp);


  strcpy(s, (char *) mydate(1));
  strcpy(t, (char *) mytime(1));
  sprintf(ex, "  %s  %s         ", s, t);
  ex[19] = '\0';
  fputs(ex, fp);

  sprintf(s, "%-5.d\n", lines);
  fputs(s, fp);

  fclose(fp);

  sprintf(s, "%s/usr/%d/seq", HOME, receiver);
  fp = fopen(s, "w");
  rewind(fp);
  fprintf(fp, "%d\n", (int) (mail_id + 1));
  fclose(fp);

  if(INTERACT == 0) printf("%s\n", arg);

  ff = fopen( XMDLOG, "a" );
  fprintf(ff, " %-30.30s%s\n", (char *) stripped(arg), subject);
  fclose(ff);
}





/***************************************************************************/
/*      FUNKTION  mailing()						   */
/*  BESCHREIBUNG  Isoliert den Mbox-User-Namen aus der UUCP-Adresse und	   */
/*                ruft mit diesem Namen die Routine "brief()" auf.	   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

mailing()
{
  FILE *fp;
  char s[255];
  char t[STRING];
  int i, j;

  fp = fopen(tmp, "r");
  if (fp == NULL) {
	printf("\nPuhhh???\n");
	exit(-1);
  }
  while (fgets(s, 80, fp) != NULL) {
	if (strcomp("To:", s) == 0) {
		i = 0;
		j = 0;
		while ((s[i] != '\0') && (s[i] != '@')) {
			if (s[i] == '!') j = i;
			if ((s[i] == '.') || (s[i] == '%')) s[i] = ' ';
			i++;
		}
		i--;
		if (j == 0) {
			strcpy(t, (char *) strcopy(s, 4, i));
		} else {
			strcpy(t, (char *) strcopy(s, (j + 1), length(s)));
		}
		brief(t);
	}
  }

  fclose(fp);

  unlink(tmp);

}




/***************************************************************************/
/*      FUNKTION  main() (xmd)						   */
/*  BESCHREIBUNG  Der Briefkasten des ERRORUSERS (POSTMASTER) wird ge-	   */
/*		  scannt. Alle Eintraege fuer Mbox-User, deren Adresse     */
/*		  im Format 'Real.Name@UUCPID' vorliegen, werden zuge-	   */
/*		  stellt.                                                  */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

main(argc, argv)
int argc;
char *argv[];
{
  FILE *fp;
  FILE *ff;
  char s[255];
  char t[255];
  char dump[STRING];
  char maildrop[STRING];
  int toggle = 0;
  int l;
  int c;

  setuid(0);
  setgid(0);
  umask(0000);

  chdir(HOME);
  if(INTERACT == 0) printf("\n");

  ff = fopen( XMDLOG, "a" );
  fprintf(ff, "\n\n========================== %s - %s ==============================\n\n", (char *) mydate( 1 ), (char *) mytime( 0 ));
  fclose(ff);

  if(argc < 2){
	fp = fopen(ERRMBOX, "r");
	INTERACT = 0;
  }
  else{
	if(argv[2][0] == '-'){
		sprintf(maildrop, "%s/%dPIP", TMP, getpid());
		fp = fopen(maildrop, "w");
		c = 0;
		do{
			c = fgetc(stdin);
			if((c != EOF) && (c != 4)){
				fputc(c, fp);
				printf("%c", c);
			}
		}while((c != EOF) && (c != 4));
		fclose(fp);
		fp = fopen(maildrop, "r");
		INTERACT = 1;	
	}
	else{
		sprintf(maildrop, "%s/%s", MAILDROP, argv[1]);
		fp = fopen(maildrop, "r");
		INTERACT = 1;
	}
  }
  if (fp == NULL) {
	if(INTERACT == 0) printf("\nNo mail.\n");
	return;
  }

  sprintf(dump, "%s/%d.DUMP", TMP, getpid());
  ff = fopen(dump, "w");

  while (fgets(s, 80, fp) != NULL) {
	l = 2;
	if (s[0] == '>') {
		if(s[1] != ' ') l = 1;
		strcpy(t, (char *) strcopy(s, l, length(s)));
		strcpy(s, t);
		if (strcomp("OOPS", s) != 0) {
			fputs(s, ff);
		}
	}
	else{
		fputs(s, ff);
	}
  }
  fclose(ff);
  fclose(fp);

  fp = fopen(dump, "r");

  sprintf(tmp, "%s/%d.XMD", TMP, getpid());

  ff = fopen(tmp, "w");

  while (fgets(s, 80, fp) != NULL) {
	if (strcomp("From ", s) == 0) {
		if (toggle == 1) {
			if (ff != 0) fclose(ff);
			mailing();
			ff = fopen(tmp, "w");
		}
		toggle = 1;
	}
	if (toggle == 1) fputs(s, ff);
  }
  if (ff != 0) fclose(ff);
  if (toggle == 1) mailing();
  fclose(fp);

  unlink(tmp);
  unlink(dump);

  if(INTERACT == 0)
 	sprintf(s, "> %s", ERRMBOX);
  else{
	if(getgid() == GUEST_GID){
	 	sprintf(s, "> %s", maildrop);
	}
  }
  system(s);
}
