/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  weiterleiten.c					   */
/*        FUNKTIONEN  weiterleiten()					   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  23.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  weiterleiten()					   */
/*  BESCHREIBUNG  Je nach Parameter wird entweder ein Artikel an einen     */
/*		  User weitergeleitet, oder aber die letzte PM nochmal     */
/*		  mit einer anderen Adresse verschickt.                    */
/*     PARAMETER  arg = Nummer des Artikel, Empfaenger, etc.               */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void weiterleiten( arg )
char arg[];
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  char subject[STRING];
  int i, a, num;
  char empf[STRING];

  subject[0] = '\0';

  sprintf(s, "%s/usr/%d/.lastsubject", HOME, USER.id);
  fp = fopen( s, "r" );
  if(fp != NULL){
	fgets(subject, 80, fp);
	fclose(fp);
  }

  if((subject[0] == '\0') && ((arg[0] > 64) || (arg[0] == '?'))){
	ansi("md");
	printf(" %s\n", WEI01_MSG);
	ansi("me");
	return;
  }

  if(arg[0] == '\0'){
	printf("\n\n%s\n\n", WEI02_MSG);
	ansi("md");
	printf("%s %s\n\n", WEI03_MSG, subject);
	ansi("me");
	return;
  }

  num = 0;

  if(arg[0] < 65){
	i = 0;
	while((arg[i] > 32) && (arg[i] != '\0')) i++;
	strcpy(s, (char *) strcopy(arg, 0, (i-1)));
	num = atoi(s);
	strcpy(empf, (char *) strcopy(arg, (i+1), length(arg)));
	strcat(empf, "$");
  }
  else{
	sprintf(empf, "%s$", arg);
  }  

  if(num != 0){
	if(strcomp(BRETT, "PM") != 0){
		sprintf(t, "%s/%d", BRETT, num);
		sprintf(s, "cp %s/%d %s/usr/%d/.lastletter", BRETT, num, HOME, USER.id);
	}
	else{
		sprintf(t, "%s/usr/%d/%d", HOME, USER.id, num);
		sprintf(s, "cp %s/usr/%d/%d %s/usr/%d/.lastletter", HOME, USER.id, num, HOME, USER.id);
	}
	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi("md");
		printf(" %s\n", WEI04_MSG);
		ansi("me");
	return;
	}
	fclose(fp);
	system(s);
	sprintf(s, "%s/usr/%d/.lastletter", HOME, USER.id);

	sprintf(s, "%s/usr/%d/.lastsubject", HOME, USER.id);
	fp = fopen( s, "w" );
	if(fp == NULL){
		nerror("weiterl.c", 76, "weiterleiten", "Datei_Schreibfehler", s);
	}
	fprintf(fp, "%d <%s>", num, NG);
	fclose(fp);
  }

  brief(empf);
}
