/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  pd.c						   */
/*        FUNKTIONEN  pd(), status(), mkix(), statistik()		   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  20.11.1991					   */
/***************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <time.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  pd()							   */
/*  BESCHREIBUNG  Eine Datei wird mit o. ohne Protokoll uebertragen.       */
/*		  Diese Funktion wird von "lesen()" oder "pruefe()"        */
/*		  aufgerufen, wenn die zu bearbeitende Datei den Kenn-     */
/*		  zeichner "BINFILE" enthaelt.                             */
/*     PARAMETER  arg = Dateiname                                          */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void pd(arg, keywds)
char arg[], keywds[];
{
  FILE *fp;
  FILE *ff;

  char s[STRING];
  char tmp[STRING];
  char c;
  char protokoll;
  char cd[STRING];
  struct stat fst;
  long ts, tn;

  int cps, bps;
  int ok, i;

  strcpy(cd, stripped(arg));

  printf("\n\n");
  ansi("md");
  printf("%s\n\n", PD01_MSG);
  
  if(keywds[0] != '\0'){
	printf("%s ", PD02_MSG); 
	ansi("me");
	printf("%s\n\n", keywds);
  }
  else{
	 ansi("me");
  }

  ansi("mr");
  printf("%c%s [%c, %c, (%c)] >  ", CR, PD03_MSG, GBL06_MSG, GBL07_MSG, PD06_MSG);
  ansi("me");

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GBL06_MSG) && (c != GBL07_MSG) && (c != PD06_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == PD06_MSG) {	/*  X  */
	printf("\n");
	sigcatch(SIGINT);	
  }

  if (c != GBL06_MSG) {	/*  J  */
	printf("\n");
	return;
  }
  ansi("mr");
  printf("%c[%s] %c, %c, %c, %c ? > ", CR, PD07_MSG, PD08_MSG, PD09_MSG, PD10_MSG, PD11_MSG);
  ansi("me");


  do {
	protokoll = getint();
	if (protokoll >= 97) protokoll -= 32;
	if (protokoll == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, PD12_MSG);
		ansi("me");
	}
	if ((protokoll != PD08_MSG) && (protokoll != PD09_MSG) &&
	    (protokoll != PD10_MSG) && (protokoll != PD11_MSG))
		protokoll = 0;
  } while (protokoll == 0);


  printf("%c", protokoll);

  signal(SIGINT, SIG_IGN);
  signal(SIGHUP, SIG_IGN);
  signal(SIGQUIT, SIG_IGN);
  signal(SIGABRT, SIG_IGN);
  signal(SIGTERM, SIG_IGN);

  printf("\n\n");
  ansi("md");
  printf("%s\n\n", PD13_MSG);
  ansi("me");

  time(&ts);  

  switch (protokoll) {
      case PD08_MSG:
		sprintf(s, "cat %s", cd);
		system(s);
		break;
      case PD09_MSG:
		sprintf(s, "%s -b %s 2> /dev/null", SX, cd);
		system(s);
		break;
      case PD10_MSG:
		sprintf(s, "%s %s 2> /dev/null", SB, cd);
		system(s);
		break;
      case PD11_MSG:
		sprintf(s, "%s %s 2> /dev/null", SZ, cd);
		system(s);
		break;
  }

  time(&tn); tn = tn - ts; 

  stat(cd, &fst);
  USER.downratio += ((long) fst.st_size / 1024);

  ansi( "md" );
 
  if(tn < 1) tn = 1;
  cps = fst.st_size / tn;
  bps = cps * 11;

  if((bps > (MAX_BPS + 100)) || (bps < 0)) {
	printf("\n\n%s\n", PD14_MSG);
	ok = -1;
  }
  else{	
	printf("\n\n%ld %s.\n", fst.st_size, PD15_MSG);
	ok = 0;
  }
  ansi( "me" );
  printf("%s %d cps (ca. %d bps).", PD16_MSG, cps, bps);
  sprintf(tmp, "%s/%d.pd", TMP, getpid());
  ff = fopen( tmp, "w" );


  if(ok == 0){
	fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, cd); 
	if((bps > (MAX_BPS - 500)) && (bps < MAX_BPS)){
		fprintf(ff, "  %6.d  %6.d  OK\n", cps, bps);
	}
	else{
		fprintf(ff, "  %6.d  %6.d  ??\n", cps, bps);
	}
  }
  else{
	/*
	fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, cd); 
	fprintf(ff, "  %6.6d  %6.6d  %s\n", cps, bps, PD17_MSG);
	*/
  }

  i = 0; ok = PRO_ENTRIES;

  fp = fopen( PDLOG, "r" );
  if(fp != NULL){
	while((fgets(s, 80, fp) != NULL) && (i < ok)){
		fputs(s, ff);
		i++;
	}
	fclose(fp);
  }

  fclose(ff);

  sprintf(cd, "mv %s %s", tmp, PDLOG);
  system( cd );

  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  status						   */
/*  BESCHREIBUNG  Verschiedene (eigentlich fast alle) Eintraege aus den    */
/*		  Teilnehmerdaten werden angezeigt.                        */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine  					           */
/***************************************************************************/

void status()
{
  char s[STRING];
  char ex[255];
  int a, b;
  int i;


  sprintf(s, " %s %d ) %s ", PD18_MSG, USER.id, USER.name);
  headline(s);
  printf("\n");

  ansi("md");
  printf("%s", PD19_MSG);
  ansi("me");

  printf("\n");

  sprintf(ex, "%s                                        ", USER.name);
  ex[27] = '\0';
  strcat(ex, USER.nick);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, USER.geburtsdatum);
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon1);
  printf("%s\n", ex);

  sprintf(ex, "%s                                        ", USER.strasse);
  ex[27] = '\0';
  strcat(ex, USER.sh_name);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon2);
  printf("%s\n", ex);

  printf("%s\n\n", USER.wohnort);
  ansi("md");
  printf("%s", PD20_MSG);  
  ansi("me");
  printf("\n");

  s[0] = '\0'; strcat(s, datereconv( LASTLOG ));
  strcat(s, "-"); strcat(s, timereconv( LASTTIME ));
  s[16] = '\0';

  sprintf(ex, "       %1d       %1d  %5d     %1d       %1d     %1d      %1d  %6d  %s",
	USER.terminal, USER.editor, USER.level, USER.bell, USER.prompt, USER.more, USER.intro, USER.seq, s);
  printf("%s\n\n", ex);

  ansi("md");
  printf("%s", PD21_MSG);  
  ansi("me");
  sprintf(ex, "\n%06.6d                      %06.6d                    %06.6d",
	(USER.elapsed / 60), USER.upratio, USER.downratio);
  printf("%s\n\n", ex);

  ansi("md");
  printf("%s", PD22_MSG);
  ansi("me");

  i = 0;
  strcpy(s, (char *) USER.name);
  while (s[i] != '\0') {
	if (s[i] == ' ') s[i] = '.';
	i++;
  }

  sprintf(ex, "%s: %s@%s\n%s: %s%s", PD23_MSG, s, UUCPID, PD24_MSG, UUCPBANG, USER.nick);
  printf("\n%s\n", ex);
  if (USER.sh_name[0] != '\0')
	printf("%s: %s!%s\n", PD25_MSG, UUCPSITE, USER.sh_name);

  printf("\n");

  ansi("md");
  printf("%s\n", PD26_MSG);

  ansi("me");

  i = 1;
  while(newsgrp[i][0] != '\0'){
	if(i != 1) printf(", ");
	printf("%s", newsgrp[i]);
	i++;
  }

  printf("\n\n");  
}



/***************************************************************************/
/*      FUNKTION  mkix()						   */
/*  BESCHREIBUNG  Wandelt eine Datei ins UNIX-Format (CRs werden entfernt) */
/*     PARAMETER  s  =  Dateiname                                          */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void mkix( pfad )
char pfad[];
{
  FILE *fp; 
  FILE *ff;

  char s[255];
  char p[255];

  int i, ok = 0;

  
  sprintf(p, "%sabc", pfad);

  fp = fopen( pfad, "r" );
  if(fp == NULL){
	return;
  }  	

  ff = fopen( p, "w" );
  if(ff == NULL){
	nerror("pd.c", 243, "mkix", "Datei-Erstellungsfehler", p);	
  }

  while((ok == 0) && (fgets(s, 254, fp) != NULL)){
	i = 0;
	while(s[i] != '\0'){
		if(s[i] == CTRL_Z){
			ok++;
			break;
		}
		i++;
	}
	if(ok == 0){
		i = strlen(s) -2;
		if(s[i] == CR){
			s[i]    = LF;
			s[i +1] = '\0';
		}
		fputs(s, ff);
	}
  }
  fclose(fp);
  fclose(ff);

  unlink(pfad);
  rename(p, pfad);
}



/***************************************************************************/
/*      FUNKTION  statitik()						   */
/*  BESCHREIBUNG  Anrufer-Protokoll auswerten 				   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

#define MAX_TAGE  16
#define TZS      1

void statistik()
{
  FILE *fp;

  struct tm *tp;
  time_t tt;

  char s[STRING];
  char od[MAX_TAGE][STRING];
  char t[STRING];
  char r[STRING];

  int v18u[MAX_TAGE];
  int n18u[MAX_TAGE];
  int v18g = 0;
  int n18g = 0;

  int zeit = 0;
  int tage = 0;
  int max  = 0;

  int i, a;
  int toggle = 0;
  int sun;

  fp = fopen( CALLS, "r" );
  if(fp == NULL){
	nerror("pd.c", 288, "statistik", "Datei-Lesefehler", CALLS);		
  }

  od[0][0] = '\0';

  headline( PD27_MSG );
  printf("%s\n", PD28_MSG);
  printf("===============================================================================\n");

  while((fgets(s, (STRING *2), fp) != NULL) && (tage < (MAX_SCR_LINES -7))){
	strcpy(t, (char *) strcopy(s, 64, 71));

	if(strcomp(t, od[tage]) != 0){
		if(tage != 0){
			if((v18u[tage] + n18u[tage]) > max){
				max = v18u[tage] + n18u[tage];
			}
			v18g += v18u[tage];
			n18g += n18u[tage];
		}
		tage++;
		od[tage][0] = '\0'; strcat(od[tage], t);
		v18u[tage] = 0;
		n18u[tage] = 0;
        }
	zeit = atoi(strcopy(s, 74, 75));
	if((zeit >   6) && (zeit < 18)) v18u[tage]++;
	if((zeit >= 18) || (zeit <= 6)) n18u[tage]++;
  }

  sprintf(s, "%s", "ooooooooooooooooooooooooooooooooooooooooooooooooooooo");

  time(&tt);
  tp = localtime(&tt);
  sun = tp->tm_wday;

  for(i = 1; i < tage; i++){
	sprintf(t, "%s", s);
	a = (290 / max * (v18u[i] + n18u[i])) / 10;
	t[a] = '\0';	
	strcpy(r, "    ");	
	if(sun == 0){
		strcpy(r, PD29_MSG);
		toggle++;	
		ansi( "md" );
	}
	if(sun == 6) 
		strcpy(r, PD30_MSG);
	sun--;
	if(sun == -1) sun = 6;

	printf("%s %s %4.d        %5.d         %5.d      %s\n",
                od[i], r, v18u[i], n18u[i], v18u[i]+n18u[i], t);
	if(toggle != 0) ansi( "me" );
	toggle = 0;
  }

  printf("-------------------------------------------------------------------------------\n");
  printf("%s %5.d        %5.d         %5.d      %s\n",
	  PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG);
  printf("===============================================================================\n");

  printf("\n%s %d %s.\n", PD33_MSG, (tage -1), PD34_MSG);   

  fclose(fp);
}


