/***************************************************************************/
/*	    PROGRAMM  ix/MBox						   */
/*             DATEI  mbox.h						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  11.12.1991					   */
/***************************************************************************/
 
#include "mbox.msg"
 
/***************************************************************************/
/* >ORGANIZATION  -  frei waehlbar (moeglichst identisch mit dem ent-      */
/*		     sprechenden Eintrag fuer NEWS)			   */
/* >SYSTEM        -  frei waehlbar (Name der Mailbox)     	  	   */
/***************************************************************************/

#define ORGANIZATION "THE UNDERGROUND NETWORK"
#define SYSTEM       "The Time Traveling Agency"  



/***************************************************************************/
/*  VERSION       -  wird vom Autor (und nur vom dem) geandert		   */
/*                   Co-Autoren, Portierer etc. koennen sich gefaelligst   */
/*		     ihren eigenen Eintrag basteln.		           */
/*  AUTOR         -  das bin ich - Hallo auch !				   */
/***************************************************************************/

#include "patchlevel.h"

#define VERSION	     "ix/MBox 1.6"
#define AUTOR        "by <volkers@unnet.w.open.de>"




/***************************************************************************/
/* >UUCPSITE       - Systemname innerhalb der UUCP-Netze		   */
/* >UUCPID         - Adresse innerhalb der UUCP-Netze			   */
/* >UUCPBANG       - Adresse als BANG-Pfad				   */
/*  UUCPCOSTS      - Gebuehrenaufstellung				   */
/***************************************************************************/

#define UUCPSITE     "unnet"
#define UUCPID       "unnet.w.open.de"        
#define UUCPBANG     "~!unido!horga!xenox!unnet!"
#define UUCPCOSTS    "/usr/spool/uucp/.costs"


/***************************************************************************/
/*  X_MAIL_DEMON    - Name des X-Mail-Daemons (HAENDE WEG !!!) 		   */
/***************************************************************************/

#define X_MAIL_DEMON "X-Mail-Daemon"



/***************************************************************************/
/* >HOME             - HOME-Directory der ix/MBox	   	  	   */
/*  BIN              - System-Binaries (Pfad zu den UNIX-Befehlen)	   */
/*  LIB		     - Pfad zum MBox-Directory LIB			   */
/*  TMP              - Directory fuer temporaere Dateien		   */
/* >SPOOL	     - Pfad zum SPOOL-Directory (MAIL)	 		   */
/* >NEWS	     - Pfad zum SPOOL-Directory fuer NEWS		   */
/*  ERRMBOX          - Mailbox des Error-Users (POSTMASTER)		   */
/*  MAILDROP         - Pfad zu den Maildrops der SH-User		   */
/* >NGROUPS          - Pfad zur "active"-Datei von NEWS			   */
/*  AGROUPS	     - Pfad zur MBox-"active"-Datei			   */
/***************************************************************************/
     
#define HOME         "/mbox"
#define BIN          "/usr/bin"
#define LIB	     "./lib"
#define TMP	     "/tmp"
#define SPOOL        "/usr/spool"
#define NEWS         "/usr/spool/news"
#define ERRMBOX      "/usr/spool/mail/postmaster"
#define MAILDROP     "/usr/spool/mail"
#define NGROUPS      "/usr/lib/news/active"
#define AGROUPS      "./etc/active"





/***************************************************************************/
/* >CONSOLE	      - Geraet/Datei fuer die Logbuch-Ausgaben		   */
/*			Ist CONSOLE als "REDIRECT" definiert, wird aus der */
/*                      Datei CDIRECTFL der Name der Ausgabedatei gelesen  */
/*			gelesen					           */
/*  CDIRECTFL         - Geraet/Datei wohin CONSOLE-Info ausgeben wird	   */
/*		        Die Datei ENTHAELT DEN NAMEN der Ausgabedatei !!!  */
/* >CPRN              - Geraet/Datei fuer Fehler-Ausgaben		   */
/* >POSTMASTER        - Name des SYSOPs (identisch mit dessen SH-Account)  */
/*  MAX_BPS           - Maximale Modem-Ubertragungsrate in BPS             */
/* >PMS_TTY           - Nummer des einzigen Terminals, auf dem sich "root" */
/*			anmelden darf					   */
/*  GUEST             - MBox-Account fuer Besucher			   */
/*  UDBASE            - Pfad zur Teilnehmer-Datenbank			   */
/*  UDSEQ             - Pfad zur Teilnehmer-SEQ-Datei			   */
/***************************************************************************/

#define CONSOLE	     "REDIRECT"
#define CDIRECTFL    "/etc/mbox.out"
#define CPRN	     "/tmp/errlog"
#define POSTMASTER   "volkers"
#define PMS_TTY      "/dev/tty4"
#define MAX_BPS      2400
#define GUEST        "GAST"
#define UDBASE       "./etc/users.data"
#define UDSEQ        "./etc/users.seq"




/***************************************************************************/
/*  BEFEHLE 	   - Pfad zur Befehls-Tabelle				   */
/*  HILFE          - Pfad zu den HELP-Texten				   */
/*  INTRO          - Pfad zur INTRO-Meldung				   */
/*  LOGO           - Optionaler Text als Mailbox-LOGO 			   */
/***************************************************************************/

#define BEFEHLE	     "./etc/help.befehle"  
#define HILFE	     "./etc/help.hilfe"
#define KURZHILFE    "./etc/help.shorthelp"
#define INTRO        "./etc/intro"
#define LOGO         "./etc/logo"



/***************************************************************************/
/*  SEQ             - Pfad zur MBox-SEQ-Datei (Anzahl der Anrufe)	   */
/*  CALLS           - Pfad zur MBox-CALLS-Datei (Logfile)		   */
/*  WHO             - Pfad zur MBox-WHO-Datei (gerade aktive User)	   */
/***************************************************************************/

#define SEQ          "./etc/mbox.seq"
#define CALLS        "./etc/mbox.calls"
#define WHO          "./etc/mbox.who"




/***************************************************************************/
/*  EDITORS          - Pfad zur Liste der verfuegbaren Eddies		   */
/*  GAMES            - Pfad zur Liste der Online-Spiele			   */
/* >CHAT             - Pfad zum CHAT-Programm				   */
/*  RSH              - MBox-RSH; NICHT identisch mit RemoteSH/RestrictedSH */
/***************************************************************************/

#define EDITORS      "./etc/mbox.editors"
#define GAMES	     "./etc/mbox.games"
#define CHAT         "/usr/bin/chat"
#define RSH          "./mbrsh"





/***************************************************************************/
/*  ROOT_UID          - siehe "/etc/passwd"				   */
/*  ROOT_GID          - dito						   */
/*  GUEST_GID 	      - dito (unbedingt != GID fuer "normale" User)        */
/*  UUCPUID           - siehe "/etc/passwd"				   */
/*  UUCPGID           - dito (evtl. auch "/etc/group")			   */
/*  NEWSUID           - siehe oben					   */
/*  NEWSGID           - siehe oben					   */
/***************************************************************************/

#define ROOT_UID      0
#define ROOT_GID      0
#define GUEST_GID     1
#define UUCPUID      40
#define UUCPGID      40
#define NEWSUID      30
#define NEWSGID      6





/***************************************************************************/
/* >FIRST_EX_TTY       - Nummer des ersten seriellen Terminals		   */
/***************************************************************************/

#define FIRST_EX_TTY 64




/***************************************************************************/
/* >SIGNATURE          - Name des '.signature'-File im $HOME eins SH-Users */
/* >TSET               - Pfad zum TSET-Programm				   */
/* >EXPIRE             - Pfad zum EXPIRE-Programm			   */
/*  MB-DAEMON          - Pfad zum MB-DAEMON-Programm			   */
/*  MB_DLOG            - Pfad zum MB-DAEMON-Statistik-File		   */
/*  XMD		       - Pfad zum XMD-Programm				   */
/*  XMDLOG	       - Pfad zum XMD-Protokoll-File		           */
/***************************************************************************/

#define SIGNATURE    ".wmailsign"
#define TSET         "./etc/tset"
#define EXPIRE       "/usr/lib/news/expire"
#define MB_DAEMON    "/usr/bin/mb-daemon"
#define MB_DLOG      "./etc/mbd.log"
#define XMD          "/usr/bin/xmd"
#define XMDLOG	     "/usr/adm/xmd.log"


/***************************************************************************/
/*  UREPLY_TO          - Absender-Adressen-Kennung fuer MAIL		   */
/*  NREPLY_TO          - Absender-Adressen-Kennung fuer NEWS		   */
/***************************************************************************/

#define UREPLY_TO    "Sender: "
#define NREPLY_TO    "Reply-To: "





/***************************************************************************/
/* >COMPRESS		- Pfad zum Standard-COMPRESS			   */
/***************************************************************************/

#define COMPRESS     "/usr/bin/compress"




/***************************************************************************/
/*  PDNG		 - Name der Freeware-NG				   */
/*  PDLOG                - PD-Download-Protokoll			   */
/*  PDSCRIPT		 - Pfad zum Protokoll der UPLOADs		   */
/* >NEWS_MINIMUM         - Mindestens verfuegbare NGs			   */
/*  MAX_PER_NG           - Maximale Anzahl der Eintraege pro NG		   */
/*  EXPIRE_DAYS          - Ab wann loeschen, wenn MAX_PER_NG erreicht ist  */
/*  NAT_DOMAIN1          - Nationale Domains (gebuehrenfrei)		   */
/*  NAT_DOMAIN2          - (dito)					   */
/*  NAT_DOMAIN3          - (dito)					   */
/***************************************************************************/

#define PDNG	     "local.pd"
#define PDLOG	     "./etc/pd.log"
#define PDSCRIPT     "./etc/pd.script"
#define NEWS_MINIMUM "junk dnet local sub xenox"
#define MAX_PER_NG   700
#define EXPIRED_DAYS 32
#define NAT_DOMAIN1  ".de"
#define NAT_DOMAIN2  ".sub.org"
#define NAT_DOMAIN3  ".de" 





/***************************************************************************/
/*  SZ  		  - ZModem Download				   */
/*  SX			  - X-Modem					   */
/*  SB		          - Y-Modem					   */
/*  RZ			  - ZModem Upload				   */
/*  RX                    - X-Modem 					   */
/*  RB                    - Y-Modem					   */
/***************************************************************************/

#define SZ           "/usr/bin/sz"
#define SX           "/usr/bin/sx"
#define SB 	     "/usr/bin/sb"

#define RZ           "/usr/bin/rz"
#define RX	     "/usr/bin/rx"
#define RB	     "/usr/bin/rb"





/***************************************************************************/
/*  TARIF           	  - Pfennige pro Einheit (Telefongebuehren)	   */
/*  NZNT                  - Sekunden pro Einheit Nahzone/Normal-Tarif	   */
/*  NZBT                  -                      Nahzone/Billig-Tarif	   */
/*  RZNT                  - 		         Regionalzone/Normal-Tarif */
/*  RZBT		  -			 Regionalzone/Billig-Tarif */
/*  WZNT		  -			 Weitzone/Normal-Tarif     */
/*  WZBT		  -			 Weitzone/Billig-Tarif     */
/***************************************************************************/

#define TARIF        23
#define NZNT         360
#define NZBT         720
#define RZNT 	     60
#define RZBT	     120
#define WZNT	     21
#define WZBT	     42





/***************************************************************************/
/*  PRO_ENTRIES    	  - Maximal Eintraege in MBOX.CALLS      	   */
/***************************************************************************/

#define PRO_ENTRIES  600

#include "defs.h"


