/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  makro.c						   */
/*        FUNKTIONEN  makro()						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"


void get_makros();

/***************************************************************************/
/*      FUNKTION  makro()						   */
/*  BESCHREIBUNG  Makros auswerten					   */
/*     PARAMETER  s  =  Eingabezeile                                       */
/*     RUECKGABE  Eingabezeile mit Gegenwerten der Makros	           */
/***************************************************************************/

char *makro( s )
char s[];
{
  char t[STRING];
  char f[STRING];
  int a = 0, b = 0, i = 0;
  int m = 0, ok = 0;
  int subcom = 0;

  t[0] = '\0';

  strcat(s, " ");

  while(s[0] == ' ') *s++;

  while(s[i] != '\0'){

	if(s[i] == ' '){
		b = i -1;
		f[0] = '\0';
		strcat(f, strcopy(s, a, b));
		a = i +1;
		ok = 0; 
		m = 0;

		while(MAK[m].makname[0] != '\0'){
			if((strcomp(f, MAK[m].makname) == 0) && (strcomp(MAK[m].makname, f) == NULL) && (subcom == 0)){
				ok = 1; 
				strcat(t, MAK[m].makwert);
			}
			m++;
		}
		if(ok == 0) strcat(t, stripped(f));
		strcat(t, " ");
	
		subcom++;
	}
	i++;
  }
  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  set_makros						   */
/*  BESCHREIBUNG  Die Makro-Datei wird angezeigt und kann geandert werden. */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void set_makros()
{
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char tmp[STRING];
  char c;
  int b;


  printf("\n\n%s\n\n", MAK01_MSG);

  ansi("md");
  b = 4;
  while(MAK[b].makname[0] != '\0'){
	printf("%s%c=%c%s\n", MAK[b].makname, TAB, TAB, MAK[b].makwert);
	b++;
  }  
  printf("\n");  
  ansi("mr");
  printf("%c%s [%c, %c] > ", CR, MAK02_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c == GBL06_MSG) {
	sprintf(t, "%s %s", EDDY, MAKRO);
	system(t);
  }

  get_makros();

  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  get_makros()						   */
/*  BESCHREIBUNG  Liest die userabhaengigen Makro-Vereinbarungen in die    */
/*		  Stuktur ein				                   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void get_makros()
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  int b = 0, i = 0;


  sprintf(MAK[0].makname, "demo");
  sprintf(MAK[0].makwert, "?, sl 3, PM, sl 3, i, sl 3, anr, sl 3, dem1");
  sprintf(MAK[1].makname, "dem1");
  sprintf(MAK[1].makwert, "b, sl 3, +, +, +, +, +, +, i, sl 3, +, dem2");
  sprintf(MAK[2].makname, "dem2");
  sprintf(MAK[2].makwert, "i, sl 3, +, i, sl 3, b, +, i, sl 3, ?, dem3");
  sprintf(MAK[3].makname, "dem3");
  sprintf(MAK[3].makwert, "sl 3, v, sl 3, h hilf, sl 3, st, sl 3, pm, i");
 

  fp = fopen(MAKRO, "r");
  if (fp == NULL) {
	MAK[4].makname[0] = '\0';
	return;
  }


  b = 4;

  while(fgets(s, 80, fp) != NULL){

	MAK[b].makname[0] = '\0';
	MAK[b].makwert[0] = '\0';
	
	i = 0;

	while((s[i] != '=') && (s[i] != '\0')) i++;

	t[0] = '\0'; strcat(t, strcopy(s, 0, (i-1)));
	strcat(MAK[b].makname, stripped(t));

	t[0] = '\0'; strcat(t, strcopy(s, (i+1), length(s)));
 	strcat(MAK[b].makwert, stripped(t));

	b++;
	if (b >= (MAX_MAK -1)) {
		nerror("makro.c", 108, "get_makro", "MAX_MAK ueberschritten !!", "???");
	}
  }
  MAK[b].makname[0] = '\0';

  fclose(fp);

}

/***************************************************************************/
/*      FUNKTION  add_makros()						   */
/*  BESCHREIBUNG  Haengt Makro-Definition aus einer Prompt-Eingabe an die  */
/*		  Makro-Datei an			                   */
/*     PARAMETER  s  =  Makro-Definition                                   */
/*     RUECKGABE  keine							   */
/***************************************************************************/

void add_makro( s )
char s[];
{
  FILE *fp;

  fp = fopen( MAKRO, "a" );
  if(fp == NULL){
	nerror("makro.c", 189, "add_makro", "Datei-Erweiterungsfehler", MAKRO);
  }
  fputs((char *) stripped(s), fp);
  fputs("\n", fp);
  fclose(fp);

  get_makros();

  printf("\n\n%s\n", MAK03_MSG);
  
}


/***************************************************************************/
/*      FUNKTION  makro_definition()					   */
/*  BESCHREIBUNG  Prueft ob die Prompt-Eingabe eine Makro-Definition ent-  */
/*		  haelt.    				                   */
/*     PARAMETER  s  =  Prompt-Eingabe                                     */
/*     RUECKGABE  0  =  Keine Definition				   */
/*                1  =  Makro-Definition				   */
/***************************************************************************/

int makro_definition( s )
char s[];
{
  int i = 0;
  int ok = 0;

  while(s[i] != '\0'){
	if(s[i] == '=') ok++;
	i++;
  }

  if(ok == 1){
	add_makro( s );
  }
  if(ok > 1){
	ansi("md");
	printf(" %s\n", MAK04_MSG);
	ansi("me");
  }
  return ok;
}

