/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  mail.c						   */
/*        FUNKTIONEN  fetch_receipy(), brief(), unterschrift(), ansage()   */
/*		      getsite()						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  07.12.1991					   */
/***************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>

#include "mbox.h"

static int fetch_local;
static char fetch_subj[STRING];


/***************************************************************************/
/*      FUNKTION  fetch_receipy()					   */
/*  BESCHREIBUNG  Im REPLY-Modus wird die Adresse des Empfaengers aus      */
/*	          dessen Mail gefiltert.                                   */
/*     PARAMETER  REP  =  Datei mit der Mail des zukuenftigen Empfaengers  */
/*     RUECKGABE  Adresse des Empfaengers                                  */
/***************************************************************************/

char *fetch_reciepy(REP)
char REP[];
{
  FILE *fp;
  char s[STRING];
  char t[STRING];
  char f[STRING];
  int ok = 0, i;
  int beg = 0;
  int bang = 0, at = 0, strange = 0, stranger = 0;

  fetch_local = 0;
  fetch_subj[0] = '\0';

  fp = fopen(REP, "r");
  if (fp == NULL) {
	nerror("mail.c", 31, "fetch_reciepy", "Datei_Lesefehler", REP);
  }
  while (fgets(f, 80, fp) != NULL) {
	if (strcomp("From: ", f) == 0) {
		beg = 6;
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("From ", f) == 0) { /* local mail */
		beg = 5; 
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("Reply-To: ", f) == 0) {
		beg = 10;
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("Subject: ", s) == 0) {
		strcpy(fetch_subj, (char *) strcopy(s, 9, 79));
	}
  }
  fclose(fp);

  if (ok == 0) {
	return (char *) "OOPS";
  }
  i = beg;
  ok = 0;

  while (s[i] != '\0') {
	if (s[i] == '(') ok = i - 2;
	if (s[i] == '<') strange = i + 1;
	if (s[i] == '>') stranger = i - 1;
	i++;
  }
  if (ok == 0) ok = i;
  strcpy(t, (char *) strcopy(s, beg, ok));

  if ((strange != 0) && (stranger != 0)) {
	strcpy(t, (char *) strcopy(s, strange, stranger));
	return (char *) t;
  }
  i = 0;
  while (t[i] != '\0') {
	if (t[i] == '@') at = i;
	if (t[i] == '!') bang = i;
	i++;
  }

  if (at != 0) {
	strcpy(s, (char *) strcopy(t, (at + 1), length(t)));
	if (strcomp(UUCPSITE, s) == 0) {	/* local user */
		fetch_local = 1;
		strcpy(s, (char *) strcopy(t, 0, (at - 1)));
		i = 0;
		while (s[i] != '\0') {
			if (s[i] == '.') s[i] = ' ';
			i++;
		}
		return (char *) s;
	}
  }

  if (beg == 5) {  /* local mail */
	i = 0;
	while((t[i] != '\0') && (t[i] != ' ')) i++;
	t[i] = '\0';
  }

  return (char *) t;
}



/***************************************************************************/
/*      FUNKTION  getsite()						   */
/*  BESCHREIBUNG  Findet den Empfaenger SITE in der Adresse		   */
/*     PARAMETER  Adresse                                                  */
/*     RUECKGABE  Empfaenger SITE                                          */
/***************************************************************************/

char *getsite(arg)
char arg[];
{
  int i = 0, a = 0, b = 0, c = 0;
  char s[STRING];

  while(arg[i] != '\0'){
	if(arg[i] == '!') a = i - 1;
	if(arg[i] == '@') b = i + 1;
	if(arg[i] == '.'){
		if((b != 0) && (c == 0)) c = i -1;
	}
	i++;
  }

  if((a == 0) && (b == 0)) strcat(s, UUCPSITE);
  if(a != 0) strcpy(s, (char *) strcopy(arg, 0, a));
  if(b != 0) strcpy(s, (char *) strcopy(arg, b, c));

  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  checkdomaintype()					   */
/*  BESCHREIBUNG  Internationale MAIL ???			 	   */
/*     PARAMETER  Adresse                                                  */
/*     RUECKGABE   0 = ok                                                  */
/*                -1 = Level zu gering					   */
/***************************************************************************/

int checkdomaintype(arg)
char arg[];
{
  int i = 0, l, a, e = 0, f = 0, g = 0, international = 0;
  char s[STRING];

  if(USER.level >= WRITE_INTERNAT) return 0;

  while(arg[i] != '\0'){
	if(arg[i] == '!') e++;
	if(arg[i] == '@') g++;
	i++;
  }
  s[0] = '\0';

  if((e == 0) && (g == 0)) return 0;

  if(e > 1) international++;

  if(e == 0){

	l = strlen( (char *) arg);

	a = strlen( (char *) NAT_DOMAIN1 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN1) == 0) f++;

	a = strlen( (char *) NAT_DOMAIN2 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN2) == 0) f++;

	a = strlen( (char *) NAT_DOMAIN3 );
	strcpy(s, (char *) strcopy(arg, (l-a), l));
	if(strcomp(s, NAT_DOMAIN3) == 0) f++;  	

	if(f == 0) international++;
  }  

  if(international != 0){
	ansi("md");
	printf("\n\n%s (%d) %s\n", MAL01_MSG, WRITE_INTERNAT, MAL02_MSG);
	ansi("me");
	return -1;	
  }

  return 0;
}







/***************************************************************************/
/*      FUNKTION  brief()						   */
/*  BESCHREIBUNG  Eine persoenliche Nachricht wird verschickt. Je nach     */
/*		  Empfaenger-Adresse und Parameter wird die Post ins       */
/*		  MBox-interne Mailsystem geschickt, oder an MAIL          */
/*		  weitergleitet. Die Adresse des Empfaengers wird ent-     */
/*		  weder als Parameter uebergeben, oder aus einer Datei     */
/*		  gefiltert, auf die geantwortet werden soll (REPLY-Mode). */
/*     PARAMETER  arg  =  "~REPLY~"    =  REPLY-Modus aktivieren           */
/*			  Es wird nicht unterschieden zwischen REPLY auf   */
/*			  pers. Mail oder REPLY auf einen NEWS-Artikel.    */
/*			  Die Datei mit der zu beantwortenden MSG liefert  */
/*			  die Routine "lesen()".                           */
/*		  arg  =  "Empfaenger" =  verwertbare Adresse fuer das     */
/*			  interen Mail-System oder MAIL.                   */
/*     RUECKGABE   -1  =  Abbruch                                          */
/***************************************************************************/

int brief(arg)
char arg[];
{
  FILE *fp;
  FILE *ff;
  int fd;
  int i, j;
  int ok;
  struct userdaten LOOSER;

  struct tm *timeptr;
  time_t timer;

  int receiver;
  int mail_id;
  int EX_PM = 0;
  int REPLY = 0;
  int lines = 0;
  int WEITERLEITEN = 0;
  int HOLD = 0;
  int UMLEITUNG = 0;

  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char REP[STRING];
  char f[STRING];
  char subject[STRING];
  char from[STRING];
  char rec_char[STRING];
  char ex[255];
  char user[STRING];
  char mesg_id[STRING];
  char refs[STRING];
  char date[STRING];
  char c;
  char protokoll;
  char lf;
  char pubdir[STRING];
  char dummy[STRING];

  char YOUR_SITE[STRING];

  int BINFILE;
  int news_reply = 0;

  struct stat fst;


  i = 0;
  ok = 0;

  mesg_id[0] = '\0';

  if (arg[0] == '\0') {
	ansi("md");
	printf(" %s\n", MAL03_MSG);
	ansi("me");
	return -1;
  }
  EX_PM = 0;

  while (arg[i] != '\0') {
	if ((arg[i] == '!') || (arg[i] == '@') || (arg[i] == '%')) EX_PM++;
	i++;
  }

  if ((EX_PM > 0) && (USER.level < MAILOUT_LEV)) {
	ansi("md");
	printf("\n\n%s (%d) %s\n", MAL04_MSG, MAILOUT_LEV, MAL05_MSG);
	ansi("me");
	return -1;
  }

  if(arg[length(arg) -1] == '?'){
	arg[length(arg) -1] = '$';
	HOLD++;
  }

  if(arg[length(arg) -1] == '$'){
	WEITERLEITEN++;
	arg[length(arg) -1] = '\0';
	sprintf(TEP, "%s/usr/%d/.lastletter", HOME, USER.id);
	sprintf(t, "%s/usr/%d/.lastsubject", HOME, USER.id);
	fp = fopen( t, "r" );
	if(fp == NULL) {
		return -1; 
	}
	fgets(s, 80, fp);
	fclose(fp);
	if(HOLD == 0){
		sprintf(subject, "%s %s", MAL06_MSG, s);
		UMLEITUNG++;
	}else
		sprintf(subject, "%s", s);
  }

  user[0] = '\0';
  strcat(user, arg);

  if(WEITERLEITEN != 0) goto TRY_AGAIN;

  if (strcomp("~REPLY~", arg) == 0) {
	REPLY++;
	sprintf(REP, "%s/%dRep", TMP, getpid());
	sprintf(TEP, "%s/%dTep", TMP, getpid());
	fp = fopen(REP, "r");
	if (fp == NULL) {
		nerror("mail.c", "brief", REP, "001");
	}
	fgets(s, 80, fp	);			/* HEADER: Autor */

	sprintf(dummy, "%s %s", GBL01_MSG, X_MAIL_DEMON);

	if ((strcomp(GBL01_MSG, s) == 0) && (strcomp(dummy, s) != 0)) {
		strcpy(user, (char *) strcopy(s, (1+strlen(GBL01_MSG)), 80));

		fgets(s, 80, fp);		/* HEADER: Datum */
		fgets(s, 80, fp);		/* HEADER: Betreff */

		strcpy(t, (char *) strcopy(s, (1+strlen(GBL03_MSG)), 80));
		subject[0]= '\0';
		if (strcomp("Re: ", t) != 0) {
			strcpy(subject, "Re: ");
		}
		strcat(subject, (char *) stripped(t));

		fgets(s, 80, fp);	/* HEADER: Leer */
		fgets(s, 80, fp);	/* HEADER: Leer */
	}
	else {		/* UUCP-Header (!MBox) */

		sprintf(subject, MAL07_MSG);
		refs[0] = '\0';
		mesg_id[0] = '\0';

		ok = -1;

		while ((ok < 1) && (fgets(s, 80, fp) != NULL)) {
			if (strcomp("Lines: ", s)      == 0) ok = 1;
			if (strcomp("Date: ",  s)      == 0) {
				strcpy(date, (char *) strcopy(s, 6, 80));
				ok = 1;
			}
			if (strcomp("Newsgroups: ", s) == 0) news_reply++;
			if (strcomp("Subject: ", s)    == 0) {
				subject[0] = '\0';
				strcpy(t, (char *) strcopy(s, 9, 80));
				if (strcomp("Re: ", t) != 0) {
					sprintf(subject, "%s", "Re: ");
				}
				strcat(subject, (char *) stripped(t));
			}
			if (strcomp("Message-Id: ", s) == 0) {
				strcpy(mesg_id, (char *) strcopy(s, 12, 80));
			}
			if (strcomp("From: ", s) == 0) {
				strcpy(from, (char *) strcopy(s, 6, 80));
				ok = 0;
			}
			if (strcomp("From ", s) == 0) {
				strcpy(from, (char *) strcopy(s, 5, 80));
				ok = 0;
			}
			if (strcomp("References: ", s) == 0) {
				strcpy(refs, (char *) strcopy(s, 12, 80));
			}
			if ((strlen(s) < 5) && (ok == 0)) ok = 1;
		}
		fgets(s, 80, fp);
	}

	ff = fopen(TEP, "w");
	while (fgets(s, 80, fp) != NULL) {
		fputs("> ", ff);
		fputs(s, ff);
	}
	fputs("", ff);
	fclose(ff);
	fclose(fp);
  }

  TRY_AGAIN:

  if((WEITERLEITEN != 0) && (EX_PM != 0)){
	sprintf(rec_char, "%s", user);
	if(checkdomaintype( rec_char ) != 0) return -1;
	goto ONCE_MORE;
  }

  receiver = 0;

  maybe_locked(UDBASE, "r"); lockf(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("mail.c", 216, "brief", "Datei-Lesefehler", UDBASE);
  }
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (receiver == 0)) {
	if ((strcomp(user, LOOSER.name) == 0) ||
	    (strcomp(LOOSER.name, user) == 0) ||
	    (strcomp(user, LOOSER.nick) == 0) ||
	    (strcomp(user, LOOSER.sh_name) == 0)) {
		receiver = LOOSER.id;
		strcpy(rec_char, LOOSER.name);
	}
  }
  close(fd);
  unlockf(UDBASE);

  if(WEITERLEITEN != 0) goto ONCE_MORE;

  if ((receiver == 0) && (EX_PM == 0)) {

	if (REPLY != 0) {
		strcpy(user, fetch_reciepy(REP));
		if (fetch_local == 1) goto TRY_AGAIN;
		strcpy(rec_char, (char *) stripped(user));
		if (strcomp(user, "OOPS") == 0) {
			ansi("md");
			printf("\n\n%s\n", MAL08_MSG);
			ansi("me ");
			unlink(TEP);
			unlink(REP); /* ??? */
			return -1;
		}
		EX_PM = 1;
		c = MAL13_MSG;
		goto REPLY_MARK;
	}
	else {
		ansi("md");
		strcpy(rec_char, (char *) stripped(user));
		printf("\n\n%s \"%s\" %s\n", MAL09_MSG, user, MAL10_MSG);
		ansi("me");
		unlink(TEP);
		unlink(REP);
		return -1;
	}
  }
  unlink(REP);

  if (EX_PM == 0) {
	ansi("md");
	sprintf(s, "%s/usr/%d/.hello", HOME, receiver);
	printf("\n\n");
	show(s, 22, 0);
	ansi("me");
  }
  else {
	strcpy(rec_char, arg);
  }

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (REPLY != 0) {
	c = MAL13_MSG;
	goto REPLY_MARK;
  }
  printf("\n\n");
  ansi("mr");
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL12_MSG);
  ansi("me");
  printf("%c%c", MAL13_MSG, BS);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MAL16_MSG);
		ansi("me");
	}
	if (c == ENTER) c = MAL13_MSG;
	if ((c != MAL13_MSG) && (c != MAL14_MSG) && (c != MAL15_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL15_MSG) {		/* VERWERFEN */
	unlink(REP);
	unlink(TEP);
	printf("\n");
	return -1;
  }
  sprintf(TEP, "%s/M%d", TMP, getpid());
  sprintf(pubdir, "%s/dir%d", TMP, getpid());

  if (c == MAL14_MSG) {		/* UPLOAD */
	clearline();
	ansi("mr");
	printf("%c%s, ? > ", CR, MAL17_MSG);
	ansi("me");

	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi("mr");
			printf("%c%s > ", CR, MAL17aMSG);
			ansi("me");
		}
		if ((protokoll != MAL18_MSG) && (protokoll != MAL18_MSG) &&
		    (protokoll != MAL20_MSG) && (protokoll != MAL21_MSG))
			protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll);

  }
  printf("\n\n%c", CR);
  ansi("mr");
  printf("%s ", MAL22_MSG);
  ansi("me");
  printf(" %s (%s)\n%c", USER.name, USER.nick, CR);
  ansi("mr");
  printf("%s ", MAL23_MSG);
  ansi("me");
  printf(" %s\n%c", rec_char, CR);
  ansi("mr");
  printf("%s ", MAL24_MSG);
  ansi("me");
  printf(" ");
  strcpy(subject, (char *) getline(50, 11, '.', ""));

  REPLY_MARK:

  if(checkdomaintype( rec_char ) != 0) return -1;

  if (c == MAL13_MSG) {
	sprintf(s, "%s %s", EDDY, TEP);
	noctrlx();
	system(s);
	ctrlx();
	protokoll = '*';
  }
  else {			/* UPLOAD */

	printf("\n\n");
	printf("%s\n\n", MAL25_MSG); 
	ansi("md");
	printf("%s", MAL26_MSG);
	ansi("me");
          
	unlink( TEP );
	
	switch (protokoll) {
	    case MAL18_MSG:
			fp = fopen(TEP, "w");
			if (fp == NULL) {
				nerror("mail.c", 268, "brief", "DSF", TEP);
			}
			c = 0;
			lf = CR;

			fputc(LF, fp);

			while ((c != CTRL_X) && (c != CTRL_D)) {
				c = getint();
				if ((c == CR) && (lf == CR)) fputc(LF, fp);
				if (c == CR) lf = CR;
				if (c == LF) lf = LF;
				if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
					fputc(c, fp);
				}
			}
			fclose(fp);
			break;

	    case MAL19_MSG:
			printf("\n");
			sprintf(s, "%s -bc TimeTravelAgency", RX);
			break;
	    case MAL20_MSG:
			printf("\n");
			sprintf(s, "%s -b", RB);
			break;
	    case MAL21_MSG:
			printf("\n");
			sprintf(s, "%s -b", RZ);
			break;
	}
	if (protokoll != MAL18_MSG){
		mkdir( pubdir, 0777 );
		chdir( pubdir );

		system( s );

		chdir( HOME );
		sprintf(s, "mv %s/* %s", pubdir, TEP);
		system( s );
		sprintf(s, "rm -r %s", pubdir);
		system( s );
	}
	sync();
	stat(TEP, &fst);
	if (fst.st_size < 3L) {
		printf("\n\n%s\n", MAL27_MSG);
		control(MAL28_MSG, 3);
		unlink(REP);	/* ??? */
		unlink(TEP);
		return -1;
	}	
	if (prf(TEP) == 1) {
		printf("\n\n");
		ansi( "md" );
		printf("%s", MAL25_MSG);		
		ansi( "me" );
		unlink(REP); 	/* ??? */
		unlink(TEP);
		return -1;
		BINFILE++;
	}
	else{
		mkix(TEP);
	}
  }

  ONCE_MORE:

  if((HOLD != 0) || ((WEITERLEITEN != 0) && (IS_BUFFERED != 0))) goto HOLD_MARK;

  printf("\n\n");
  ansi("mr");
  printf("[%s \"%s\"] %s, ? > ", MAL11_MSG, rec_char, MAL28aMSG);
  ansi("me");
  printf("%c%c", MAL29_MSG, BS);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if (c == '?') {
		clearline();
		ansi("mr");
		printf("%c%s > ", CR, MAL32_MSG);
		ansi("me");
	}
	if (c == ENTER) c = MAL29_MSG;
	if ((c != MAL29_MSG) && (c != MAL30_MSG) && (c != MAL31_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == MAL31_MSG) {		/* WEITERSCHREIBEN */
	sprintf(s, "%s %s", EDDY, TEP);
	noctrlx();
	system(s);
	ctrlx();
	goto ONCE_MORE;
  }
  if (c == MAL30_MSG) {		/* VERWERFEN */
	printf("\n");
	unlink(TEP);
	unlink(REP);
	return -1;
  }

  HOLD_MARK:
 

  if(UMLEITUNG == 0){
	if(WEITERLEITEN == 0){
		sprintf(s, "cp %s %s/usr/%d/.lastletter > /dev/null", TEP, HOME, USER.id);
		system( s );     
	}
	sprintf(s, "%s/usr/%d/.lastletter", HOME, USER.id);
	sprintf(s, "%s/usr/%d/.lastsubject", HOME, USER.id);
	fp = fopen( s, "w" );
	if(fp == NULL){
		nerror("mail.c", 500, "brief", "Datei-Schreibfehler", s);
	}
	fprintf(fp, "%s", subject);
	fclose(fp);
  }


  if (EX_PM == 0) {

	sprintf(s, "%s/usr/%d/seq", HOME, receiver);
	maybe_locked(s, "r");
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("mail.c", 431, "brief", "Datei-Lesefehler", s);
	}
	fscanf(fp, "%d", &mail_id);
	fclose(fp);
	fp = fopen(s, "w");
	fprintf(fp, "%d\n", (mail_id + 1));
	fclose(fp);

	sprintf(s, "%s/usr/%d/%d", HOME, receiver, mail_id);
  }
  else {
	umask(0000);
	sprintf(s, "%s/%d.expm", TMP, getpid());
  }


  fp = fopen(s, "w");

  if (EX_PM == 0) {
	sprintf(s, "%s %s (%s)\n", GBL01_MSG, USER.name, USER.nick);
	fputs(s, fp);

	time(&timer);
	timeptr = localtime(&timer);
	strcpy(t, asctime(timeptr));

	sprintf(s, "%s %s", GBL02_MSG, t);
	fputs(s, fp);

	sprintf(s, "%s %s\n\n\n", GBL03_MSG, subject);
	fputs(s, fp);

	lines = 5;
  }
   else {

	i = 0;
	strcpy(t, USER.name);
	while (t[i] != '\0') {
		if (t[i] == ' ') t[i] = '.';
		i++;
	}
	lines = 4;
  }


  ff = fopen(TEP, "r");
  if (ff == 0) {
	printf("\n\n");
	ansi("md");
	printf("%s\n", MAL33_MSG);
	ansi("me");
	control(MAL34_MSG, 3);
	return;
  }
  if(EX_PM != 0){

	time(&timer);

	i = 0; j = 0;
	while(from[i] != '\0'){
		if(from[i] == '<'){
			strcpy(s, (char *) strcopy(from, 0, (i-1)));
			j = i;
		}
		if(from[i] == '(') j = i+1;
		if(from[i] == ')') strcpy(s, (char *) strcopy(from, j, (i-1)));
		i++;
	}
	if(j == 0) strcpy(s, from);
	
	fprintf(fp, "From: %s@%s (%s)\n", t, UUCPID, USER.name); 
	fprintf(fp, "Reply-To: %s <%s@%s>\n", USER.name, t, UUCPID);
	fprintf(fp, "Organization: %s\n", ORGANIZATION);
	if(mesg_id[0] != '\0'){
		fprintf(fp, "In-Reply-To: %s; ", (char *) stripped(mesg_id)); 
		fprintf(fp, "from \"%s\" at %s", s, date);
		if(refs[0] != '\0') 
			sprintf(s, "%s ", stripped(refs));
		else
			s[0] = '\0';
		strcat(s, mesg_id);
		fprintf(fp, "References: %s", s);
	}
        fprintf(fp, "To: %s\n", rec_char);
	fprintf(fp, "Subject: %s\n", subject);
	fprintf(fp, "X-Mailer: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);	
   	fprintf(fp, "Message-Id: <%x.%d@%s>\n", timer, USER.id, UUCPID);
 	fputs("\n", fp);
  }
  while (fgets(s, 80, ff) != 0) {
	fputs(s, fp);
	lines++;
  }
  fclose(ff);

  if(UMLEITUNG == 0){
	  sprintf(s, "%s/usr/%d/.signature", HOME, USER.id);
	  ff = fopen(s, "r");
	  if (ff != NULL) {
		while (fgets(s, 80, ff) != 0) {
			fputs(s, fp);
			lines++;
		}
		fclose(ff);
	  }
  }

  if(WEITERLEITEN == 0) unlink(TEP);
  fclose(fp);

  if (EX_PM == 0) {
	sprintf(s, "%s/usr/%d/INDEX", HOME, receiver);
	maybe_locked(s, "r"); 
	fp = fopen(s, "a");
	if (fp == NULL) {
		nerror("mail.c", 527, "brief", "Datei-Ergaenzungsfehler", s);
	}
	sprintf(s, "%d              ", mail_id);
	s[6] = '\0';
	if(HOLD != 0){
		s[5] = '>';
	}
	fputs(s, fp);

	sprintf(ex, "%s                                ", subject);
	ex[26] = '\0';
	fputs(ex, fp);

	sprintf(ex, "  %s                                        ", USER.name);
	ex[22] = '\0';
	fputs(ex, fp);

	strcpy(s, (char *) mydate(1));
	strcpy(t, (char *) mytime(1));
	sprintf(ex, "  %s  %s         ", s, t);
	ex[19] = '\0';
	fputs(ex, fp);

	sprintf(s, "%-6.d\n", lines);
	fputs(s, fp);

	fclose(fp);

  }
  else {
	sprintf(s, " X-Mail via UUCP (%s) ", rec_char);
	headline(s);
	printf("\n%s", MAL35_MSG);
	sprintf(s, "%s/%d.expm", TMP, getpid());
	sprintf(t, "/bin/sh ./etc/rmail.sh %s %s", s, rec_char);
	system(t);
	unlink(s);
	unlink(f);
	umask(0007);
	printf(" %s\n", MAL36_MSG);
  }

  unlink(REP);
  unlink(TEP);

  sprintf(s, "%s \"%s\" %s", MAL11_MSG, rec_char, MAL37_MSG);
  control(s, 3);

  printf("\n");

  return 0;
}




/***************************************************************************/
/*      FUNKTION  ansage()						   */
/*  BESCHREIBUNG  Der Ansage-Text wird angezeigt und kann geandert werden. */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void ansage()
{
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char c;


  printf("\n\n%s\n\n", MAL38_MSG);

  sprintf(TEP, "%s/usr/%d/.hello", HOME, USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi("md");
	while (fgets(s, 80, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi("me");
	printf("\n\n");
  }
  ansi("mr");
  printf("%c%s [%c, %c] > ", CR, MAL39_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c == GBL06_MSG) {
	sprintf(t, "%s %s", EDDY, TEP);
	system(t);
  }
  printf("\n");
}




/***************************************************************************/
/*      FUNKTION  unterschrift						   */
/*  BESCHREIBUNG  Die Unterschrift (.signature) wird angezeigt und kann    */
/*		  geandert werden.                                         */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine	                                                   */
/***************************************************************************/

void unterschrift()
{
  FILE *ff;
  char s[STRING];
  char t[STRING];
  char TEP[STRING];
  char c;


  printf("\n\n%s\n\n", MAL40_MSG);

  sprintf(TEP, "%s/usr/%d/.signature", HOME, USER.id);
  ff = fopen(TEP, "r");
  if (ff != NULL) {
	ansi("md");
	while (fgets(s, 80, ff) != NULL) {
		printf("%s", s);
	}
	fclose(ff);
	ansi("me");
	printf("\n\n");
  }
  ansi("mr");
  printf("%c%s [%c, %c] > ", CR, MAL41_MSG, GBL06_MSG, GBL07_MSG);
  ansi("me");

  c = yesno();

  if (c == GBL06_MSG) {
	sprintf(t, "%s %s", EDDY, TEP);
	system(t);
  }
  printf("\n");
}
