/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  loop.c						   */
/*        FUNKTIONEN  sigcatch(), cut_bef(), cut_arg(), rates(), loop()	   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  08.12.1991					   */
/***************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <time.h>
#include <setjmp.h>
#include <signal.h>
#include <sys/stat.h>

#include "mbox.h"



extern time_t time_start, time_now;

jmp_buf jmpenv;



/***************************************************************************/
/*      FUNKTION  sigcatch()						   */
/*  BESCHREIBUNG  Wird aufgerufen, wenn eines der abgefangen Signale	   */
/*		  eintrifft. Je nach Signal wird entweder ein CTRL-X       */
/*		  simuliert, oder das Programm ordnungsgemaesst beendet.   */
/*     PARAMETER  sig  =  Nummer des ausloesenden Signals                  */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void sigcatch(sig)
int sig;
{
  char tmp[80];  

  signal(SIGINT,   SIG_IGN);
  signal(SIGQUIT,  SIG_IGN);
  signal(SIGHUP,   SIG_IGN);
  signal(SIGABRT,  SIG_IGN);
  signal(SIGTERM,  SIG_IGN);
 
  switch (sig) {
	case SIGINT:
	case SIGQUIT:
		sprintf(tmp, "%s/I.%d", TMP, getpid());
		unlink(tmp);
		sprintf(tmp, "%s/show%d", TMP, getpid());
		unlink(tmp);
		unlockf( UDBASE );
		printf("\n");
		ansi("mr");
		printf("%s", LOP01_MSG);
		ansi("me");
		printf("\n\n");
		longjmp(jmpenv, 1);
		break;
      case SIGHUP:
      case SIGABRT:
      case SIGTERM:
		printf("\n\n");
		ansi("mr");
		printf("%s", LOP02_MSG);
		ansi("me");
		printf("");
		logout();
		exit(-1);
		break;
  }
}




/***************************************************************************/
/*      FUNKTION  cut_bef()						   */
/*  BESCHREIBUNG  Filtert den Befehl aus der Eingabe eines Users.          */
/*     PARAMETER  Eingabezeile                                             */
/*     RUECKGABE  Der isolierte Befehl                                     */
/***************************************************************************/

char *cut_bef(s)
char s[];
{
  char bef[STRING];
  int i = 0;

  while (s[i] > 32) {
	bef[i] = s[i];
	i++;
  }
  bef[i] = '\0';
  return (char *) bef;
}



/***************************************************************************/
/*      FUNKTION  cut_arg()						   */
/*  BESCHREIBUNG  Filtert das Argument aus der Eingabe des Users.          */
/*     PARAMETER  Eingabezeile 	                                           */
/*     RUECKGABE  Das isolierte Argument                                   */
/***************************************************************************/

char *cut_arg(s)
char s[];
{
  char arg[STRING];
  int i = 0, a = 0;

  while (s[i] > 32) i++;
  if (s[i] == '\0') return (char *) '\0';

  while (s[i] == 32) i++;

  while (s[i] != '\0') {
	arg[a] = s[i];
	i++;
	a++;
  }
  arg[a] = '\0';

  while((arg[(a-1)] < 33) && (a > 1)){
	a--;
	arg[a] = '\0';
  }

  return (char *) arg;
}




/***************************************************************************/
/*      FUNKTION  rates()						   */
/*  BESCHREIBUNG  Ermittelt die Telefongebuehren des laufenden Anrufs und  */
/*		  bereitet sie als PROMPT auf.                             */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  PROMPT-Zeile fuer Gebuehren                              */
/***************************************************************************/

char *rates()
{
  char s[STRING];
  char t[STRING];
  int nz, rz, wz;
  int dif;
  int n1, n2, r1, r2, w1, w2;
  struct tm *timeptr;

  time(&time_now);
  dif = time_now - time_start;

  n1 = dif / NZNT;
  n1++;
  n1 *= TARIF;
  n2 = dif / NZBT;
  n2++;
  n2 *= TARIF;
  r1 = dif / RZNT;
  r1++;
  r1 *= TARIF;
  r2 = dif / RZBT;
  r2++;
  r2 *= TARIF;
  w1 = dif / WZNT;
  w1++;
  w1 *= TARIF;
  w2 = dif / WZBT;
  w2++;
  w2 *= TARIF;

  timeptr = localtime(&time_now);
  sprintf(t, "%s", asctime(timeptr));

  if ((t[0] == 'S') || (timeptr->tm_hour > 18) || (timeptr->tm_hour < 8)) {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n2), flt(n2), fix(r2), flt(r2), fix(w2), flt(w2));
  }
  else {
	sprintf(s, "(%ds) NZ %d.%02.2d, RZ %d.%02.2d, WZ %d.%02.2d",
	 dif, fix(n1), flt(n1), fix(r1), flt(r1), fix(w1), flt(w1));
  }

  return (char *) s;
}




/***************************************************************************/
/*      FUNKTION  loop.c						   */
/*  BESCHREIBUNG  Die Eingaben des Users werden entgegengenommen und die   */
/*		  entsprechenden Routinen aufgerufen und ausgefuehrt.      */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  keine                                                    */
/***************************************************************************/

void loop()
{
  char s[STRING];
  char t[STRING];
  char befehl[STRING];
  char argument[STRING];
  char prompt[STRING];

  char prev_befehl[10][STRING];
  int wasok;

  char c;

  char bef_buff[(STRING * 2)];
  int bef_rec;

  int ende = 0, ok, dummy, i;
  int pp;
  int to_del;

  struct stat fst;


  sprintf(prev_befehl[1], "%s ", BEF[BB1].befehl);
  sprintf(prev_befehl[2], "%s ", BEF[BB2].befehl); 
  sprintf(prev_befehl[3], "%s ", BEF[BB3].befehl);
  sprintf(prev_befehl[4], "%s ", BEF[BB4].befehl);
  sprintf(prev_befehl[5], "%s ", BEF[BB5].befehl);
  sprintf(prev_befehl[6], "%s ", BEF[BB6].befehl);
  sprintf(prev_befehl[7], "%s ", BEF[BB7].befehl);
  sprintf(prev_befehl[8], "%s ", BEF[BB8].befehl);
  sprintf(prev_befehl[9], "%s ", BEF[BB9].befehl);

  wasok = 1;

  bef_buff[0] = '\0';

  do {

	if(setjmp(jmpenv) == 1){
		bef_buff[0] = '\0';
	}

	FASTER:
	
	signal(SIGINT,  sigcatch);
	signal(SIGQUIT, sigcatch);

	signal(SIGHUP,  sigcatch);
	signal(SIGABRT, sigcatch);
	signal(SIGTERM, sigcatch);


	sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
	stat(s, &fst);
	if(fst.st_size > IDX_SIZE){
		printf("%c\n\n%s\n", BELL, LOP03_MSG); 
	}
        IDX_SIZE = (long) fst.st_size;

	if(bef_buff[0] != '\0'){
		sprintf(s, "%s", bef_buff);		
		IS_BUFFERED = 1;
		bef_rec++;
		goto BUFFERING;
	}
        else 
		IS_BUFFERED = 0;


	bef_rec = 0;

	ansi("md");
	prompt[0] = '\0';

	switch (USER.prompt) {
	    case 1:
			strcat(prompt, (char *) mytime(0));
			break;
	    case 2:	
			strcat(prompt, NG);
			break;
	    case 3:	
			strcat(prompt, (char *) rates());
			break;
	}
	printf("\n[%s] %s > ", prompt, LOP06_MSG);
	ansi("me");
	if (USER.bell == 1) printf("%c", BELL);

	befehl[0] = '\0';

#ifdef _CORELEFT
	if(coreleft() < _CORELEFT){
		sprintf(s, "%d", _CORELEFT);
		nerror( "loop.c", 288, "loop", "Speicherplatz kleiner ", s );
	}
#endif


	do {
		strcpy(s, (char *) getline(60, 11001, 32, befehl));
		to_del = length(befehl);

		if (s[0] == 48) {
			headline( LOP05_MSG );
			printf("\n");
			for (i = 9; i > 0; i--) {
				printf(" %d: %s\n", i, prev_befehl[i]);
			}
			goto FASTER;
		}
		if ((s[0] > 48) && (s[0] < 58)) {
			sprintf(befehl, "%s", prev_befehl[(s[0] - 48)]);
			printf("%c", CR);
			if (ansi("ce") == 1) {
				printf("                                                               ");
			}
			ansi("md");
			printf("%c[%s] %s > ", CR, prompt, LOP06_MSG);
			ansi("me");
		}
	} while ((s[0] > 47) && (s[0] < 58));

	
        if(makro_definition(s) != 0) goto FASTER;


	BUFFERING:

	if((bef_rec > MAKRO_MAX_REK) && (USER.level < (ADMIN_LEV+1))){
		bef_buff[0] = '\0';
		goto FASTER;
	}

        
	strcpy(t, (char *) makro(s));
	strcpy(s, t); 
        
	while ((s[0] == 32) || (s[0] == '.')) {
		sprintf(befehl, "%s", (char *) strcopy(s, 1, length(s)));
		sprintf(s, "%s", befehl);
	}

	i = 0; ok = 0;
	while((ok == 0) && (s[i] != '\0')){
		if(s[i] == ','){ 
			strcpy(bef_buff, (char *) strcopy(s, (i+1), length(s)));
			s[i] = '\0';
			ok++;
		}			
		i++;
	}
	if(ok == 0) bef_buff[0] = '\0';
	
	strcpy(befehl, (char *) cut_bef(s));
	strcpy(argument, (char *) cut_arg(s));
	strcpy(s, (char *) upcased(befehl));
	strcpy(befehl, s);

	sprintf(s, "%s %s", befehl, argument);

	if (wasok == 1) {
		ok = 0;
		for (i = 9; i > 0; i--) {
			if ((strcomp(s, prev_befehl[i]) == 0) && (strcomp(prev_befehl[i], s) == 0))
				ok++;
		}
		if ((ok == 0) && (befehl[0] > 32)) {
			for (i = 9; i > 1; i--) {
				sprintf(prev_befehl[i], "%s", prev_befehl[(i - 1)]);
			}
			sprintf(prev_befehl[1], "%s %s", befehl, argument);
		}
	}
	else {
		sprintf(prev_befehl[1], "%s %s", befehl, argument);
	}

	sprintf(s, "[%s] %s %s", LOP04_MSG, befehl, argument);
	control(s, 3);

	sprintf(s, "%s %s", befehl, argument);
	whodo(s);


	wasok = 0;

	if (befehl[0] == '"') {
		ansi("md");
		/*
		printf(" <- Nein, so daemlich kann kein User sein !\n");
		*/
		printf(" %s\n", LOP07_MSG);
		ansi("me");
		goto FASTER;
	}
	if (befehl[0] == '\0') goto FASTER;


	if(argument[0] == '?') {
		strcpy(argument, befehl);
		strcpy(befehl, BEF[BB7].befehl);
 	}

/*  ?  */

	if (befehl[0] == '?') {
		if (argument[0] != '*') {
			sprintf(s, " %s %d) ", LOP08_MSG, USER.level);
		} else {
			sprintf(s, " %s ", LOP09_MSG, USER.level);
		}
		headline(s);
		printf("\n");
		bef("?", argument);
		goto FASTER;
	}

/* <BREAK> */

	if (strcomp(befehl, "<BREAK>") == 0) {
		printf("!@#?");
		ansi("md");
		printf(" %s", LOP10_MSG);
		ansi("me");
		printf("\n");
		goto FASTER;
	}
	wasok = 1;


	switch (bef(befehl, argument)) {

	    case 275:		/* RELOGIN */

		logout();
		intro();
		break;


	    case 240:		/* MINIX */

		if (argument[0] == '\0') {
			ansi("md");
			printf(" %s\n", LOP11_MSG);
			ansi("me");
		}
		else {
			printf("\n\n");
			sprintf(s, "exec %s %s %d %d", RSH, argument, OLDUID, OLDGID);
			system(s);
		}
		break;


	    case 110:
	    case 120:		/* + -  */

		scanner(befehl[0]);
		break;


	    case 190:		/* HILFE */

		printf("\n\n");
		if (argument[0] < 33)
			help("=");
		else {
			if(argument[0] == '*'){	
				help("*");
			}
			else{
				strcpy(s, "#");
				strcat(s, upcased(argument));
				if (help(s) < 1) {
					ansi("md");
					printf("%s \"%s\" %s\n", LOP12_MSG, argument, LOP13_MSG);
					ansi("me");
				}
			}
		}
		break;


	    case 150:		/* BRETT */

		brett(argument);
		break;


	    case 130:		/* ANRUFER */

		if(argument[0] == '#'){
			statistik();
			break;
		}

		headline( LOP14_MSG );
		printf("%s\n", LOP15_MSG);
		printf("===============================================================================\n");

		if (argument[0] != '*') {
			show(CALLS, 19, USER.more);
		}
		else {
			show(CALLS, 9999, USER.more + 100);
		}
		break;


	    case 200:		/* INHALT */

		inhalt2(argument, "I");
		break;


	    case 210:		/* LESEN */

		dummy = (pruefe(argument));
		if (dummy == 0) lesen(argument);
		if (dummy == -1) lesen2(argument, 'L');
		break;



	    case 230:		/* SCHREIBEN */

		if (USER.level < WRITE_IN_LEV) {
			ansi("md");
			printf(" %s\n", LOP16_MSG);
			ansi("me");
		}
		else
			schreiben(argument);
		break;


	    case 220:		/* LOESCHEN */

		dummy = (pruefe(argument));
		if (dummy == 0) loeschen(argument);
		if (dummy == -1) loeschen2(argument, 'D');
		break;


	    case 160:		/* BRIEF */

		if (USER.level < WRITE_IN_LEV) {
			ansi("md");
			printf(" %s\n", LOP16_MSG);
			ansi("me");
		}
		else
			if((brief(argument) == 0) && (strcomp(GUEST, USER.name) != 0)){
				sprintf(s, "%s?", USER.name);
				brief(s);
				sprintf(s, "%s/usr/%d/INDEX", HOME, USER.id);
				stat(s, &fst);
			        IDX_SIZE = (int) fst.st_size;
			}
			else bef_buff[0] = '\0';
		break;


	    case 170:		/* CHAT */

		sprintf(s, "exec %s %s \"%s\" %d %d", RSH, CHAT, USER.nick, OLDUID, OLDGID);
		system(s);
		break;


	    case 250:		/* PM */

		strcpy(BRETT, "PM");
		printf("\n");
		sprintf(NG, "%s.PM", USER.name);
		sprintf(INHALT, "%s/usr/%d/INDEX", HOME, USER.id);
		break;


	    case 260:		/* POSTFACH */

		postfach("*");
		break;


	    case 300:		/* USER */

		userliste(argument);
		break;


	    case 140:		/* ANSAGE */

		ansage();
		break;


	    case 310:		/* UNTERSCHRIFT */

		unterschrift();
		break;


	    case 320:		/* VERSION */

		printf("\n\n");
		ansi("md");
		printf("Version: ");
		ansi("me");
		printf("%s %s %s\n", VERSION, PATCHLEVEL, AUTOR);

		if(argument[0] == '#'){
			ansi("md");
			printf("\nMein spezieller Dank gilt folgenden Mitarbeitern, Beta-Testern und Ratgebern: \n\n");
			ansi("me");
			
			printf("andreas@xenox.ruhr.de       - fuer den \"NewsFeed\" und seine Geduld\n");
			printf("                              bei unseren \"Sonderwuenschen\"\n\n");

			printf("az@unnet.w.open.de          - fuer seinen Einsatz beim \"Einrichten\"\n");
			printf("                              der Mailbox und der PD-Portierung\n\n");

			printf("joergg@unnet.ruhr.sub.org   - fuer seine Ideen, Tips, konstruktive\n");
			printf("                              Kritik und gruendliche Tests\n\n");		

			printf("klausr@skylink.ruhr.sub.org - fuer viele Vorschlaege, und vor allem\n");			
			printf("                              fuer seine praesizen Fehlerbeschreibungen\n\n");			

			printf("stefans@coduck.ruhr.sub.org - fuer seine Hilfe bei der Installation\n");
			printf("                              der 386er Patches und der PD-Beschaffung\n\n");

			printf("walterb@weller.ruhr.sub.org - fuer seine Unterstuetzung bei der Portierung auf\n");
			printf("                              UNIX SVR3 und bei der Installation\n\n");

			printf("hergo@ivcmd.boerde.de       - fuer seine Hilfe bei der Bildung einer Referenz-\n");
			printf("                              Version zur Verwendung von CDIFFs\n\n");
			
		}
		
		if(argument[0] == '*'){
			ansi("md");
			printf("\n%s ", LOP17_MSG);
			ansi("me");
#ifdef _SYS7
			printf("-D_SYS7 ");
#endif
#ifdef _MBOX
			printf("-D_MBOX ");
#endif
#ifdef _MINIX
			printf("-D_MINIX ");
#endif
#ifdef _ESTDIO
			printf("-D_ESTDIO ");
#endif
#ifdef _CORELEFT
			printf("-D_CORELEFT ");
#endif
#ifdef _DATESTAMP
			printf("-D _DATESTAMP ");
#endif

			printf("\n");
		}

		break;


	    case 270:		/* PORTINFO */

		port( argument );
		break;


	    case 280:		/* SETUP */

		sprintf(s, "%s", NG);
		sprintf(t, "%s", BRETT);
		setup();
		if (strcomp("PM", t) != 0) brett(s);
		break;


	    case 125:		/* ADMIN */

		sprintf(s, "%s", NG);
		sprintf(t, "%s", BRETT);
		admin();
		if (strcomp("PM", t) != 0) brett(s);
		break;


	    case 205:		/* ID */

		if(strcomp("-c", argument) == 0){ /* Memory fault - core dumped */
			printf("\n\nDebug-Modus: ");
			fclose(0);   
		}

		printf("\n\n>>> %s (UID %d|%d|%d) (GID %d|%d|%d)\n", MYNAME,
		       getuid(), geteuid(), OLDUID,
		       getgid(), getegid(), OLDGID);
		break;

	    case 215:		/* LEVEL */

		show_level();
		break;

	    case 290:		/* STATUS */

		status();
		break;

	    case 330: 		/* MAKRO */

		set_makros();
		break;

	    case 340:		/* WEITERLEITEN */

		weiterleiten( argument );
		break;

	    case 350:           /* SLEEP */

		dummy = atoi( argument );
		if(dummy < 1) dummy = 1;
		sleep( dummy );
		break;		

	    case 360:		/* KEYPRESSED */

		printf("\n");
		ansi("mr");
		printf(" Taste ! ");
		ansi("me");
		dummy = getint();
		if((dummy == CTRL_X) || (dummy == 'x') || (dummy == 'q')){
			bef_buff[0] = '\0';
			printf("\n");
		}
		break;

	    case 370:		/* DATUM */
		
		ansi("md");
		printf("\n\n%s ", LOP18_MSG);
		ansi("me"); 
		printf("%s, ", (char *) mydate( 2 ));
		printf("%s\n",  (char *) mydate( 0 ));
		break;
	
	    case 380:		/* ZEIT */

		ansi("md");
		printf("\n\n%s ", LOP19_MSG);
		ansi("me");
		printf("%s\n", (char *) mytime( 0 ));
		ansi("md");
		printf("Online: ");
		ansi("me");
		time(&time_now);
		printf("%d %s\n",  (int) time_now - time_start, LOP20_MSG);
		break;

	   case 390:		/* SPIELE */

		games();
		break;
	
	    case 400:		/* RICHTUNG */

		ansi("md");
		printf("\n\n%s ", LOP21_MSG);
		ansi("me");

		if (USER.leserichtung == 1) {
			USER.leserichtung = 2;
			printf("%s\n", LOP22_MSG);
		}
		else {
			USER.leserichtung = 1;
			printf("%s\n", LOP22aMSG);
		}
		break;

	    case 410:           /* STATISTIK */

		if ((argument[0] != '#') && (argument[0] != '$')) {
			headline( LOP23_MSG );
			printf("%s\n", LOP24_MSG);
			printf("===============================================================================\n");

			if (argument[0] != '*') {
				show(MB_DLOG, 19, USER.more);
			}
			else {
				show(MB_DLOG, 9999, USER.more + 100);
			}
		}
		if(argument[0] == '$') {
			headline( LOP25_MSG );
			show(UUCPCOSTS, 9999, USER.more);
		}
   		if(argument[0] == '#') {
			headline( LOP26_MSG );
			printf("%s\n", LOP27_MSG);
			printf("===============================================================================\n");

			show(PDLOG, 9999, USER.more + 100);
		}

		break;
 

	    case 420:		/* RING */

		ende = 1;
		break;
	       	

	    case 180:		/* ENDE */

#ifdef _MINIX
		if (tty() >= FIRST_EX_TTY) {
			printf("\n\n");
			ansi("mr");
			printf("%c%s [%c, %c] > ", CR, LOP28_MSG, GBL06_MSG, GBL07_MSG);
			ansi("me");
			
			c = yesno();
		} else
#endif
			c = GBL06_MSG;


		if (c == GBL06_MSG)
			ende = 1;
		else
			printf("\n");

		if(argument[0] == '*'){
			USER.lasttime = LASTTIME;
			strcpy(USER.lastlog, (char *) datereconv( LASTLOG ));
		}
		else{
			strcpy(s, (char *) mydate(0));
			s[10] = '\0';
			strcpy(USER.lastlog, s);
			strcpy(s, (char *) mytime(1));
			USER.lasttime = timeconv(s);
		}

		break;

	    case -1:		/* LEVEL ??? */

		wasok = 0;
		ansi("md");
		printf(" %s %d ...\n", LOP30_MSG, USER.level);
		ansi("me");
		break;

	    default:

		wasok = 0;
		ansi("md");
		printf(" %s\n", LOP31_MSG);
		ansi("me");
	}

  } while (ende == 0);
}
