/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  getline.c						   */
/*        FUNKTIONEN  getline(), getint(), yesno()			   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  08.12.1991					   */
/***************************************************************************/

#include <stdio.h>

#ifdef _MBOX
#include "mbox.h"
#else
#define BS	8
#define CR	13
#define LF	10
#define CTRL_X	24
#define CTRL_D	4
#define BELL	7
#define ESC	27
#define DEL	127
#include "mbox.msg"
#ifdef _SYS7
#define ENTER	13
#else
#define ENTER 	10
#endif
#endif

#ifndef STRING
#define STRING 85
#endif

/***************************************************************************/
/*      FUNKTION  getline()						   */
/*  BESCHREIBUNG  Eine Zeile (STRING) einlesen. Beendet wird mit ENTER,	   */
/*		  oder wenn die max. zulaessige Anzahl von Zeichen er-     */
/*		  reicht ist.	                                           */
/*     PARAMETER  siehe unten                                              */
/*     RUECKGABE  Eingelesene Zeile (STRING)				   */
/*  ---------------------------------------------------------------------  */
/*  len     -> Anzahl der max. einzulesenden Zeichen     		   */
/*									   */
/*  mode    ->       0 = Kein Echo					   */
/*	   	     1 = Mit Echo				           */
/*       	     2 = '*' als Echo				           */
/*		     3 = ':' als drittes & sechstes Zeichen (Uhrzeit)      */
/*	             4 = '.' als drittes & sechstes Zeichen (Datum)        */
/*		    10 = "bsc" vor der Eingabe "len"-mal ausgeben          */
/*		   100 = nur Zahlen (und '.', ':')                         */
/*	 	  1000 = String "deftext" + "bsc" ausgeben                 */
/*		 10000 = bei "0-9" als erstes Zeichen -> sofort zurueck    */
/*								           */
/*  bsc     -> Mit diesem Zeichen wird geloescht			   */
/*								           */
/*  deftext -> Text-Vorgabe                                                */
/*			                                                   */
/***************************************************************************/

static int endless;

char *getline(len, mode, bsc, deftext)
int len, mode;
char bsc;
char deftext[];
{
  char gls[STRING];
  char c;
  int gli, gll;
  char delim = '\0';
  int matrix = 0;
  int echo = 1, numerics = 0, defmode = 0;
  int escape = 0;
  int lenmem = len;


#ifndef _SYS7 || _ESTDIO
  setbuf(stdout, NULL);
#endif


  if (mode > 10000) {
	escape++;
	mode -= 10000;
  }
  if (mode > 1000) {
	mode -= 1000;
	defmode++;
  }
  if (mode > 100) {
	mode -= 100;
	numerics++;
  }
  if (mode > 10) {
	mode -= 10;
	matrix++;
  }
  if (mode > 2) {
	if (mode == 3)
		delim = ':';
	else
		delim = '.';
	mode = 1;
  }
  echo = mode;

  if (defmode != 0) {
	if((deftext[0] < 32) || (deftext[0] > 126)) deftext[0] = '\0';
	gll = length(deftext);
	lenmem = len - gll;
	if(deftext[0] != '\0'){
		sprintf(gls, "%s", deftext);
		printf("%s", deftext);
	}
	else gls[0] = '\0';
  }
  else {
	gll = 0;
	gls[gll] = '\0';
	strcat(gls, "OOPS");
  }

  if (matrix != 0) {
	for (gli = 0; gli < lenmem; gli++) {
		if (((gli == 2) || (gli == 5)) && (delim != '\0') && (gli != len)) {
			printf("%c", delim);
		}
		else {
			printf("%c", bsc);
		}
	}
	for (gli = 0; gli < lenmem; gli++) printf("%c", BS);
  }

  do {

	if (delim != '\0') {
		if (((gll == 2) || (gll == 5)) && (gll < len)){
			c = delim;
		}
		else {
			c = getint();  
		}
	}
	else {
		c = getint();  
	}        
	if (c > 127) c -= 128;	/* 7 BIT !! */

	if (c == ESC) {
		c = getint();  
		c = getint();  
		if ((c == 'A') || (c == 'B')) {
			if (c == 'A') endless++;
			if (c == 'B') endless--;
			if (endless < 1) endless = 9;
			if (endless > 9) endless = 1;
			sprintf(gls, "%d", endless);
			return (char *) gls;
		}
		if (c == 'D') c = BS;
		if (c == 'C') c = ENTER;
	}
	if ((c == CTRL_X) || (c == CTRL_D) || (c == DEL)) {
		return("<BREAK>");
	}
	if (c != ENTER) {
		if ((c == BS) && (gll > 0)) {
			if (((gll == 3) || (gll == 6)) && (delim != '\0')) {
				gll -= 2;
				printf("%c%c%c%c", BS, BS, bsc, BS);
			} else {
				gll--;
				printf("%c%c%c", BS, bsc, BS);
			}
		}
		if (numerics == 0) {
			if (c >= 32) {
				gls[gll] = c;
				gll++;
			}
			else {
				c = 0;
			}
		}
		else {
			if ((c == '.') || (c == ':') || ((c >= '0') && (c <= '9'))) {
				if (((delim != '\0') && ((c == '.') || (c == ':'))) &&
				    ((gll != 2) && (gll != 5))) {
					printf("%c", BELL);
					c = 0;
				}
				else {
					gls[gll] = c;
					gll++;
					gls[gll] = '\0';
				}
			}
			else {
				if (c != BS) printf("%c", BELL);
				c = 0;
			}
		}
		if (c != 0) {
			if (echo == 1) printf("%c", c);
			if (echo == 2) printf("*");
		}
	}
	if (gll == 1) {
		if ((escape != 0) && ((c > 47) && (c < 58))) {
			gls[gll] = '\0';
			return (char *) gls;
		}
	}

  } while ((c != ENTER) && (gll < len));

  gls[gll] = '\0';

  return (char *) gls;
}





/***************************************************************************/
/*      FUNKTION  getint() 						   */
/*  BESCHREIBUNG  Ein Zeichen wird mit Hilfe der "getch"-Funktion einge-   */
/*		  lesen. Es wird gewartet bis ein Zeichen erfasst ist.     */
/*     PARAMETER  keine                                                    */
/*     RUECKGABE  Eingelesenes Zeichen (INT)				   */
/***************************************************************************/

int getint()
{
  int c;

  do{
	c = (int)getch();
  }while((c == 0) || (c > 127));

  return (int) c;
}




/***************************************************************************/
/*      FUNKTION  yesno()						   */
/*  BESCHREIBUNG  Die Zeichen "j", "J", "n" oder "N" werden ausschliess-   */
/*		  lich eingelesen und zurueckgegeben.	                   */
/*     PARAMETER  keine	                                                   */
/*     RUECKGABE  Eines der Zeichen (siehe oben) (INT)			   */
/***************************************************************************/

int yesno()
{
  int c;

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GBL06_MSG) && (c != GBL07_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  return (int) c;
}

