/*
 *	%Z% %M%	%I% %D% %Q%
 *
 *	Copyright (C) 1990 by Christian Schlichtherle
 *			      (chriss@attron.ruhr.sub.org)
 *
 *	%M% - C module for getch(S).
 *
 *	"getch" is a DOS and curses(S) like function which reads
 *	a character and returns immediately without waiting for
 *	newline.
 *
 *
 *      MINIX-Version (this one) (!(c)) 4/1991
 *			by Volker Schuermann	
 *      		   (volkers@unnet.ruhr.sub.org)
 *
 *
 */


#if	!defined(lint) && !defined(library)
static char	sccsid[] = "%Z% %M% %I% %D% %Q%";
#endif /* not lint and not library */

#include <sys/types.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sgtty.h>


/*
 * getch - Gets a character.
 * This function gets one character and immediately returns
 * without waiting for newline. The character is not echoed.
 * This function can be used best when you want to input only one
 * character within canonical input or if you need this function
 * only very rarely.
 * EOF is returned on errors or if an ignored signal occured.
 */
int	getch()
{
	static struct sgttyb	told, tnew;
	static int	set = 0;
	int	rstat;
	char	c;

	if (!set) {
			/* Get old terminal mode. */

			ioctl( 0, TIOCGETP, &told );


		/*
		 * Set new terminal mode. Switch off
		 * canonical input and echoing.
		 */
		tnew = told;

		tnew.sg_flags |= RAW;
		tnew.sg_flags &= ~ECHO;

			/* Don't execute this part anymore. */
		set = 1;
	}

		/* Set new terminal mode. */
	ioctl(0, TIOCSETP, &tnew);

		/* Read one character. */
	rstat = read(0, &c, 1);

		/* Reset old terminal mode.
		   Don't get disturbed by ignored signals. */
	while (ioctl(0, TIOCSETP, &told) == -1)
		if (errno != EINTR)
			return (EOF);  

	if (rstat != 1)
		return (EOF);
	return((int)c);
}



