/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  dummy_nerror.c					   */
/*        FUNKTIONEN  nerror						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.11.1991					   */
/***************************************************************************/

#include <stdio.h>

#include "defs.h"
#include "mbox.msg"

/***************************************************************************/
/*      FUNKTION  nerror()						   */
/*  BESCHREIBUNG  Zeigt Systemfehler (Dateien koennen nicht gefunden o.    */
/*		  geoeffnet werden, etc.) an. Anschliessend wie die        */
/*		  Befehlseingabe aufgerufen.                               */
/*			                                                   */
/*		  ACHTUNG: Nach "nerror()" laeuft die MBox zwar weiter,    */
/*		  aber beim Terminieren wird ein "core" ausgegeben.        */
/*     PARAMETER  file     = Datei in der der Fehler aufgetreten ist	   */
/*		  line     = Zeile in der Datei                            */
/*		  function = Funktion in der Datei                         */
/*		  descr    = Fehlerbeschreibung	                           */
/*		  er       = Datei/Variable                                */
/*     RUECKGABE  keine 						   */
/***************************************************************************/

void nerror(file, line, function, descr, er)
char file[];
int line;
char function[], descr[], er[];
{
  char s[80];

  printf("%c%s %s (%s) - %s \"%s\"\n", CR, DER01_MSG, function, file, descr, er);

  sprintf(s, "[%s] %s, %d\n***** %s, %s, %s ... %s !!!",
	DER02_MSG, file, line, function, descr, er, DER03_MSG);
  
}


