/* scanner for a PIC Assembler language */

%{

#include <ctype.h>
#include "symbol.h"
#include "expr.h"
#include "asmpar.tab.h"

int dec2i(char *decstr)
{
	int loop;
	int total = 0;

	for(loop = 0; loop<strlen(decstr); loop++)
	{
		total *= 10;
		total += decstr[loop] - '0';
	}

	return total;
}


int	line_number;
char	current_file[40];

extern  int current_level; /* current scope i.e. how many blocks deep we are */
extern SYMBOL *lookupsymbol();
extern int yyerror();

%}

%%

[0-9]+			{
				yylval.integer = dec2i(yytext);
				return NUM;
			}

"org"			{ return ORG; }
"begin"			{ return BLOCK; }
"end"			{ return END; }
"data"			{ return DATA; }
"error"			{ return ERROR; }
"warn"			{ return WARN; }

"equ"|"="		{ return ASSIGN; }

":"			{ return COLON; }

[a-z_][a-z0-9_]*	{
				SYMBOL *ptr;

				strcpy(yylval.string, yytext);

				return ID;
			}

-->[^\ \n]+		{	/* embedded finename */
				strcpy(current_file, yytext+3);
			}

\#[0-9]+		{	/* embedded linenumber */
				int lno;

				lno = dec2i(yytext+1);
				if (lno)	/* ignore the 0's generated by macros */
					line_number = lno;
			}

[ \t\n]+		/* eat up whitespace */

\"[^\"\n]*\"		{
				strcpy(yylval.string, yytext+1);
				yylval.string[strlen(yylval.string)-1] = '\0';
				return STRING;
			}

"+"			{ return ADD; }
"-"			{ return SUB; }
"*"			{ return MUL; }
"/"			{ return DIV; }
"%"			{ return MOD; }
"<<"			{ return SHL; }
">>"			{ return SHR; }
"&&"			{ return LAND; }
"||"			{ return LOR; }
"~"			{ return BNOT; }
"!"			{ return LNOT; }
"&"			{ return BAND; }
"|"			{ return BOR; }
"^"			{ return BXOR; }
"=="			{ return EQ; }
"!="			{ return NEQ; }
">"			{ return GT; }
">="			{ return GEQ; }
"<"			{ return LS; }
"<="			{ return LEQ; }
"("			{ return LPAR; }
")"			{ return RPAR; }
","			{ return COMMA; }
"."			{ return PERIOD; }

.			{ yyerror("Unrecognized character"); }

%%
