/* convert.c				*/
/* convert to/from intel hex etc	*/
/* copyrite (c) Ian King 1994		*/

#include "pu_defs.h"
#include <stdio.h>
#include <string.h>

#define PT	0
#define I16	1

extern void readihex16();
extern void writeihex16();

int	input_type;
int	output_type;

void string_to_types(char *str)
{
	/* not elegant but simple and it works */

	if(strcmp(str,"i16_2_pt")==0)
	{
		input_type  = I16;
		output_type = PT;
		return;
	}

	if(strcmp(str,"pt_2_i16")==0)
	{
		input_type  = PT;
		output_type = I16;
		return;
	}

	printf("Error conversion tool %s doesn't exist\n",str);
	exit(1);
}

void welcome(char *iam)
{
	printf("\nUseage:\n%s <inputfile> <outputfile>\n",iam);
	exit(1);
}

int main(int argc,char *argv[])
{
	PICDEFN pic;
	int filetop;

	if(argc!=3)
		welcome(argv[0]);

	PU_Clear(&pic);

	string_to_types(argv[0]);

	switch(input_type)
	{
		case PT:	PU_Read(argv[1], &pic, &filetop);
				break;

		case I16:	readihex16(argv[1], &pic, &filetop);
				break;
	}

	switch(output_type)
	{
		case PT:	PU_WriteHeader(argv[2], &pic, "Converted from another form");
				PU_WriteBlock(argv[2],&pic,0,filetop);
				PU_WriteTrailer(argv[2],&pic," ----");

				printf("\nNow edit %s to correct pic type and fuse settings\n",argv[2]);
				printf("NB: NEED to write a tool for this!\n");
				break;

		case I16:	writeihex16(argv[2], &pic, filetop);
				break;
	}

	exit(0);
}

/* ... The End ... */
