/* picasm.h */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "../misc/pu_defs.h"

#define VERSION		0.2

#define STRMAX		10000	/* size of lexemes array */
#define SYMMAX		2000	/* size of symtable */

#define BSIZE	128		/* buffer size */
#define MAXSTACK 16		/* max expression stack size */
#define MAXFORWARDJUMPS 1000	/* max number of forward jumps */

#define MAXMACROSTORE	5000	/* maximum macro symbols */
#define MAXMACROS	50	/* maximum number of macros */
#define MAXPARAMS	10	/* maximum macro parameters */
#define MAXLEXLEVELS	16	/* maximum inclusion of macros and includes */
#define MAXSTRINGS	32	/* maximum number of strings in input */

#define NONE	-1
#define EOS	'\0'

#define NUM	256
#define ID	257
#define DONE	258
#define STRING	259

#define HASH		'#'
#define PERIOD		'.'
#define COMMA		','
#define SEMICOLON	';'
#define COLON		':'
#define LPAREN		'('
#define RPAREN		')'
#define LBLOCK		'['
#define RBLOCK		']'
#define LBRACE		'{'
#define RBRACE		'}'
#define PLUS		'+'
#define MINUS		'-'
#define MUL		'*'
#define DIV		'/'
#define MOD		'%'
#define ASSIGN		'='
#define SAME		500		/* ==  */
#define GTR		'>'
#define GTREQ		501		/* >=  */
#define SHR		502		/* >>  */
#define LESS		'<'
#define LESSEQ		503		/* <=  */
#define SHL		504		/* <<  */
#define NOT		'!'
#define NOTEQ		505		/* !=  */
#define COMP		'~'
#define BAND		'&'
#define ANDSY		506		/* &&  */
#define BOR		'|'
#define ORSY		507		/* ||  */
#define BXOR		'^'
#define INCSY		508		/* ++  */
#define DECSY		509		/* --  */
#define DOLLAR		'$'

#define	ADDWF	1000
#define	ANDWF	1001
#define	CLRF	1002
#define	CLRW	1003
#define	COMF	1004
#define	DECF	1005
#define	DECFSZ	1006
#define	INCF	1007
#define	INCFSZ	1008
#define	IORWF	1009
#define	MOVF	1010
#define	MOVWF	1011
#define	NOP	1012
#define	RLF	1013
#define	RRF	1014
#define	SUBWF	1015
#define	SWAPF	1016
#define	XORWF	1017
#define	BCF	1018
#define	BSF	1019
#define	BTFSC	1020
#define	BTFSS	1021
#define	ANDLW	1022
#define	CALL	1023
#define	CLRWDT	1024
#define	GOTO	1025
#define	IORLW	1026
#define	MOVLW	1027
#define	OPTION	1028
#define	RETLW	1029
#define	SLEEP	1030
#define	XORLW	1031
#define TRIS	1032

#define	ADDLW	1033
#define	RETFIE	1034
#define	RETURN	1035
#define	SUBLW	1036

#define DATA	1050

#define ORG	1100
#define EQU	1101
#define END	1102
#define PROC	1103
#define WATCH	1104
#define IDWRDS	1105
#define PWRUP	1106
#define PROTECT	1107
#define CLK	1108
#define	RC	1109
#define LP	1110
#define	XT	1111
#define HS	1112
#define ON	1113
#define OFF	1114

#define IF	1200
#define ELSE	1201
#define ENDIF	1202
#define IFDEF	1203
#define IFNDEF	1204
#define	INCLUDE	1205
#define	MACRO	1206
#define ENDM	1207
#define BEGIN	1208
#define ENDB	1209

/* file or macro for input */

#define LEXFILE		0
#define LEXMACRO	1

#define INVALIDADDR	-1

#define NOARCH	-1
#define PIC12	0
#define PIC14	1

/* symbol types */

#define	KEYWORD		0	/* instruction for either architecture	*/
#define VALUE_DEF	1	/* defined value			*/
#define VALUE_UNDEF	2	/* undefined value			*/
#define MACRO_DEF	3	/* a macro definition			*/
#define MACRO_ARG	4	/* macro argument			*/

#define TRUE	1
#define FALSE	0

typedef struct entry
	{
		char *lexptr;	/* pointer to string of lexical pattern */
		int  token;	/* token identifier (as above)		*/
		int  type;	/* what are we?				*/
		int  value;	/* value of symbol (if applicable)	*/
	} SYMBOL;

typedef struct fj
	{
		int typeofjump;		/* call or goto			*/
					/* also FALSE if already filled */
		SYMBOL *label;		/* label used to contain value	*/
		int address;		/* address in code for opcode	*/
		int lineno;		/* line number in source	*/
		char filename[40];	/* filename jump made in	*/
	} FORWARDJUMP;

typedef struct md
	{
		int numparams;		/* number of parameters		*/
		SYMBOL *params[MAXPARAMS]; /* pointers to the params	*/
		int startsym;		/* start in macro symbol store	*/
		int numsyms;		/* how big the macro is		*/
	} MACDEF;

typedef struct lexin
	{
		int type;		/* are we a file or macro?	*/
		char filename[40];	/* filename (if a file)		*/
		FILE *file;		/* handle on the file		*/
		int whereupto;		/* where up to in symbol store	*/
		int symsleft;		/* number left to get from store*/
		int lineno;
	} LEXINPUT;

/* external function declarations */

extern void error();

extern void cpsym();
extern SYMBOL *insert();
extern SYMBOL *lookup();
extern char *lookupstr();
extern void PrintCurrentSymbol();
extern void SaveSymbols();

extern void init();

extern void program();
extern void match();
extern void getanother();
extern int  expression();
extern void clearstack();

extern void init_code_generator();
extern void save_picfile();
extern void emit_fixed();
extern void emit_literal();
extern void emit_f_b();
extern void emit_f_d();
extern void forwardjump();
extern void fillinjumps();

extern void lexan();
extern int  lexgetchar();
extern void lexungetc();
extern void donumber();
extern void doidentifier();
extern void definemacro();

extern void dostring();

/* external global variable definitions */

extern	FILE	*inputfile;
extern	PICDEFN ourpic;
extern	int	asm_current_address;
extern	int	max_address_touched;
extern	int	min_address_touched;
extern	int	architecture;
extern	char 	lexemes[STRMAX];
extern	SYMBOL	symtable[SYMMAX];
extern	int	lastchar;
extern	int	lastentry;
extern	SYMBOL	current_symbol;
extern	FORWARDJUMP forjump[MAXFORWARDJUMPS];
extern	int	current_forwardjump;
extern	SYMBOL	macrostore[MAXMACROSTORE];
extern	MACDEF	macros[MAXMACROS];
extern	int	last_macro;
extern	int	last_macrostore;
extern	LEXINPUT lexstack[MAXLEXLEVELS];
extern	int	last_lexlevel;

extern	char	lexstrings[MAXSTRINGS][BSIZE];
extern	int	last_string;

/* ... The End ... */

