/*
   DMD.C
   Functions for Dot Matrix Displays
*/

#include "dmd.h"

/*
void dmd_Init(byte *base);
short dmd_WaitBusy(void);
short dmd_Command(byte cmd);
short dmd_Data(byte data);
#define dmd_Home()      (dmd_Command(0x02))
#define dmd_Clear()     (dmd_Command(0x01))
#define dmd_CursorOff() (dmd_Command(0x0c))
#define dmd_DCursorOn() (dmd_Command(0x0e))
#define dmd_BCursorOn() (dmd_Command(0x0f))
*/

static byte *dmd_base;
static byte  dmd_error;
static byte  dmd_cur_x;
static byte  dmd_cur_y;


void dmd_Init(byte *base)
{
   dmd_base = base;
   dmd_error = 0;
   dmd_Command(0x03f);        /* Funktion Set */
   dmd_Command(0x00c);        /* Display on, Cursor off */
   dmd_Command(0x006);        /* Cursor Autoincrement */
   dmd_Clear();
}

short dmd_WaitBusy(void)
{
   short cnt = 100;
   if ( dmd_error != 0 )
      return 0;
   for(;;)
   {
      if ( *dmd_base < 128 )
         break;
      if ( cnt == 0 )
      {
         dmd_error = 1;
         return 1;
      }
      cnt--;
   }
   return 1;
}

short dmd_Command(byte cmd)
{
   if ( dmd_WaitBusy() == 0 )
      return 0;
   dmd_base[0] = cmd; 
   return 1;
}

short dmd_Data(byte data)
{
   if ( dmd_WaitBusy() == 0 )
      return 0;
   dmd_base[1] = data;
   dmd_cur_x++;
   return 1;
}

short dmd_GotoXY(byte x, byte y)
{
   dmd_cur_x = x;
   dmd_cur_y = y;
   if ( y != 0 )
      x |= 0x040;
   x |= 0x080;
   return dmd_Command(x);
}

short dmd_ShowString(char *s)
{
   while( *s != '\0' )
      if ( dmd_Data(*s++) == 0 )
         return 0;
   return 1;
}
