/*
   OS.H

   68HC11 project

   by Oliver Kraus
*/

#ifndef _OS_H
#define _OS_H

#include <common.h>

/*-------------------------------------------------------------------------*/
/* System Functions                                                        */
/*-------------------------------------------------------------------------*/

/* number of interrupt functions (needed for os_set_irq and os_get_irq) */
#define OS_IRQ_NONE1    0
#define OS_IRQ_NONE2    1
#define OS_IRQ_NONE3    2
#define OS_IRQ_SCI      3
#define OS_IRQ_SPI      4
#define OS_IRQ_PAIE     5
#define OS_IRQ_PAO      6
#define OS_IRQ_TO       7
#define OS_IRQ_TOC5     8
#define OS_IRQ_TOC4     9
#define OS_IRQ_TOC3    10
#define OS_IRQ_TOC2    11
#define OS_IRQ_TOC1    12
#define OS_IRQ_TIC3    13
#define OS_IRQ_TIC2    14
#define OS_IRQ_TIC1    15
#define OS_IRQ_RTI     16
#define OS_IRQ_IRQ     17
#define OS_IRQ_XIRQ    18
#define OS_IRQ_SWI     19
#define OS_IRQ_ILLEGAL 20
#define OS_IRQ_COP     21
#define OS_IRQ_CLOCK   22
#define OS_IRQ_RESET   23     /* not implemented */

/* void (*fn)() must be a normal function (don't  use #pragma interrupt) */
void os_set_irq(int number, void (*fn)() );
void (*os_get_irq(int number))();
void os_disable(void);  /* don't allow interrupts */
void os_enable(void);   /* allow interrupts */

/*-------------------------------------------------------------------------*/
/* System Variables                                                        */
/*-------------------------------------------------------------------------*/
extern byte *os_io_base;  /* 68HC11 IO-Area baseadress */

#endif
