This is Info file gcc.info, produced by Makeinfo-1.54 from the input
file gcc.texi.

   This file documents the use and the internals of the GNU compiler.

   Published by the Free Software Foundation 675 Massachusetts Avenue
Cambridge, MA 02139 USA

   Copyright (C) 1988, 1989, 1992, 1993 Free Software Foundation, Inc.

   Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

   Permission is granted to copy and distribute modified versions of
this manual under the conditions for verbatim copying, provided also
that the sections entitled "GNU General Public License" and "Protect
Your Freedom--Fight `Look And Feel'" are included exactly as in the
original, and provided that the entire resulting derived work is
distributed under the terms of a permission notice identical to this
one.

   Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that the sections entitled "GNU General Public
License" and "Protect Your Freedom--Fight `Look And Feel'", and this
permission notice, may be included in translations approved by the Free
Software Foundation instead of in the original English.


File: gcc.info,  Node: Optimize Options,  Next: Preprocessor Options,  Prev: Debugging Options,  Up: Invoking GCC

Options That Control Optimization
=================================

   These options control various sorts of optimizations:

`-O'
`-O1'
     Optimize.  Optimizing compilation takes somewhat more time, and a
     lot more memory for a large function.

     Without `-O', the compiler's goal is to reduce the cost of
     compilation and to make debugging produce the expected results.
     Statements are independent: if you stop the program with a
     breakpoint between statements, you can then assign a new value to
     any variable or change the program counter to any other statement
     in the function and get exactly the results you would expect from
     the source code.

     Without `-O', the compiler only allocates variables declared
     `register' in registers.  The resulting compiled code is a little
     worse than produced by PCC without `-O'.

     With `-O', the compiler tries to reduce code size and execution
     time.

     When you specify `-O', the compiler turns on `-fthread-jumps' and
     `-fdefer-pop' on all machines.  The compiler turns on
     `-fdelayed-branch' on machines that have delay slots, and
     `-fomit-frame-pointer' on machines that can support debugging even
     without a frame pointer.  On some machines the compiler also turns
     on other flags.

`-O2'
     Optimize even more.  GNU CC performs nearly all supported
     optimizations that do not involve a space-speed tradeoff.  The
     compiler does not perform loop unrolling or function inlining when
     you specify `-O2'.  As compared to `-O', this option increases
     both compilation time and the performance of the generated code.

     `-O2' turns on all optional optimizations except for loop
     unrolling, function inlining, and, on machines where it interfers
     with debugging, frame pointer elimination.

`-O3'
     Optimize yet more.  `-O3' turns on all optimizations specified by
     `-O2' and also turns on the `inline-functions' option.

`-O0'
     Do not optimize.

     If you use multiple `-O' options, with or without level numbers,
     the last such option is the one that is effective.

   Options of the form `-fFLAG' specify machine-independent flags.
Most flags have both positive and negative forms; the negative form of
`-ffoo' would be `-fno-foo'.  In the table below, only one of the forms
is listed--the one which is not the default.  You can figure out the
other form by either removing `no-' or adding it.

`-ffloat-store'
     Do not store floating point variables in registers, and inhibit
     other options that might change whether a floating point value is
     taken from a register or memory.

     This option prevents undesirable excess precision on machines such
     as the 68000 where the floating registers (of the 68881) keep more
     precision than a `double' is supposed to have.  For most programs,
     the excess precision does only good, but a few programs rely on the
     precise definition of IEEE floating point.  Use `-ffloat-store' for
     such programs.

`-fno-default-inline'
     Do not make member functions inline by default merely because they
     are defined inside the class scope (C++ only).  Otherwise, when
     you specify `-O', member functions defined inside class scope are
     compiled inline by default; i.e., you don't need to add `inline'
     in front of the member function name.

`-fno-defer-pop'
     Always pop the arguments to each function call as soon as that
     function returns.  For machines which must pop arguments after a
     function call, the compiler normally lets arguments accumulate on
     the stack for several function calls and pops them all at once.

`-fforce-mem'
     Force memory operands to be copied into registers before doing
     arithmetic on them.  This may produce better code by making all
     memory references potential common subexpressions.  When they are
     not common subexpressions, instruction combination should
     eliminate the separate register-load.  I am interested in hearing
     about the difference this makes.

`-fforce-addr'
     Force memory address constants to be copied into registers before
     doing arithmetic on them.  This may produce better code just as
     `-fforce-mem' may.  I am interested in hearing about the
     difference this makes.

`-fomit-frame-pointer'
     Don't keep the frame pointer in a register for functions that
     don't need one.  This avoids the instructions to save, set up and
     restore frame pointers; it also makes an extra register available
     in many functions.  *It also makes debugging impossible on some
     machines.*

     On some machines, such as the Vax, this flag has no effect, because
     the standard calling sequence automatically handles the frame
     pointer and nothing is saved by pretending it doesn't exist.  The
     machine-description macro `FRAME_POINTER_REQUIRED' controls
     whether a target machine supports this flag.  *Note Registers::.

`-fno-inline'
     Don't pay attention to the `inline' keyword.  Normally this option
     is used to keep the compiler from expanding any functions inline.
     Note that if you are not optimizing, no functions can be expanded
     inline.

`-finline-functions'
     Integrate all simple functions into their callers.  The compiler
     heuristically decides which functions are simple enough to be worth
     integrating in this way.

     If all calls to a given function are integrated, and the function
     is declared `static', then the function is normally not output as
     assembler code in its own right.

`-fkeep-inline-functions'
     Even if all calls to a given function are integrated, and the
     function is declared `static', nevertheless output a separate
     run-time callable version of the function.

`-fno-function-cse'
     Do not put function addresses in registers; make each instruction
     that calls a constant function contain the function's address
     explicitly.

     This option results in less efficient code, but some strange hacks
     that alter the assembler output may be confused by the
     optimizations performed when this option is not used.

`-ffast-math'
     This option allows GCC to violate some ANSI or IEEE rules and/or
     specifications in the interest of optimizing code for speed.  For
     example, it allows the compiler to assume arguments to the `sqrt'
     function are non-negative numbers and that no floating-point values
     are NaNs.

     This option should never be turned on by any `-O' option since it
     can result in incorrect output for programs which depend on an
     exact implementation of IEEE or ANSI rules/specifications for math
     functions.

   The following options control specific optimizations.  The `-O2'
option turns on all of these optimizations except `-funroll-loops' and
`-funroll-all-loops'.  On most machines, the `-O' option turns on the
`-fthread-jumps' and `-fdelayed-branch' options, but specific machines
may handle it differently.

   You can use the following flags in the rare cases when "fine-tuning"
of optimizations to be performed is desired.

`-fstrength-reduce'
     Perform the optimizations of loop strength reduction and
     elimination of iteration variables.

`-fthread-jumps'
     Perform optimizations where we check to see if a jump branches to a
     location where another comparison subsumed by the first is found.
     If so, the first branch is redirected to either the destination of
     the second branch or a point immediately following it, depending
     on whether the condition is known to be true or false.

`-fcse-follow-jumps'
     In common subexpression elimination, scan through jump instructions
     when the target of the jump is not reached by any other path.  For
     example, when CSE encounters an `if' statement with an `else'
     clause, CSE will follow the jump when the condition tested is
     false.

`-fcse-skip-blocks'
     This is similar to `-fcse-follow-jumps', but causes CSE to follow
     jumps which conditionally skip over blocks.  When CSE encounters a
     simple `if' statement with no else clause, `-fcse-skip-blocks'
     causes CSE to follow the jump around the body of the `if'.

`-frerun-cse-after-loop'
     Re-run common subexpression elimination after loop optimizations
     has been performed.

`-fexpensive-optimizations'
     Perform a number of minor optimizations that are relatively
     expensive.

`-fdelayed-branch'
     If supported for the target machine, attempt to reorder
     instructions to exploit instruction slots available after delayed
     branch instructions.

`-fschedule-insns'
     If supported for the target machine, attempt to reorder
     instructions to eliminate execution stalls due to required data
     being unavailable.  This helps machines that have slow floating
     point or memory load instructions by allowing other instructions
     to be issued until the result of the load or floating point
     instruction is required.

`-fschedule-insns2'
     Similar to `-fschedule-insns', but requests an additional pass of
     instruction scheduling after register allocation has been done.
     This is especially useful on machines with a relatively small
     number of registers and where memory load instructions take more
     than one cycle.

`-fcaller-saves'
     Enable values to be allocated in registers that will be clobbered
     by function calls, by emitting extra instructions to save and
     restore the registers around such calls.  Such allocation is done
     only when it seems to result in better code than would otherwise
     be produced.

     This option is enabled by default on certain machines, usually
     those which have no call-preserved registers to use instead.

`-funroll-loops'
     Perform the optimization of loop unrolling.  This is only done for
     loops whose number of iterations can be determined at compile time
     or run time.  `-funroll-loop' implies both `-fstrength-reduce' and
     `-frerun-cse-after-loop'.

`-funroll-all-loops'
     Perform the optimization of loop unrolling.  This is done for all
     loops and usually makes programs run more slowly.
     `-funroll-all-loops' implies `-fstrength-reduce' as well as
     `-frerun-cse-after-loop'.

`-fno-peephole'
     Disable any machine-specific peephole optimizations.


File: gcc.info,  Node: Preprocessor Options,  Next: Assembler Options,  Prev: Optimize Options,  Up: Invoking GCC

Options Controlling the Preprocessor
====================================

   These options control the C preprocessor, which is run on each C
source file before actual compilation.

   If you use the `-E' option, nothing is done except preprocessing.
Some of these options make sense only together with `-E' because they
cause the preprocessor output to be unsuitable for actual compilation.

`-include FILE'
     Process FILE as input before processing the regular input file.
     In effect, the contents of FILE are compiled first.  Any `-D' and
     `-U' options on the command line are always processed before
     `-include FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-imacros FILE'
     Process FILE as input, discarding the resulting output, before
     processing the regular input file.  Because the output generated
     from FILE is discarded, the only effect of `-imacros FILE' is to
     make the macros defined in FILE available for use in the main
     input.

     Any `-D' and `-U' options on the command line are always processed
     before `-imacros FILE', regardless of the order in which they are
     written.  All the `-include' and `-imacros' options are processed
     in the order in which they are written.

`-idirafter DIR'
     Add the directory DIR to the second include path.  The directories
     on the second include path are searched when a header file is not
     found in any of the directories in the main include path (the one
     that `-I' adds to).

`-iprefix PREFIX'
     Specify PREFIX as the prefix for subsequent `-iwithprefix' options.

`-iwithprefix DIR'
     Add a directory to the second include path.  The directory's name
     is made by concatenating PREFIX and DIR, where PREFIX was
     specified previously with `-iprefix'.  If you have not specified a
     prefix yet, the directory containing the installed passes of the
     compiler is used as the default.

`-iwithprefixbefore DIR'
     Add a directory to the main include path.  The directory's name is
     made by concatenating PREFIX and DIR, as in the case of
     `-iwithprefix'.

`-isystem DIR'
     Add a directory to the beginning of the second include path,
     marking it as a system directory, so that it gets the same special
     treatment as is applied to the standard system directories.

`-nostdinc'
     Do not search the standard system directories for header files.
     Only the directories you have specified with `-I' options (and the
     current directory, if appropriate) are searched.  *Note Directory
     Options::, for information on `-I'.

     By using both `-nostdinc' and `-I-', you can limit the include-file
     search path to only those directories you specify explicitly.

`-undef'
     Do not predefine any nonstandard macros.  (Including architecture
     flags).

`-E'
     Run only the C preprocessor.  Preprocess all the C source files
     specified and output the results to standard output or to the
     specified output file.

`-C'
     Tell the preprocessor not to discard comments.  Used with the `-E'
     option.

`-P'
     Tell the preprocessor not to generate `#line' commands.  Used with
     the `-E' option.

`-M'
     Tell the preprocessor to output a rule suitable for `make'
     describing the dependencies of each object file.  For each source
     file, the preprocessor outputs one `make'-rule whose target is the
     object file name for that source file and whose dependencies are
     all the `#include' header files it uses.  This rule may be a
     single line or may be continued with `\'-newline if it is long.
     The list of rules is printed on standard output instead of the
     preprocessed C program.

     `-M' implies `-E'.

     Another way to specify output of a `make' rule is by setting the
     environment variable `DEPENDENCIES_OUTPUT' (*note Environment
     Variables::.).

`-MM'
     Like `-M' but the output mentions only the user header files
     included with `#include "FILE"'.  System header files included
     with `#include <FILE>' are omitted.

`-MD'
     Like `-M' but the dependency information is written to a file made
     by replacing ".c" with ".d" at the end of the input file names.
     This is in addition to compiling the file as specified--`-MD' does
     not inhibit ordinary compilation the way `-M' does.

     In Mach, you can use the utility `md' to merge multiple dependency
     files into a single dependency file suitable for using with the
     `make' command.

`-MMD'
     Like `-MD' except mention only user header files, not system
     header files.

`-MG'
     Treat missing header files as generated files and assume they live
     in the same directory as the source file.  If you specify `-MG',
     you must also specify either `-M' or `-MM'.  `-MG' is not
     supported with `-MD' or `-MMD'.

`-H'
     Print the name of each header file used, in addition to other
     normal activities.

`-AQUESTION(ANSWER)'
     Assert the answer ANSWER for QUESTION, in case it is tested with a
     preprocessor conditional such as `#if #QUESTION(ANSWER)'.  `-A-'
     disables the standard assertions that normally describe the target
     machine.

`-DMACRO'
     Define macro MACRO with the string `1' as its definition.

`-DMACRO=DEFN'
     Define macro MACRO as DEFN.  All instances of `-D' on the command
     line are processed before any `-U' options.

`-UMACRO'
     Undefine macro MACRO.  `-U' options are evaluated after all `-D'
     options, but before any `-include' and `-imacros' options.

`-dM'
     Tell the preprocessor to output only a list of the macro
     definitions that are in effect at the end of preprocessing.  Used
     with the `-E' option.

`-dD'
     Tell the preprocessing to pass all macro definitions into the
     output, in their proper sequence in the rest of the output.

`-dN'
     Like `-dD' except that the macro arguments and contents are
     omitted.  Only `#define NAME' is included in the output.

`-trigraphs'
     Support ANSI C trigraphs.  The `-ansi' option also has this effect.


File: gcc.info,  Node: Assembler Options,  Next: Link Options,  Prev: Preprocessor Options,  Up: Invoking GCC

Passing Options to the Assembler
================================

`-Wa,OPTION'
     Pass OPTION as an option to the assembler.  If OPTION contains
     commas, it is split into multiple options at the commas.


File: gcc.info,  Node: Link Options,  Next: Directory Options,  Prev: Assembler Options,  Up: Invoking GCC

Options for Linking
===================

   These options come into play when the compiler links object files
into an executable output file.  They are meaningless if the compiler is
not doing a link step.

`OBJECT-FILE-NAME'
     A file name that does not end in a special recognized suffix is
     considered to name an object file or library.  (Object files are
     distinguished from libraries by the linker according to the file
     contents.)  If linking is done, these object files are used as
     input to the linker.

`-c'
`-S'
`-E'
     If any of these options is used, then the linker is not run, and
     object file names should not be used as arguments.  *Note Overall
     Options::.

`-lLIBRARY'
     Search the library named LIBRARY when linking.

     It makes a difference where in the command you write this option;
     the linker searches processes libraries and object files in the
     order they are specified.  Thus, `foo.o -lz bar.o' searches
     library `z' after file `foo.o' but before `bar.o'.  If `bar.o'
     refers to functions in `z', those functions may not be loaded.

     The linker searches a standard list of directories for the library,
     which is actually a file named `libLIBRARY.a'.  The linker then
     uses this file as if it had been specified precisely by name.

     The directories searched include several standard system
     directories plus any that you specify with `-L'.

     Normally the files found this way are library files--archive files
     whose members are object files.  The linker handles an archive
     file by scanning through it for members which define symbols that
     have so far been referenced but not defined.  But if the file that
     is found is an ordinary object file, it is linked in the usual
     fashion.  The only difference between using an `-l' option and
     specifying a file name is that `-l' surrounds LIBRARY with `lib'
     and `.a' and searches several directories.

`-lobjc'
     You need this special case of the `-l' option in order to link an
     Objective C program.

`-nostartfiles'
     Do not use the standard system startup files when linking.  The
     standard libraries are used normally.

`-nostdlib'
     Do not use the standard system libraries and startup files when
     linking.  Only the files you specify will be passed to the linker.

     One of the standard libraries bypassed by `-nostdlib' is
     `libgcc.a', a library of internal subroutines that GNU CC uses to
     overcome shortcomings of particular machines, or special needs for
     some languages.  (*Note Interfacing to GNU CC Output: Interface,
     for more discussion of `libgcc.a'.) In most cases, you need
     `libgcc.a' even when you want to avoid other standard libraries.
     In other words, when you specify `-nostdlib' you should usually
     specify `-lgcc' as well.  This ensures that you have no unresolved
     references to internal GNU CC library subroutines.  (For example,
     `__main', used to ensure C++ constructors will be called; *note
     `collect2': Collect2..)

`-static'
     On systems that support dynamic linking, this prevents linking
     with the shared libraries.  On other systems, this option has no
     effect.

`-shared'
     Produce a shared object which can then be linked with other
     objects to form an executable.  Only a few systems support this
     option.

`-symbolic'
     Bind references to global symbols when building a shared object.
     Warn about any unresolved references (unless overridden by the
     link editor option `-Xlinker -z -Xlinker defs').  Only a few
     systems support this option.

`-Xlinker OPTION'
     Pass OPTION as an option to the linker.  You can use this to
     supply system-specific linker options which GNU CC does not know
     how to recognize.

     If you want to pass an option that takes an argument, you must use
     `-Xlinker' twice, once for the option and once for the argument.
     For example, to pass `-assert definitions', you must write
     `-Xlinker -assert -Xlinker definitions'.  It does not work to write
     `-Xlinker "-assert definitions"', because this passes the entire
     string as a single argument, which is not what the linker expects.

`-Wl,OPTION'
     Pass OPTION as an option to the linker.  If OPTION contains
     commas, it is split into multiple options at the commas.

`-u SYMBOL'
     Pretend the symbol SYMBOL is undefined, to force linking of
     library modules to define it.  You can use `-u' multiple times with
     different symbols to force loading of additional library modules.


File: gcc.info,  Node: Directory Options,  Next: Target Options,  Prev: Link Options,  Up: Invoking GCC

Options for Directory Search
============================

   These options specify directories to search for header files, for
libraries and for parts of the compiler:

`-IDIR'
     Append directory DIR to the list of directories searched for
     include files.

`-I-'
     Any directories you specify with `-I' options before the `-I-'
     option are searched only for the case of `#include "FILE"'; they
     are not searched for `#include <FILE>'.

     If additional directories are specified with `-I' options after
     the `-I-', these directories are searched for all `#include'
     directives.  (Ordinarily *all* `-I' directories are used this way.)

     In addition, the `-I-' option inhibits the use of the current
     directory (where the current input file came from) as the first
     search directory for `#include "FILE"'.  There is no way to
     override this effect of `-I-'.  With `-I.' you can specify
     searching the directory which was current when the compiler was
     invoked.  That is not exactly the same as what the preprocessor
     does by default, but it is often satisfactory.

     `-I-' does not inhibit the use of the standard system directories
     for header files.  Thus, `-I-' and `-nostdinc' are independent.

`-LDIR'
     Add directory DIR to the list of directories to be searched for
     `-l'.

`-BPREFIX'
     This option specifies where to find the executables, libraries,
     include files, and data files of the compiler itself.

     The compiler driver program runs one or more of the subprograms
     `cpp', `cc1', `as' and `ld'.  It tries PREFIX as a prefix for each
     program it tries to run, both with and without `MACHINE/VERSION/'
     (*note Target Options::.).

     For each subprogram to be run, the compiler driver first tries the
     `-B' prefix, if any.  If that name is not found, or if `-B' was
     not specified, the driver tries two standard prefixes, which are
     `/usr/lib/gcc/' and `/usr/local/lib/gcc-lib/'.  If neither of
     those results in a file name that is found, the unmodified program
     name is searched for using the directories specified in your
     `PATH' environment variable.

     `-B' prefixes that effectively specify directory names also apply
     to libraries in the linker, because the compiler translates these
     options into `-L' options for the linker.  They also apply to
     includes files in the preprocessor, because the compiler
     translates these options into `-isystem' options for the
     preprocessor.  In this case, the compiler appends `include' to the
     prefix.

     The run-time support file `libgcc.a' can also be searched for using
     the `-B' prefix, if needed.  If it is not found there, the two
     standard prefixes above are tried, and that is all.  The file is
     left out of the link if it is not found by those means.

     Another way to specify a prefix much like the `-B' prefix is to use
     the environment variable `GCC_EXEC_PREFIX'.  *Note Environment
     Variables::.


File: gcc.info,  Node: Target Options,  Next: Submodel Options,  Prev: Directory Options,  Up: Invoking GCC

Specifying Target Machine and Compiler Version
==============================================

   By default, GNU CC compiles code for the same type of machine that
you are using.  However, it can also be installed as a cross-compiler,
to compile for some other type of machine.  In fact, several different
configurations of GNU CC, for different target machines, can be
installed side by side.  Then you specify which one to use with the
`-b' option.

   In addition, older and newer versions of GNU CC can be installed side
by side.  One of them (probably the newest) will be the default, but
you may sometimes wish to use another.

`-b MACHINE'
     The argument MACHINE specifies the target machine for compilation.
     This is useful when you have installed GNU CC as a cross-compiler.

     The value to use for MACHINE is the same as was specified as the
     machine type when configuring GNU CC as a cross-compiler.  For
     example, if a cross-compiler was configured with `configure
     i386v', meaning to compile for an 80386 running System V, then you
     would specify `-b i386v' to run that cross compiler.

     When you do not specify `-b', it normally means to compile for the
     same type of machine that you are using.

`-V VERSION'
     The argument VERSION specifies which version of GNU CC to run.
     This is useful when multiple versions are installed.  For example,
     VERSION might be `2.0', meaning to run GNU CC version 2.0.

     The default version, when you do not specify `-V', is controlled
     by the way GNU CC is installed.  Normally, it will be a version
     that is recommended for general use.

   The `-b' and `-V' options actually work by controlling part of the
file name used for the executable files and libraries used for
compilation.  A given version of GNU CC, for a given target machine, is
normally kept in the directory `/usr/local/lib/gcc-lib/MACHINE/VERSION'.

   Thus, sites can customize the effect of `-b' or `-V' either by
changing the names of these directories or adding alternate names (or
symbolic links).  If in directory `/usr/local/lib/gcc-lib/' the file
`80386' is a link to the file `i386v', then `-b 80386' becomes an alias
for `-b i386v'.

   In one respect, the `-b' or `-V' do not completely change to a
different compiler: the top-level driver program `gcc' that you
originally invoked continues to run and invoke the other executables
(preprocessor, compiler per se, assembler and linker) that do the real
work.  However, since no real work is done in the driver program, it
usually does not matter that the driver program in use is not the one
for the specified target and version.

   The only way that the driver program depends on the target machine is
in the parsing and handling of special machine-specific options.
However, this is controlled by a file which is found, along with the
other executables, in the directory for the specified version and
target machine.  As a result, a single installed driver program adapts
to any specified target machine and compiler version.

   The driver program executable does control one significant thing,
however: the default version and target machine.  Therefore, you can
install different instances of the driver program, compiled for
different targets or versions, under different names.

   For example, if the driver for version 2.0 is installed as `ogcc'
and that for version 2.1 is installed as `gcc', then the command `gcc'
will use version 2.1 by default, while `ogcc' will use 2.0 by default.
However, you can choose either version with either command with the
`-V' option.


File: gcc.info,  Node: Submodel Options,  Next: Code Gen Options,  Prev: Target Options,  Up: Invoking GCC

Hardware Models and Configurations
==================================

   Earlier we discussed the standard option `-b' which chooses among
different installed compilers for completely different target machines,
such as Vax vs. 68000 vs. 80386.

   In addition, each of these target machine types can have its own
special options, starting with `-m', to choose among various hardware
models or configurations--for example, 68010 vs 68020, floating
coprocessor or none.  A single installed version of the compiler can
compile for any model or configuration, according to the options
specified.

   Some configurations of the compiler also support additional special
options, usually for compatibility with other compilers on the same
platform.

   These options are defined by the macro `TARGET_SWITCHES' in the
machine description.  The default for the options is also defined by
that macro, which enables you to change the defaults.


