;****************************************************************
;**           :
;** Project   : Personal Logic Debugger (PLD)
;** Filename  : REGS.ASM
;** Author    : Don Lekei
;** Status    : Experimental
;** Date      : 08/27/93
;** Purpose   : Define internal register (file) usage
;**           :
;****************************************************************

;*******************************************************************
;* INTERNAL REGISTER DECLARATIONS - 16C71
;* These are not needed by ASPIC, but the simulator needs the labels
;* Alternate bank registers are not defined here
;*******************************************************************

;+----+---------+---------------------------------+
;| no |  name   |            function             |
;+----+---------+---------------------------------+
;|  0 | ind     | indirect register addressing    |
;|  1 | RTCC    | real time clock counter         |
;|  2 | PC      | program counter                 |
;|  3 | STATUS  | CPU status                      |
;|  4 | FSR     | file select register            |
;|  5 | PORTA   | 5 bit I/O port / A/D            |
;|  6 | PORTB   | 8 bit I/O port / Interrupts     |
;|  7 |  ***    | (reserved for future expansion) |
;|  8 | ADCON0  | A/D Control Register            |
;|  9 | ADRES   | A/D Result                      |
;|  A | PCLATH  | PC high latch                   |
;|  B | INTCON  | interrupt control register      |
;+----+---------+---------------------------------+
        .seg    REGS            ;org for register declarations

ind     .ds     1               ;Pseudo-reg 0 for INDIRECT (FSR)
RTCC    .ds     1               ;Real time counter
PCL     .ds     1               ;PC
STATUS  .ds     1               ;STATUS REG

FSR     .ds     1               ;File select reg 0-4=indirect add.dss

;************************************************************************
;*
;* PORT A Definitions
;*
;************************************************************************

B.PROBE		= 0,*           ;Probe input / AN0 (MUST BE BIT 0)
B.BP2		= 1,*           ;LCD backplane bit (3 level)
B.BP1		= 2,*           ;LCD backplane bit (3 level) 
B.BP3		= 3,*           ;LCD backplane bit (3 level) 
B.SCALE		= 4,*           ;Scale / Bias for Probe, RTCC IN, schmitt

PORTA   	.ds 1           ;Port A I/O register (4 bits)

TAINIT =       ^B.PROBE|^B.BP1|^B.BP2|^B.BP3  ;initial TRISA value 1=input
PAINIT  =      ^B.SCALE		          ;port A init

;*************************************************************************
;**
;** PORT B Definitions
;**
;** Each of these pins has at least 2 names and 2 uses depending on the 
;** state care must be taken that one use does not voilate the others 
;** requirements. 
;**
;*************************************************************************

B.CLOCK	        = 0,*           ;Backplane / Serial shift clock / keyboard
B.KEY1	        = 0,*           ;
B.PWR	        = 1,*           ;Power to segment driver
B.KEY2		= 2,*           ;Keyboard scan / LCD seg 24
B.S24	        = 2,*           ;
B.KEY3		= 3,*           ;Keyboard scan / LCD seg 23
B.S23	        = 3,*           ;
B.KEY4		= 4,*           ;Keyboard scan / LCD seg 22
B.S22	        = 4,*           ;
B.KEY5		= 5,*           ;Keyboard scan / LCD seg 21 / SR strobe
B.S21	        = 5,*           ;
B.STROBE	= 5,*		;
B.KEY6		= 6,*           ;Keyboard scan / LCD seg 20 / SR data L
B.S20	        = 6,*           ;
B.DATA1	        = 6,*           ;Data bit (2 bit serial)
B.KEY7		= 7,*           ;Keyboard scan / LCD seg 19 / SR data H
B.S19	        = 7,*           ;
B.DATA0	        = 7,*           ;Data bit (2 bit serial)

PORTB           .ds 1		;Port B I/O register

TBINIT          = 0		;initial TRISB 1=input
TBKEYS		= ~(^B.CLOCK|^B.PWR)   ;tris for key scan (in except clock&pwr)
PBINIT          = ^B.CLOCK|^B.PWR    ;port b init


		.ds 1	;reserved

;*** Bits in ADCON0 ***

ADON		= 0,*           ;A/D hardware enable
ADIF		= 1,*           ;A/D interrupt flag
GO		= 2,*		;Set bit to start A/D, reset when done
B.SPARE1	= 5,*		;spare bit

ADCON0:		.ds 1	;A/D Control Register
AD0INIT		= %10000001	;default ADCON0 register
		  ;||||||||
		  ;|||||||+---- ADON : A/D hardware enable                   
		  ;||||||+----- ADIF : A/D interrupt flag                    
		  ;|||||+------ ADGO : Set bit to start A/D, reset when done 
		  ;||||+------- \ A/D channel select 0-3 = RA0-3
		  ;|||+-------- /
		  ;||+--------- (spare bit)
		  ;|+---------- \ A/D clock select 00 = fosc/2,  01 = fosc/8
		  ;+----------- /                  10 = fosc/32, 11 = internal

ADRES:    	.ds 1	;A/D Result
PCLATH:   	.ds 1	;PC high latch
INTCON:   	.ds 1	;interrupt control register
INTINIT		= %01000000	;default ADCON0 register
		  ;||||||||
		  ;|||||||+---- RBIF : Port B Change flag
		  ;||||||+----- INTF : INT (RB0) edge detect flag
		  ;|||||+------ RTIF : RTCC overflow flag
		  ;||||+------- RBIE : PORTB change interrupt enable
		  ;|||+-------- INTE : INT (RB0) interrupt enable
		  ;||+--------- RTIE : RTCC interrupt enable
		  ;|+---------- ADIE : A/D interrupt enable 
		  ;+----------- GIE  : Global interrupt enable

	  .seg	REGS2

		.ds 1
OPTION:		.ds 1	;option register

OPTINIT		= %00000000	;default OPTION register
		  ;||||||||
		  ;|||||||+---- \
		  ;||||||+----- |- Prescaler exponent
		  ;|||||+------ /
		  ;||||+------- PSA    : Prescaler dest - 1=WDT, 0=RTCC
		  ;|||+-------- RTE    : RTCC edge - 1=v 0=^
		  ;||+--------- RTS    : RTCC Source 1=EXT 0=INT
		  ;|+---------- INTEDG : INT (RB0) Edge - 1=^ 0=v
		  ;+----------- RBPU   : Port B weak pullup enable 0=on

		.ds 3
TRISA:  	.ds 1
TRISB:          .ds 1
		.ds 1
ADCON1:		.ds 1
AD1INIT		= %00000011	;default ADCON1 register 2 bits
		  ;      ||        PA 3 2 1 0  REF    A=analog, D=Digital
		  ;      |+----\ 00   A A A A  VDD
		  ;      +-----/ 01   - A A A  RA3
		  ;              10   D D A A  VDD
		  ;              11   D D D D  VDD (can still use ADC)

	  .seg	REGS
;**********************************************************************
;* 
;* Start of program-specific registers. More are defined in the modules
;* in which they are required.
;* 
;**********************************************************************

REGBASE:		;first reg cleared by RESET code.

TEMP:		.ds 1	;General temporary reg. for LOCAL USE ONLY.
TEMP2:		.ds 1	;General temporary reg. for LOCAL USE ONLY.
DSPTEMP1:	.ds 1	;General temporary reg. corrupted by DISPLAY ROUTINES.
DSPTEMP2:	.ds 1	;General temporary reg. corrupted by DISPLAY ROUTINEs.
TEMP3:		.ds 1	;General temporary reg. for LOCAL USE ONLY.

MISCFLAGS:		;miscelaneous flags
B.RA5ON 	= 0,*	;Flag - RA5 (attenuator) is ON (set to 0)
B.NEWLOGIC	= 1,*	;Flag - new logic cycle
B.ZEROENAB	= 2,*	;Flag enable zeros for display (0=trim leading 0's)
B.PULSE		= 3,*	;Probe detected a pulse
B.PULSE2	= 4,*	;Time delayed PULSE detect
B.SLOPE		= 5,*	;Flag - negative slope on waveform
B.NUMPROC	= 6,*	;FLAG - enterring a number (LCD and VALUE are valid)
B.ONETRIG	= 7,*	;Flag - Single trigger only
		.ds 1	;


DISPLAY:        .ds 8   ;Display buffer
DISPLAYF:               ;flags for LCD display ledgends
;B.		= 0,*	;
;B.		= 1,*	;
;B.		= 2,*	;
;B.		= 3,*	;
;B.		= 4,*	;
B.SEG_MINUS	= 5,*	;LCD "-" BP3,S7
B.SEG_M		= 6,*	;LCD "M" BP3,S4
B.SEG_E		= 7,*	;LCD "E" BP3,S1
		.ds 1   ;Display flags

VSENSE:		.ds 1	;Analog voltage
VSENSEH:	.ds 1	;Analog voltage when B.CLOCK is HIGH
VSENSEL:	.ds 1	;Analog voltage when B.CLOCK is LOW

LOGICPAT:	.ds 1	;Logic pattern (bits)

;**********************************************************************
;* INFO FROM KEYBOARD 
;**********************************************************************


CURKEY:		.ds 1	;current key down
LASTKEY:	.ds 1	;current key reported
KEYBUF:		.ds 1	;key buffer (0 = no key)

VALUE:		.ds 4	;value from display

